/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.reqtotest.graphtransformer;

import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.reqtotest.req.Req2TestReqSymbolTable;
import de.uni_freiburg.informatik.ultimate.reqtotest.req.ReqGuardGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AuxVarGen {
    public static final String DEFINE_PREFIX = "d_";
    public static final String USE_PREFIX = "u_";
    public static final String CLOCK_PREFIX = "t_";
    private final Sort mSortBool;
    private final Sort mSortInt;
    private final Term mSmtTrue;
    private final Term mSmtFalse;
    private final Req2TestReqSymbolTable mReqSymbolTable;
    private final ILogger mLogger;
    private final Script mScript;
    private final Map<TermVariable, Term> mVariableToUseTerm;
    private final Map<TermVariable, Set<Term>> mVariableToDefineTerm;
    private final Map<ReqGuardGraph, Integer> mReqToId;
    private int mReqId = 0;
    private final HashMap<ReqGuardGraph, Term> mEffects;
    private final Map<ReqGuardGraph, Term> mReqToDefineAnnotation;
    private final Map<ReqGuardGraph, Term> mReqToNonDefineAnnotation;

    public AuxVarGen(ILogger iLogger, Script script, Req2TestReqSymbolTable req2TestReqSymbolTable) {
        this.mReqSymbolTable = req2TestReqSymbolTable;
        this.mLogger = iLogger;
        this.mScript = script;
        this.mEffects = new HashMap();
        this.mVariableToUseTerm = new LinkedHashMap<TermVariable, Term>();
        this.mVariableToDefineTerm = new LinkedHashMap<TermVariable, Set<Term>>();
        this.mReqToDefineAnnotation = new LinkedHashMap<ReqGuardGraph, Term>();
        this.mReqToNonDefineAnnotation = new LinkedHashMap<ReqGuardGraph, Term>();
        this.mReqToId = new LinkedHashMap<ReqGuardGraph, Integer>();
        this.mSortInt = this.mScript.sort("Int", new Sort[0]);
        this.mSortBool = this.mScript.sort("Bool", new Sort[0]);
        this.mSmtTrue = this.mScript.term("true", new Term[0]);
        this.mSmtFalse = this.mScript.term("false", new Term[0]);
    }

    public void setEffectLabel(ReqGuardGraph reqGuardGraph, Term term) {
        TermVariable[] termVariableArray = new TermVariable[]{};
        if (SmtUtils.getDisjuncts((Term)term).length <= 1) {
            this.mEffects.put(reqGuardGraph, term);
            termVariableArray = term.getFreeVars();
        } else {
            this.mLogger.error((Object)("Nondeterministic requirement: " + reqGuardGraph.getName()));
        }
        List<TermVariable> list = this.getNonInputNonConstantVars(termVariableArray);
        int n = this.getReqToId(reqGuardGraph);
        Term term2 = SmtUtils.and((Script)this.mScript, this.varsToDefineAnnotations(list, n));
        this.mReqToDefineAnnotation.put(reqGuardGraph, term2);
        Term term3 = SmtUtils.or((Script)this.mScript, this.varsToDefineAnnotations(list, n));
        this.mReqToNonDefineAnnotation.put(reqGuardGraph, SmtUtils.not((Script)this.mScript, (Term)term3));
    }

    public Collection<TermVariable> getEffectVariables(ReqGuardGraph reqGuardGraph) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        if (this.mEffects.containsKey((Object)reqGuardGraph)) {
            arrayList.add(this.mEffects.get((Object)reqGuardGraph));
        }
        return SmtUtils.getFreeVars(arrayList);
    }

    private List<TermVariable> getNonInputNonConstantVars(TermVariable[] termVariableArray) {
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        TermVariable[] termVariableArray2 = termVariableArray;
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray2[n2];
            String string = termVariable.toString();
            if (!this.mReqSymbolTable.isConstVar(string) && !this.mReqSymbolTable.isInput(string)) {
                arrayList.add(termVariable);
            }
            ++n2;
        }
        return arrayList;
    }

    public Term getDefineGuard(ReqGuardGraph reqGuardGraph) {
        return this.mReqToDefineAnnotation.get((Object)reqGuardGraph);
    }

    public Term getNonDefineGuard(ReqGuardGraph reqGuardGraph) {
        return this.mReqToNonDefineAnnotation.get((Object)reqGuardGraph);
    }

    public Term getUseGuard(Term term) {
        TermVariable[] termVariableArray = term.getFreeVars();
        List<TermVariable> list = this.getNonInputNonConstantVars(termVariableArray);
        return SmtUtils.and((Script)this.mScript, this.varsToUseAnnotations(list));
    }

    public List<Term> varsToUseAnnotations(List<TermVariable> list) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (TermVariable termVariable : list) {
            arrayList.add(this.createUseAnnotation(termVariable));
        }
        return arrayList;
    }

    public Term createUseAnnotation(TermVariable termVariable) {
        if (this.mVariableToUseTerm.containsKey(termVariable)) {
            return this.mVariableToUseTerm.get(termVariable);
        }
        Term term = this.createUseTerm(termVariable);
        this.mVariableToUseTerm.put(termVariable, term);
        return term;
    }

    public TermVariable generateClockIdent(ReqGuardGraph reqGuardGraph) {
        String string = CLOCK_PREFIX + Integer.toString(this.getReqToId(reqGuardGraph));
        this.mReqSymbolTable.addClockVar(string, (BoogieType)BoogieType.TYPE_REAL);
        return this.mScript.variable(string, this.mSortInt);
    }

    private Term createUseTerm(TermVariable termVariable) {
        String string = USE_PREFIX + termVariable.toString();
        this.mReqSymbolTable.addAuxVar(string, (BoogieType)BoogieType.TYPE_BOOL);
        return this.mScript.variable(string, this.mSortBool);
    }

    public List<Term> varsToDefineAnnotations(List<TermVariable> list, int n) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (TermVariable termVariable : list) {
            arrayList.add(this.createDefineAnnotation(termVariable, n));
            this.getUseGuard((Term)termVariable);
        }
        return arrayList;
    }

    public Term createDefineAnnotation(TermVariable termVariable, int n) {
        Term term = this.createDefineTerm(termVariable, n);
        if (!this.mVariableToDefineTerm.containsKey(termVariable)) {
            this.mVariableToDefineTerm.put(termVariable, new HashSet());
        }
        this.mVariableToDefineTerm.get(termVariable).add(term);
        return term;
    }

    private Term createDefineTerm(TermVariable termVariable, int n) {
        String string = DEFINE_PREFIX + Integer.toString(n) + "_" + termVariable.toString();
        this.mReqSymbolTable.addAuxVar(string, (BoogieType)BoogieType.TYPE_BOOL);
        return this.mScript.variable(string, this.mSortBool);
    }

    public int getReqToId(ReqGuardGraph reqGuardGraph) {
        if (!this.mReqToId.containsKey((Object)reqGuardGraph)) {
            this.mReqToId.put(reqGuardGraph, this.mReqId);
            ++this.mReqId;
        }
        return this.mReqToId.get((Object)reqGuardGraph);
    }

    public List<Term> getDefineAssumeGuards() {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (TermVariable termVariable : this.mVariableToUseTerm.keySet()) {
            Term term = this.mVariableToUseTerm.get(termVariable);
            if (this.mVariableToDefineTerm.containsKey(termVariable)) {
                Term term2 = SmtUtils.or((Script)this.mScript, (Collection)this.mVariableToDefineTerm.get(termVariable));
                arrayList.add(SmtUtils.binaryBooleanEquality((Script)this.mScript, (Term)term, (Term)term2));
                continue;
            }
            arrayList.add(SmtUtils.not((Script)this.mScript, (Term)term));
        }
        return arrayList;
    }

    public Map<ReqGuardGraph, Term> getOracleAssertions() {
        HashMap<ReqGuardGraph, Term> hashMap = new HashMap<ReqGuardGraph, Term>();
        for (ReqGuardGraph reqGuardGraph : this.mEffects.keySet()) {
            Term term = this.getOracleAssertion(reqGuardGraph);
            if (term == null || term == this.mSmtTrue || term == this.mSmtFalse) continue;
            hashMap.put(reqGuardGraph, term);
        }
        return hashMap;
    }

    public Term getOracleAssertion(ReqGuardGraph reqGuardGraph) {
        Term term = this.mEffects.get((Object)reqGuardGraph);
        Term term2 = this.getOracleEffectAssertionTerm(reqGuardGraph, term);
        Term term3 = this.getOracleDenyOthers(reqGuardGraph, term);
        return SmtUtils.not((Script)this.mScript, (Term)SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term2, term3}));
    }

    public Term getOracleEffectAssertionTerm(ReqGuardGraph reqGuardGraph, Term term) {
        Term term2 = this.mSmtTrue;
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray[n2];
            if (this.mReqSymbolTable.isOutput(termVariable.toString())) {
                HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
                hashSet.add(termVariable);
                Term term3 = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{SmtUtils.filterFormula((Term)term, hashSet, (Script)this.mScript), this.createDefineAnnotation(termVariable, this.mReqToId.get((Object)reqGuardGraph))});
                term2 = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term2, term3});
            }
            ++n2;
        }
        return term2;
    }

    public Term getOracleDenyOthers(ReqGuardGraph reqGuardGraph, Term term) {
        Term term2 = this.mSmtTrue;
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray[n2];
            if (this.mReqSymbolTable.isOutput(termVariable.toString())) {
                Term term3 = this.createDefineAnnotation(termVariable, this.mReqToId.get((Object)reqGuardGraph));
                for (Term term4 : this.mVariableToDefineTerm.get(termVariable)) {
                    if (term4 == term3) continue;
                    term2 = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term2, SmtUtils.not((Script)this.mScript, (Term)term4)});
                }
            }
            ++n2;
        }
        return term2;
    }
}

