/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.JordanLoopAccelerationDefinitions;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.JordanLoopAccelerationStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import java.util.Collection;

public class JordanLoopAccelerationStatisticsGenerator
implements IStatisticsDataProvider {
    private final int mNumberOfAssignedVariables;
    private final int mNumberOfHavocedVariables;
    private final int mNumberOfReadonlyVariables;
    private final int mNumberOfArrayWrites;
    private final NestedMap2<Integer, Integer, Integer> mEigenvalues;
    private int mSequentialAcceleration;
    private int mQuantifierFreeResult;
    private int mAlternatingAcceleration;
    private final String mErrorMessage;

    public JordanLoopAccelerationStatisticsGenerator(int n, int n2, int n3, int n4, NestedMap2<Integer, Integer, Integer> nestedMap2, String string) {
        this.mNumberOfAssignedVariables = n;
        this.mNumberOfHavocedVariables = n2;
        this.mNumberOfReadonlyVariables = n4;
        this.mNumberOfArrayWrites = n3;
        this.mEigenvalues = nestedMap2;
        this.mSequentialAcceleration = 0;
        this.mQuantifierFreeResult = 0;
        this.mAlternatingAcceleration = 0;
        this.mErrorMessage = string;
    }

    public Object getValue(String string) {
        JordanLoopAccelerationDefinitions jordanLoopAccelerationDefinitions = JordanLoopAccelerationDefinitions.valueOf(string);
        return switch (jordanLoopAccelerationDefinitions) {
            case JordanLoopAccelerationDefinitions.AssignedVariables -> this.mNumberOfAssignedVariables;
            case JordanLoopAccelerationDefinitions.HavocedVariables -> this.mNumberOfHavocedVariables;
            case JordanLoopAccelerationDefinitions.ReadonlyVariables -> this.mNumberOfReadonlyVariables;
            case JordanLoopAccelerationDefinitions.ArrayWrites -> this.mNumberOfArrayWrites;
            case JordanLoopAccelerationDefinitions.Eigenvalues -> this.mEigenvalues;
            case JordanLoopAccelerationDefinitions.SequentialAcceleration -> this.mSequentialAcceleration;
            case JordanLoopAccelerationDefinitions.QuantifierFreeResult -> this.mQuantifierFreeResult;
            case JordanLoopAccelerationDefinitions.AlternatingAcceleration -> this.mAlternatingAcceleration;
            case JordanLoopAccelerationDefinitions.ErrorMessage -> this.mErrorMessage;
            default -> throw new MatchException(null, null);
        };
    }

    public IStatisticsType getBenchmarkType() {
        return JordanLoopAccelerationStatisticsType.getInstance();
    }

    public Collection<String> getKeys() {
        return this.getBenchmarkType().getKeys();
    }

    public void reportSequentialAcceleration() {
        ++this.mSequentialAcceleration;
    }

    public void reportAlternatingAcceleration() {
        ++this.mAlternatingAcceleration;
    }

    public void reportQuantifierFreeResult() {
        ++this.mQuantifierFreeResult;
    }

    public String toString() {
        return this.getBenchmarkType().prettyprintBenchmarkData((IStatisticsDataProvider)this);
    }
}

