/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public class IncrementalImplicationChecker
implements ManagedScript.ILockHolderWithVoluntaryLockRelease {
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mManagedScript;
    private IPredicate mSuccedent;

    public IncrementalImplicationChecker(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript) {
        this.mServices = iUltimateServiceProvider;
        this.mManagedScript = managedScript;
    }

    public IncrementalPlicationChecker.Validity checkImplication(IPredicate iPredicate, IPredicate iPredicate2) {
        if (this.mSuccedent != null && this.mSuccedent != iPredicate2) {
            this.unAssertSuccedent();
        }
        if (this.mSuccedent == null) {
            this.assertSuccedent(iPredicate2);
        }
        return this.doCheckWithAntecedent(iPredicate);
    }

    private void assertSuccedent(IPredicate iPredicate) {
        if (this.mManagedScript.isLocked()) {
            this.mManagedScript.requestLockRelease();
        }
        this.mManagedScript.lock((Object)this);
        this.mManagedScript.push((Object)this, 1);
        assert (this.mSuccedent == null) : "already succedent asserted";
        this.mSuccedent = iPredicate;
        this.mManagedScript.assertTerm((Object)this, SmtUtils.not((Script)this.mManagedScript.getScript(), (Term)this.mSuccedent.getClosedFormula()));
    }

    private void unAssertSuccedent() {
        assert (this.mSuccedent != null) : "no succedent asserted";
        this.mSuccedent = null;
        this.mManagedScript.pop((Object)this, 1);
        this.mManagedScript.unlock((Object)this);
    }

    private IncrementalPlicationChecker.Validity doCheckWithAntecedent(IPredicate iPredicate) {
        assert (this.mSuccedent != null) : "no succedent asserted";
        this.mManagedScript.push((Object)this, 1);
        this.mManagedScript.assertTerm((Object)this, iPredicate.getClosedFormula());
        Script.LBool lBool = this.mManagedScript.checkSat((Object)this);
        this.mManagedScript.pop((Object)this, 1);
        return IncrementalPlicationChecker.convertLBool2Validity((Script.LBool)lBool);
    }

    public void releaseLock() {
        if (this.mSuccedent != null) {
            this.unAssertSuccedent();
        }
    }
}

