/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.invariantsynthesis;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IUnmanagedObserver;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lassoranker.synthesis.TestMain;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.invariantsynthesis.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.invariantsynthesis.InvariantSynthesisStarter;
import java.util.ArrayList;
import java.util.List;

public class InvariantSynthesisObserver
implements IUnmanagedObserver {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final List<IIcfg<?>> mIcfgs;
    private IElement mRootOfNewModel;
    private boolean mLastModel;
    private ModelType mCurrentGraphType;

    public InvariantSynthesisObserver(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mLastModel = false;
        this.mIcfgs = new ArrayList();
    }

    public boolean process(IElement iElement) {
        if (iElement instanceof IIcfg) {
            this.mIcfgs.add((IIcfg)iElement);
        }
        return false;
    }

    public void finish() {
        if (this.mLastModel) {
            IIcfg iIcfg3 = this.mIcfgs.stream().filter(iIcfg -> IcfgLocation.class.isAssignableFrom(iIcfg.getLocationClass())).reduce((iIcfg, iIcfg2) -> iIcfg2).orElseThrow(UnsupportedOperationException::new);
            if (iIcfg3 == null) {
                throw new UnsupportedOperationException("InvariantSynthesis needs an RCFG");
            }
            if (System.getenv("REDIRECT_INVARIANT_SYNTHESIS_FLOWGRAPH") != null) {
                try {
                    TestMain.testEntryPoint((IIcfg)iIcfg3, (IUltimateServiceProvider)this.mServices);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                }
                System.out.println("test main finished, exiting..");
                System.exit(0);
            }
            this.mLogger.info((Object)("Analyzing ICFG " + iIcfg3.getIdentifier()));
            InvariantSynthesisStarter invariantSynthesisStarter = new InvariantSynthesisStarter(this.mServices, (IIcfg<IcfgLocation>)iIcfg3);
            this.mRootOfNewModel = invariantSynthesisStarter.getRootOfNewModel();
        }
    }

    public IElement getRootOfNewModel() {
        return this.mRootOfNewModel;
    }

    public void init(ModelType modelType, int n, int n2) {
        this.mCurrentGraphType = modelType;
        if (n == n2 - 1) {
            this.mLastModel = true;
        }
    }

    public boolean performedChanges() {
        return false;
    }
}

