/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.models.annotation;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.CheckMessageProvider;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ModernAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IMessageProvider;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Check
extends ModernAnnotations {
    private static final String MSG_AND = " and ";
    private static final long serialVersionUID = -3753413284642976683L;
    private static final String KEY = Check.class.getName();
    @Visualizable
    private final Set<Spec> mSpec;
    private final IMessageProvider mMsgProvider;

    public Check(Spec spec) {
        this(EnumSet.of(spec));
    }

    public Check(Spec spec, IMessageProvider iMessageProvider) {
        this(EnumSet.of(spec), iMessageProvider);
    }

    public Check(Set<Spec> set) {
        this(set, (IMessageProvider)new CheckMessageProvider());
    }

    public Check(Set<Spec> set, IMessageProvider iMessageProvider) {
        assert (!set.isEmpty());
        this.mSpec = set;
        this.mMsgProvider = iMessageProvider;
    }

    public Set<Spec> getSpec() {
        return this.mSpec;
    }

    protected IMessageProvider getMessageProvider() {
        return this.mMsgProvider;
    }

    public String getPositiveMessage() {
        return this.getCompoundMessage(arg_0 -> ((IMessageProvider)this.mMsgProvider).getPositiveMessage(arg_0));
    }

    public String getNegativeMessage() {
        return this.getCompoundMessage(arg_0 -> ((IMessageProvider)this.mMsgProvider).getNegativeMessage(arg_0));
    }

    private String getCompoundMessage(Function<Spec, String> function) {
        Iterator<Spec> iterator = this.mSpec.iterator();
        if (this.mSpec.size() == 1) {
            return function.apply(iterator.next());
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            stringBuilder.append(function.apply(iterator.next())).append(MSG_AND);
        }
        stringBuilder.delete(stringBuilder.length() - MSG_AND.length(), stringBuilder.length());
        return stringBuilder.toString();
    }

    public IAnnotations merge(IAnnotations iAnnotations) {
        if (iAnnotations == null) {
            return this;
        }
        if (iAnnotations == this) {
            return this;
        }
        if (!(iAnnotations instanceof Check)) {
            throw new IAnnotations.UnmergeableAnnotationsException((IAnnotations)this, iAnnotations);
        }
        Check check = (Check)iAnnotations;
        EnumSet<Spec> enumSet = EnumSet.copyOf(this.mSpec);
        enumSet.addAll(check.getSpec());
        return new Check(enumSet);
    }

    public void annotate(IElement iElement) {
        iElement.getPayload().getAnnotations().put(KEY, this);
    }

    public static Check getAnnotation(IElement iElement) {
        return (Check)ModelUtils.getAnnotation((IElement)iElement, (String)KEY, iAnnotations -> (Check)iAnnotations);
    }

    public static Check mergeCheck(Check check, Check check2) {
        if (check == null) {
            return check2;
        }
        if (check2 == null) {
            return check;
        }
        return (Check)check.merge(check2);
    }

    public String toString() {
        return this.mSpec.stream().map(Enum::toString).collect(Collectors.joining(MSG_AND));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Check check = (Check)object;
        return !(this.mSpec == null ? check.mSpec != null : !this.mSpec.equals(check.mSpec));
    }
}

