/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.EnsuresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LoopInvariantSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ModifiesSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.QuantifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RequiresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.FlatSymbolTable;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.AcslTypeUtils;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CExpressionTranslator;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.ProcedureManager;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.SymbolTableValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CStructOrUnion;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.IncorrectSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.UnsupportedSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.CDeclaration;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ContractResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultTransformer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.HeapLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValueFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LocalLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.Result;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.CdtASTUtils;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.IACSLHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLProblemNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLResultExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Assertion;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Assigns;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.AtLabelExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.CastExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.CodeAnnot;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.CodeAnnotStmt;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.CodeStatement;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Contract;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ContractStatement;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Ensures;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.FieldAccessExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.FreeableExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.GhostDeclaration;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.GhostUpdate;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.IfThenElseExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.LoopAnnot;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.LoopAssigns;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.LoopInvariant;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.LoopStatement;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.LoopVariant;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.MallocableExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.NullPointer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.OldValueExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Requires;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ValidExpression;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;

public class ACSLHandler
implements IACSLHandler {
    private SPEC_TYPE mSpecType = SPEC_TYPE.NOT;
    private final boolean mWitnessInvariantMode;
    private final FlatSymbolTable mSymboltable;
    private final ExpressionTranslation mExpressionTranslation;
    private final ITypeHandler mTypeHandler;
    private final ProcedureManager mProcedureManager;
    private final ExpressionResultTransformer mExprResultTransformer;
    private final LocationFactory mLocationFactory;
    private final CHandler mCHandler;
    private final CExpressionTranslator mCExpressionTranslator;
    private final ScopedHashMap<String, LRValue> mBoundVariables = new ScopedHashMap();

    public ACSLHandler(boolean bl, FlatSymbolTable flatSymbolTable, ExpressionTranslation expressionTranslation, ITypeHandler iTypeHandler, ProcedureManager procedureManager, LocationFactory locationFactory, CHandler cHandler) {
        this.mWitnessInvariantMode = bl;
        this.mSymboltable = flatSymbolTable;
        this.mExpressionTranslation = expressionTranslation;
        this.mTypeHandler = iTypeHandler;
        this.mProcedureManager = procedureManager;
        this.mExprResultTransformer = cHandler.getExpressionResultTransformer();
        this.mLocationFactory = locationFactory;
        this.mCExpressionTranslator = cHandler.getCExpressionTranslator().disableChecksForUndefinedBehavior();
        this.mCHandler = cHandler;
    }

    @Override
    public Result visit(IDispatcher iDispatcher, ACSLNode aCSLNode) {
        CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation(aCSLNode);
        String string = "ACSLHandler: Not yet implemented: " + aCSLNode.toString();
        throw new UnsupportedSyntaxException(cACSLLocation, string);
    }

    @Override
    public Result visit(IDispatcher iDispatcher, OldValueExpression oldValueExpression) {
        return this.handleOldExpression(this.mLocationFactory.createACSLLocation((ACSLNode)oldValueExpression), iDispatcher, oldValueExpression.getExpression());
    }

    @Override
    public Result visit(IDispatcher iDispatcher, AtLabelExpression atLabelExpression) {
        CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation((ACSLNode)atLabelExpression);
        switch (atLabelExpression.getLabel()) {
            case "Old": {
                return this.handleOldExpression(cACSLLocation, iDispatcher, atLabelExpression.getExpression());
            }
            case "Pre": {
                return this.handleOldExpression(cACSLLocation, iDispatcher, atLabelExpression.getExpression());
            }
            case "LoopCurrent": 
            case "LoopEntry": 
            case "Here": 
            case "Init": 
            case "Post": {
                throw new UnsupportedSyntaxException(cACSLLocation, atLabelExpression.getLabel() + " is currently not supported as a label in \\at.");
            }
        }
        throw new UnsupportedSyntaxException(cACSLLocation, "Only built-in labels are currently supported as a in \\at (found ." + atLabelExpression.getLabel() + ").");
    }

    private Result handleOldExpression(ILocation iLocation, IDispatcher iDispatcher, Expression expression) {
        ExpressionResult expressionResult = this.dispatchSwitch(iDispatcher, expression, iLocation);
        if (!expressionResult.hasNoSideEffects()) {
            throw new UnsupportedSyntaxException(iLocation, "old can only be used for expressions without side-effects.");
        }
        RValue rValue = new RValue(ExpressionFactory.constructUnaryExpression((ILocation)iLocation, (UnaryExpression.Operator)UnaryExpression.Operator.OLD, (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)expressionResult.getLrValue().getValue()), expressionResult.getLrValue().getCType());
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(rValue).build();
    }

    @Override
    public Result visit(IDispatcher iDispatcher, CodeAnnot codeAnnot) {
        CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation((ACSLNode)codeAnnot);
        if (codeAnnot instanceof CodeAnnotStmt) {
            CodeStatement codeStatement = ((CodeAnnotStmt)codeAnnot).getCodeStmt();
            if (codeStatement instanceof Assertion) {
                return this.handleAssert(iDispatcher, cACSLLocation, (Assertion)codeStatement);
            }
            if (codeStatement instanceof GhostUpdate) {
                return this.handleGhostUpdate(iDispatcher, cACSLLocation, (GhostUpdate)codeStatement);
            }
            if (codeStatement instanceof GhostDeclaration) {
                return this.handleGhostDeclaration(iDispatcher, cACSLLocation, (GhostDeclaration)codeStatement);
            }
        }
        throw new UnsupportedSyntaxException(cACSLLocation, "ACSLHandler: Not yet implemented: " + codeAnnot.toString());
    }

    private Result handleAssert(IDispatcher iDispatcher, ILocation iLocation, Assertion assertion) {
        Overapprox overapprox2;
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        ExpressionResult expressionResult = this.dispatchSwitch(iDispatcher, assertion.getFormula(), iLocation);
        expressionResult = this.mExprResultTransformer.rexIntToBool(expressionResult, iLocation);
        expressionResultBuilder.addAllExceptLrValue(expressionResult);
        AssertStatement assertStatement = new AssertStatement(iLocation, expressionResult.getLrValue().getValue());
        for (Overapprox overapprox2 : expressionResultBuilder.getOverappr()) {
            overapprox2.annotate((IElement)assertStatement);
        }
        expressionResultBuilder.addStatement((Statement)assertStatement);
        expressionResultBuilder.havocAuxVars();
        overapprox2 = this.mWitnessInvariantMode ? new Check(Spec.WITNESS_INVARIANT) : new Check(Spec.ASSERT);
        overapprox2.annotate((IElement)assertStatement);
        return expressionResultBuilder.build();
    }

    private Result handleGhostUpdate(IDispatcher iDispatcher, ILocation iLocation, GhostUpdate ghostUpdate) {
        SymbolTableValue symbolTableValue = this.mSymboltable.findCSymbol(iDispatcher.getAcslHook(), ghostUpdate.getIdentifier());
        if (symbolTableValue == null) {
            throw new IncorrectSyntaxException(iLocation, "Undeclared variable in ACSL expression: " + ghostUpdate.getIdentifier());
        }
        if (!symbolTableValue.getBoogieName().startsWith("#ghost~")) {
            throw new IncorrectSyntaxException(iLocation, "C variable " + ghostUpdate.getIdentifier() + " cannot be assigned in ghost statement.");
        }
        ExpressionResult expressionResult = (ExpressionResult)iDispatcher.dispatch((ACSLNode)ghostUpdate.getExpr(), iDispatcher.getAcslHook());
        ICType iCType = symbolTableValue.getCType();
        ExpressionResult expressionResult2 = this.mExprResultTransformer.makeRepresentationReadyForConversionAndRexBoolToInt(expressionResult, iLocation, iCType, iDispatcher.getAcslHook());
        VariableLHS variableLHS = new VariableLHS(iLocation, (IBoogieType)this.mTypeHandler.getBoogieTypeForCType(iCType), symbolTableValue.getBoogieName(), symbolTableValue.getDeclarationInformation());
        return this.mCHandler.makeAssignment(iLocation, new LocalLValue((LeftHandSide)variableLHS, iCType, null), List.of(), expressionResult2, iDispatcher.getAcslHook());
    }

    private Result handleGhostDeclaration(IDispatcher iDispatcher, ILocation iLocation, GhostDeclaration ghostDeclaration) {
        SymbolTableValue symbolTableValue = this.mSymboltable.findCSymbol(iDispatcher.getAcslHook(), ghostDeclaration.getIdentifier());
        if (symbolTableValue != null) {
            throw new UnsupportedSyntaxException(iLocation, String.format("The ghost variable %s shadows another variable.", ghostDeclaration.getIdentifier()));
        }
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        String string = "#ghost~" + ghostDeclaration.getIdentifier();
        ICType iCType = AcslTypeUtils.translateAcslTypeToCType(ghostDeclaration.getType());
        ASTType aSTType = this.mTypeHandler.cType2AstType(iLocation, iCType);
        VariableDeclaration variableDeclaration = new VariableDeclaration(iLocation, new Attribute[0], new VarList[]{new VarList(iLocation, new String[]{string}, aSTType)});
        CDeclaration cDeclaration = new CDeclaration(iCType, ghostDeclaration.getIdentifier());
        IASTFunctionDefinition iASTFunctionDefinition = CdtASTUtils.findScope(iDispatcher.getAcslHook());
        DeclarationInformation declarationInformation = iASTFunctionDefinition == null ? DeclarationInformation.DECLARATIONINFO_GLOBAL : new DeclarationInformation(DeclarationInformation.StorageClass.LOCAL, iASTFunctionDefinition.getDeclarator().getName().toString());
        this.mSymboltable.storeCSymbol(iDispatcher.getAcslHook(), ghostDeclaration.getIdentifier(), new SymbolTableValue(string, (de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration)variableDeclaration, aSTType, cDeclaration, declarationInformation, iDispatcher.getAcslHook(), false));
        if (ghostDeclaration.getExpr() != null) {
            ExpressionResult expressionResult = (ExpressionResult)iDispatcher.dispatch((ACSLNode)ghostDeclaration.getExpr(), iDispatcher.getAcslHook());
            ExpressionResult expressionResult2 = this.mExprResultTransformer.makeRepresentationReadyForConversionAndRexBoolToInt(expressionResult, iLocation, iCType, iDispatcher.getAcslHook());
            expressionResultBuilder.addAllIncludingLrValue(expressionResult2);
            VariableLHS variableLHS = new VariableLHS(iLocation, (IBoogieType)this.mTypeHandler.getBoogieTypeForCType(iCType), string, declarationInformation);
            return this.mCHandler.makeAssignment(iLocation, new LocalLValue((LeftHandSide)variableLHS, iCType, null), List.of(), expressionResultBuilder.build(), iDispatcher.getAcslHook());
        }
        return expressionResultBuilder.build();
    }

    private static BinaryExpression.Operator getBoogieBinaryExprOperator(BinaryExpression.Operator operator) {
        return switch (operator) {
            case BinaryExpression.Operator.ARITHDIV -> BinaryExpression.Operator.ARITHDIV;
            case BinaryExpression.Operator.ARITHMINUS -> BinaryExpression.Operator.ARITHMINUS;
            case BinaryExpression.Operator.ARITHMOD -> BinaryExpression.Operator.ARITHMOD;
            case BinaryExpression.Operator.ARITHMUL -> BinaryExpression.Operator.ARITHMUL;
            case BinaryExpression.Operator.ARITHPLUS -> BinaryExpression.Operator.ARITHPLUS;
            case BinaryExpression.Operator.BITVECCONCAT -> BinaryExpression.Operator.BITVECCONCAT;
            case BinaryExpression.Operator.COMPEQ -> BinaryExpression.Operator.COMPEQ;
            case BinaryExpression.Operator.COMPGEQ -> BinaryExpression.Operator.COMPGEQ;
            case BinaryExpression.Operator.COMPGT -> BinaryExpression.Operator.COMPGT;
            case BinaryExpression.Operator.COMPLEQ -> BinaryExpression.Operator.COMPLEQ;
            case BinaryExpression.Operator.COMPLT -> BinaryExpression.Operator.COMPLT;
            case BinaryExpression.Operator.COMPNEQ -> BinaryExpression.Operator.COMPNEQ;
            case BinaryExpression.Operator.COMPPO -> BinaryExpression.Operator.COMPPO;
            case BinaryExpression.Operator.LOGICAND -> BinaryExpression.Operator.LOGICAND;
            case BinaryExpression.Operator.LOGICIFF -> BinaryExpression.Operator.LOGICIFF;
            case BinaryExpression.Operator.LOGICIMPLIES -> BinaryExpression.Operator.LOGICIMPLIES;
            case BinaryExpression.Operator.LOGICOR -> BinaryExpression.Operator.LOGICOR;
            case BinaryExpression.Operator.LOGICXOR -> null;
            case BinaryExpression.Operator.BITAND, BinaryExpression.Operator.BITOR, BinaryExpression.Operator.BITIMPLIES, BinaryExpression.Operator.BITIFF, BinaryExpression.Operator.BITXOR, BinaryExpression.Operator.BITSHIFTLEFT, BinaryExpression.Operator.BITSHIFTRIGHT -> null;
            case BinaryExpression.Operator.LTLUNTIL, BinaryExpression.Operator.LTLRELEASE, BinaryExpression.Operator.LTLWEAKUNTIL -> null;
            default -> throw new MatchException(null, null);
        };
    }

    private static int getCASTBinaryExprOperator(BinaryExpression.Operator operator) {
        return switch (operator) {
            case BinaryExpression.Operator.ARITHDIV -> 2;
            case BinaryExpression.Operator.ARITHMINUS -> 5;
            case BinaryExpression.Operator.ARITHMOD -> 3;
            case BinaryExpression.Operator.ARITHMUL -> 1;
            case BinaryExpression.Operator.ARITHPLUS -> 4;
            case BinaryExpression.Operator.BITAND -> 12;
            case BinaryExpression.Operator.BITOR -> 14;
            case BinaryExpression.Operator.BITSHIFTLEFT -> 6;
            case BinaryExpression.Operator.BITSHIFTRIGHT -> 7;
            case BinaryExpression.Operator.BITXOR -> 13;
            case BinaryExpression.Operator.COMPEQ -> 28;
            case BinaryExpression.Operator.COMPGEQ -> 11;
            case BinaryExpression.Operator.COMPGT -> 9;
            case BinaryExpression.Operator.COMPLEQ -> 10;
            case BinaryExpression.Operator.COMPLT -> 8;
            case BinaryExpression.Operator.COMPNEQ -> 29;
            case BinaryExpression.Operator.LOGICAND -> 15;
            case BinaryExpression.Operator.LOGICOR -> 16;
            case BinaryExpression.Operator.LOGICIFF, BinaryExpression.Operator.LOGICIMPLIES, BinaryExpression.Operator.LOGICXOR, BinaryExpression.Operator.COMPPO, BinaryExpression.Operator.BITVECCONCAT, BinaryExpression.Operator.BITIMPLIES, BinaryExpression.Operator.BITIFF, BinaryExpression.Operator.LTLUNTIL, BinaryExpression.Operator.LTLRELEASE, BinaryExpression.Operator.LTLWEAKUNTIL -> throw new IllegalArgumentException("don't know equivalent C operator");
            default -> throw new MatchException(null, null);
        };
    }

    private ExpressionResult dispatchSwitch(IDispatcher iDispatcher, Expression expression, ILocation iLocation) {
        ExpressionResult expressionResult = (ExpressionResult)iDispatcher.dispatch((ACSLNode)expression, iDispatcher.getAcslHook());
        return this.mExprResultTransformer.switchToRValueUnchecked(expressionResult, iLocation, iDispatcher.getAcslHook());
    }

    @Override
    public Result visit(IDispatcher iDispatcher, BinaryExpression binaryExpression) {
        CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation((ACSLNode)binaryExpression);
        ExpressionResult expressionResult = this.dispatchSwitch(iDispatcher, binaryExpression.getLeft(), cACSLLocation);
        ExpressionResult expressionResult2 = this.dispatchSwitch(iDispatcher, binaryExpression.getRight(), cACSLLocation);
        switch (binaryExpression.getOperator()) {
            case ARITHMUL: 
            case ARITHDIV: 
            case ARITHMOD: {
                ExpressionResult expressionResult3 = this.mExprResultTransformer.rexBoolToInt(expressionResult, cACSLLocation);
                ExpressionResult expressionResult4 = this.mExprResultTransformer.rexBoolToInt(expressionResult2, cACSLLocation);
                int n = ACSLHandler.getCASTBinaryExprOperator(binaryExpression.getOperator());
                return this.mCExpressionTranslator.handleMultiplicativeOperation(cACSLLocation, n, expressionResult3, expressionResult4);
            }
            case ARITHPLUS: 
            case ARITHMINUS: {
                ExpressionResult expressionResult5 = this.mExprResultTransformer.rexBoolToInt(expressionResult, cACSLLocation);
                ExpressionResult expressionResult6 = this.mExprResultTransformer.rexBoolToInt(expressionResult2, cACSLLocation);
                int n = ACSLHandler.getCASTBinaryExprOperator(binaryExpression.getOperator());
                return this.mCExpressionTranslator.handleAdditiveOperation(cACSLLocation, n, expressionResult5, expressionResult6);
            }
            case COMPEQ: 
            case COMPNEQ: {
                ExpressionResult expressionResult7 = this.mExprResultTransformer.rexBoolToInt(expressionResult, cACSLLocation);
                ExpressionResult expressionResult8 = this.mExprResultTransformer.rexBoolToInt(expressionResult2, cACSLLocation);
                int n = ACSLHandler.getCASTBinaryExprOperator(binaryExpression.getOperator());
                return this.mCExpressionTranslator.handleEqualityOperators(cACSLLocation, n, expressionResult7, expressionResult8);
            }
            case COMPLT: 
            case COMPGT: 
            case COMPLEQ: 
            case COMPGEQ: {
                ExpressionResult expressionResult9 = this.mExprResultTransformer.rexBoolToInt(expressionResult, cACSLLocation);
                ExpressionResult expressionResult10 = this.mExprResultTransformer.rexBoolToInt(expressionResult2, cACSLLocation);
                int n = ACSLHandler.getCASTBinaryExprOperator(binaryExpression.getOperator());
                return this.mCExpressionTranslator.handleRelationalOperators(cACSLLocation, n, expressionResult9, expressionResult10);
            }
            case LOGICIFF: 
            case LOGICIMPLIES: 
            case LOGICAND: 
            case LOGICOR: {
                Object object = ACSLHandler.getBoogieBinaryExprOperator(binaryExpression.getOperator());
                if (object != null) {
                    ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
                    expressionResultBuilder.addAllExceptLrValue(expressionResult);
                    expressionResultBuilder.addAllExceptLrValue(expressionResult2);
                    ExpressionResult expressionResult11 = this.mExprResultTransformer.rexIntToBool(expressionResult, cACSLLocation);
                    ExpressionResult expressionResult12 = this.mExprResultTransformer.rexIntToBool(expressionResult2, cACSLLocation);
                    de.uni_freiburg.informatik.ultimate.boogie.ast.Expression expression = ExpressionFactory.newBinaryExpression((ILocation)cACSLLocation, (BinaryExpression.Operator)object, (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)expressionResult11.getLrValue().getValue(), (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)expressionResult12.getLrValue().getValue());
                    RValue rValue = new RValue(expression, new CPrimitive(CPrimitive.CPrimitives.INT), true);
                    expressionResultBuilder.setLrValue(rValue);
                    return expressionResultBuilder.build();
                }
            }
            case LOGICXOR: {
                Object object = new ExpressionResultBuilder();
                ((ExpressionResultBuilder)object).addAllExceptLrValue(expressionResult2);
                de.uni_freiburg.informatik.ultimate.boogie.ast.Expression expression = ExpressionFactory.constructUnaryExpression((ILocation)cACSLLocation, (UnaryExpression.Operator)UnaryExpression.Operator.LOGICNEG, (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)expressionResult2.getLrValue().getValue());
                de.uni_freiburg.informatik.ultimate.boogie.ast.Expression expression2 = ExpressionFactory.newBinaryExpression((ILocation)cACSLLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICAND, (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)expressionResult.getLrValue().getValue(), (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)expression);
                de.uni_freiburg.informatik.ultimate.boogie.ast.Expression expression3 = ExpressionFactory.constructUnaryExpression((ILocation)cACSLLocation, (UnaryExpression.Operator)UnaryExpression.Operator.LOGICNEG, (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)expressionResult.getLrValue().getValue());
                de.uni_freiburg.informatik.ultimate.boogie.ast.Expression expression4 = ExpressionFactory.newBinaryExpression((ILocation)cACSLLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICAND, (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)expression3, (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)expressionResult2.getLrValue().getValue());
                RValue rValue = new RValue(ExpressionFactory.newBinaryExpression((ILocation)cACSLLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)expression2, (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)expression4), new CPrimitive(CPrimitive.CPrimitives.INT), true);
                ((ExpressionResultBuilder)object).setLrValue(rValue);
                return ((ExpressionResultBuilder)object).build();
            }
            case BITAND: 
            case BITOR: 
            case BITXOR: {
                return this.mCExpressionTranslator.handleBitwiseArithmeticOperation(cACSLLocation, ACSLHandler.getCASTBinaryExprOperator(binaryExpression.getOperator()), expressionResult, expressionResult2);
            }
            case BITSHIFTLEFT: 
            case BITSHIFTRIGHT: {
                return this.mCExpressionTranslator.handleBitshiftOperation(cACSLLocation, ACSLHandler.getCASTBinaryExprOperator(binaryExpression.getOperator()), expressionResult, expressionResult2);
            }
        }
        String string = "Unknown or unsupported binary operation: " + String.valueOf(binaryExpression.getOperator());
        throw new UnsupportedSyntaxException(cACSLLocation, string);
    }

    @Override
    public Result visit(IDispatcher iDispatcher, UnaryExpression unaryExpression) {
        CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation((ACSLNode)unaryExpression);
        return switch (unaryExpression.getOperator()) {
            case UnaryExpression.Operator.LOGICNEG -> this.mCExpressionTranslator.handleUnaryArithmeticOperators(cACSLLocation, 7, this.dispatchSwitch(iDispatcher, unaryExpression.getExpr(), cACSLLocation));
            case UnaryExpression.Operator.MINUS -> this.mCExpressionTranslator.handleUnaryArithmeticOperators(cACSLLocation, 3, this.dispatchSwitch(iDispatcher, unaryExpression.getExpr(), cACSLLocation));
            case UnaryExpression.Operator.PLUS -> this.mCExpressionTranslator.handleUnaryArithmeticOperators(cACSLLocation, 2, this.dispatchSwitch(iDispatcher, unaryExpression.getExpr(), cACSLLocation));
            case UnaryExpression.Operator.LOGICCOMPLEMENT -> this.mCExpressionTranslator.handleUnaryArithmeticOperators(cACSLLocation, 6, this.dispatchSwitch(iDispatcher, unaryExpression.getExpr(), cACSLLocation));
            case UnaryExpression.Operator.POINTER -> this.mCHandler.handleIndirectionOperator(this.dispatchSwitch(iDispatcher, unaryExpression.getExpr(), cACSLLocation), cACSLLocation, null);
            case UnaryExpression.Operator.ADDROF -> this.handleAddressof(cACSLLocation, (ExpressionResult)iDispatcher.dispatch((ACSLNode)unaryExpression.getExpr(), iDispatcher.getAcslHook()));
            case UnaryExpression.Operator.LTLGLOBALLY, UnaryExpression.Operator.LTLFINALLY, UnaryExpression.Operator.LTLNEXT -> throw new UnsupportedSyntaxException(cACSLLocation, "Unknown or unsupported unary operation: " + String.valueOf(unaryExpression.getOperator()));
            default -> throw new MatchException(null, null);
        };
    }

    private ExpressionResult handleAddressof(ILocation iLocation, ExpressionResult expressionResult) {
        if (!(expressionResult.getLrValue() instanceof HeapLValue)) {
            throw new UnsupportedSyntaxException(iLocation, "ACSL addressof for variable off-heap");
        }
        RValue rValue = ((HeapLValue)expressionResult.getLrValue()).getAddressAsPointerRValue(this.mTypeHandler.getBoogiePointerType());
        return new ExpressionResultBuilder(expressionResult).resetLrValue(rValue).build();
    }

    @Override
    public Result visit(IDispatcher iDispatcher, IntegerLiteral integerLiteral) {
        CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation((ACSLNode)integerLiteral);
        String string = integerLiteral.getValue();
        RValue rValue = this.mExpressionTranslation.translateIntegerLiteral(cACSLLocation, string);
        return new ExpressionResult(rValue);
    }

    @Override
    public Result visit(IDispatcher iDispatcher, BooleanLiteral booleanLiteral) {
        return new ExpressionResult(new RValue((de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)ExpressionFactory.createBooleanLiteral((ILocation)this.mLocationFactory.createACSLLocation((ACSLNode)booleanLiteral), (boolean)booleanLiteral.getValue()), new CPrimitive(CPrimitive.CPrimitives.BOOL), true));
    }

    @Override
    public Result visit(IDispatcher iDispatcher, RealLiteral realLiteral) {
        RValue rValue = this.mExpressionTranslation.translateFloatingLiteral(this.mLocationFactory.createACSLLocation((ACSLNode)realLiteral), realLiteral.getValue());
        return new ExpressionResult(rValue);
    }

    @Override
    public Result visit(IDispatcher iDispatcher, de.uni_freiburg.informatik.ultimate.model.acsl.ast.IdentifierExpression identifierExpression) {
        LRValue lRValue;
        LRValue lRValue2 = (LRValue)this.mBoundVariables.get((Object)identifierExpression.getIdentifier());
        if (lRValue2 != null) {
            return new ExpressionResult(lRValue2);
        }
        CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation((ACSLNode)identifierExpression);
        String string = this.lookupId(iDispatcher, identifierExpression, cACSLLocation);
        String string2 = this.mSymboltable.getCIdForBoogieId(string);
        SymbolTableValue symbolTableValue = this.mSymboltable.findCSymbol(iDispatcher.getAcslHook(), string2);
        if (symbolTableValue == null) {
            throw new UnsupportedOperationException("not yet implemented: unable to determine CType for variable " + string);
        }
        ICType iCType = symbolTableValue.getCType();
        if (this.mCHandler.isHeapVar(string)) {
            IdentifierExpression identifierExpression2 = ExpressionFactory.constructIdentifierExpression((ILocation)cACSLLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForBoogieASTType(symbolTableValue.getAstType()), (String)string, (DeclarationInformation)symbolTableValue.getDeclarationInformation());
            lRValue = LRValueFactory.constructHeapLValue(this.mTypeHandler, (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)identifierExpression2, iCType, null);
        } else {
            VariableLHS variableLHS = ExpressionFactory.constructVariableLHS((ILocation)cACSLLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForBoogieASTType(symbolTableValue.getAstType()), (String)string, (DeclarationInformation)symbolTableValue.getDeclarationInformation());
            lRValue = new LocalLValue((LeftHandSide)variableLHS, iCType, null);
        }
        return new ExpressionResult(lRValue);
    }

    private String lookupId(IDispatcher iDispatcher, de.uni_freiburg.informatik.ultimate.model.acsl.ast.IdentifierExpression identifierExpression, ILocation iLocation) {
        String string = this.mSymboltable.applyMultiparseRenaming(iDispatcher.getAcslHook().getContainingFilename(), identifierExpression.getIdentifier());
        SymbolTableValue symbolTableValue = this.mSymboltable.findCSymbol(iDispatcher.getAcslHook(), string);
        if (symbolTableValue == null) {
            throw new IncorrectSyntaxException(iLocation, "Undeclared variable in ACSL expression: " + identifierExpression.getIdentifier());
        }
        return switch (this.mSpecType) {
            case SPEC_TYPE.ASSIGNS -> {
                if (symbolTableValue.isBoogieGlobalVar()) {
                    yield symbolTableValue.getBoogieName();
                }
                throw new IncorrectSyntaxException(iLocation, "It is not allowed to assign to in parameters! Should be global variables! [" + identifierExpression.getIdentifier() + "]");
            }
            case SPEC_TYPE.ENSURES -> {
                if ("\result".equalsIgnoreCase(identifierExpression.getIdentifier())) {
                    yield "#res";
                }
                yield symbolTableValue.getBoogieName();
            }
            case SPEC_TYPE.NOT, SPEC_TYPE.REQUIRES -> symbolTableValue.getBoogieName();
            default -> throw new MatchException(null, null);
        };
    }

    @Override
    public Result visit(IDispatcher iDispatcher, de.uni_freiburg.informatik.ultimate.model.acsl.ast.QuantifierExpression quantifierExpression) {
        Object object;
        this.mBoundVariables.beginScope();
        CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation((ACSLNode)quantifierExpression);
        ArrayList<VarList> arrayList = new ArrayList<VarList>();
        ArrayList<de.uni_freiburg.informatik.ultimate.boogie.ast.Expression> arrayList2 = new ArrayList<de.uni_freiburg.informatik.ultimate.boogie.ast.Expression>();
        Declaration[] declarationArray = quantifierExpression.getVariables();
        int n = declarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = declarationArray[n2];
            ICType iCType = AcslTypeUtils.translateAcslTypeToCType(object.getType());
            if (!(iCType instanceof CPrimitive)) {
                throw new UnsupportedSyntaxException(cACSLLocation, "Only quantified variables of primitive type are supported.");
            }
            DeclarationInformation declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.QUANTIFIED, null);
            BoogieType boogieType = this.mTypeHandler.getBoogieTypeForCType(iCType);
            String string = object.getName();
            this.mBoundVariables.put((Object)string, (Object)new LocalLValue((LeftHandSide)new VariableLHS((ILocation)cACSLLocation, (IBoogieType)boogieType, string, declarationInformation), iCType, false));
            arrayList.add(new VarList((ILocation)cACSLLocation, new String[]{string}, this.mTypeHandler.cType2AstType(cACSLLocation, iCType)));
            IdentifierExpression identifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)cACSLLocation, (BoogieType)boogieType, (String)string, (DeclarationInformation)declarationInformation);
            Optional<de.uni_freiburg.informatik.ultimate.boogie.ast.Expression> optional = this.mExpressionTranslation.getTypeConstraint(cACSLLocation, (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)identifierExpression, iCType);
            if (optional.isPresent()) {
                arrayList2.add(optional.get());
            }
            ++n2;
        }
        object = this.mExprResultTransformer.rexIntToBool(this.dispatchSwitch(iDispatcher, quantifierExpression.getSubformula(), cACSLLocation), cACSLLocation);
        if (!((ExpressionResult)object).hasNoSideEffects()) {
            throw new UnsupportedSyntaxException(cACSLLocation, "Unable to handle quantified expressions with side-effects.");
        }
        de.uni_freiburg.informatik.ultimate.boogie.ast.Expression expression = ExpressionFactory.newBinaryExpression((ILocation)cACSLLocation, (BinaryExpression.Operator)(quantifierExpression.isUniversal() ? BinaryExpression.Operator.LOGICIMPLIES : BinaryExpression.Operator.LOGICAND), (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)ExpressionFactory.and((ILocation)cACSLLocation, arrayList2), (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)((ExpressionResult)object).getLrValue().getValue());
        QuantifierExpression quantifierExpression2 = ExpressionFactory.quantifier((ILocation)cACSLLocation, (boolean)quantifierExpression.isUniversal(), arrayList, (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)expression);
        this.mBoundVariables.endScope();
        return new ExpressionResult(new RValue((de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)quantifierExpression2, new CPrimitive(CPrimitive.CPrimitives.BOOL), true));
    }

    @Override
    public Result visit(IDispatcher iDispatcher, Contract contract) {
        CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation((ACSLNode)contract);
        ArrayList<Specification> arrayList = new ArrayList<Specification>();
        ContractStatement[] contractStatementArray = contract.getContractStmt();
        int n = contractStatementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContractStatement contractStatement = contractStatementArray[n2];
            arrayList.addAll(Arrays.asList(((ContractResult)iDispatcher.dispatch((ACSLNode)contractStatement, iDispatcher.getAcslHook())).getSpecs()));
            ++n2;
        }
        if (contract.getBehaviors() != null && contract.getBehaviors().length != 0) {
            throw new UnsupportedSyntaxException(cACSLLocation, "Not yet implemented: Behaviour");
        }
        this.mSpecType = SPEC_TYPE.NOT;
        return new ContractResult(arrayList.toArray(new Specification[arrayList.size()]));
    }

    @Override
    public Result visit(IDispatcher iDispatcher, Requires requires) {
        this.mSpecType = SPEC_TYPE.REQUIRES;
        CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation((ACSLNode)requires);
        ExpressionResult expressionResult = this.mExprResultTransformer.rexIntToBool(this.dispatchSwitch(iDispatcher, requires.getFormula(), cACSLLocation), cACSLLocation);
        if (!expressionResult.hasNoSideEffects()) {
            throw new UnsupportedSyntaxException(cACSLLocation, "Requires must be translatable by a single expression");
        }
        de.uni_freiburg.informatik.ultimate.boogie.ast.Expression expression = expressionResult.getLrValue().getValue();
        Check check = new Check(Spec.PRE_CONDITION);
        CACSLLocation cACSLLocation2 = this.mLocationFactory.createACSLLocation((ACSLNode)requires);
        RequiresSpecification requiresSpecification = new RequiresSpecification((ILocation)cACSLLocation2, false, expression);
        check.annotate((IElement)requiresSpecification);
        return new ContractResult(new Specification[]{requiresSpecification});
    }

    @Override
    public Result visit(IDispatcher iDispatcher, Ensures ensures) {
        CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation((ACSLNode)ensures);
        ExpressionResult expressionResult = this.mExprResultTransformer.rexIntToBool(this.dispatchSwitch(iDispatcher, ensures.getFormula(), cACSLLocation), cACSLLocation);
        if (!expressionResult.hasNoSideEffects()) {
            throw new UnsupportedSyntaxException(cACSLLocation, "Ensures must be translatable by a single expression");
        }
        this.mSpecType = SPEC_TYPE.ENSURES;
        de.uni_freiburg.informatik.ultimate.boogie.ast.Expression expression = expressionResult.getLrValue().getValue();
        Check check = new Check(Spec.POST_CONDITION);
        CACSLLocation cACSLLocation2 = this.mLocationFactory.createACSLLocation((ACSLNode)ensures);
        EnsuresSpecification ensuresSpecification = new EnsuresSpecification((ILocation)cACSLLocation2, false, expression);
        check.annotate((IElement)ensuresSpecification);
        return new ContractResult(new Specification[]{ensuresSpecification});
    }

    @Override
    public Result visit(IDispatcher iDispatcher, Assigns assigns) {
        Expression expression;
        this.mSpecType = SPEC_TYPE.ASSIGNS;
        CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation((ACSLNode)assigns);
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        Expression[] expressionArray = assigns.getLocations();
        int n = expressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string;
            expression = expressionArray[n2];
            if (!(expression instanceof de.uni_freiburg.informatik.ultimate.model.acsl.ast.IdentifierExpression)) {
                string = "Unexpected Expression: " + String.valueOf(expression.getClass());
                throw new UnsupportedSyntaxException(cACSLLocation, string);
            }
            string = (IdentifierExpression)iDispatcher.dispatch((ACSLNode)expression, iDispatcher.getAcslHook()).getNode();
            arrayList.add((CallSite)((Object)string));
            ++n2;
        }
        expression = new VariableLHS[arrayList.size()];
        n2 = 0;
        while (n2 < arrayList.size()) {
            expression[n2] = ExpressionFactory.constructVariableLHS((ILocation)cACSLLocation, (BoogieType)((BoogieType)((IdentifierExpression)arrayList.get(n2)).getType()), (String)((IdentifierExpression)arrayList.get(n2)).getIdentifier(), (DeclarationInformation)((IdentifierExpression)arrayList.get(n2)).getDeclarationInformation());
            ++n2;
        }
        ModifiesSpecification modifiesSpecification = new ModifiesSpecification((ILocation)cACSLLocation, false, (VariableLHS[])expression);
        return new ContractResult(new Specification[]{modifiesSpecification});
    }

    @Override
    public Result visit(IDispatcher iDispatcher, ACSLResultExpression aCSLResultExpression) {
        CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation((ACSLNode)aCSLResultExpression);
        ICType iCType = this.mProcedureManager.getReturnTypeOfCurrentProcedure();
        IdentifierExpression identifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)cACSLLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(iCType), (String)"#res", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM, this.mProcedureManager.getCurrentProcedureID()));
        return new ExpressionResult(new RValue((de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)identifierExpression, iCType));
    }

    @Override
    public Result visit(IDispatcher iDispatcher, LoopAnnot loopAnnot) {
        if (loopAnnot.getLoopBehavior() != null && loopAnnot.getLoopBehavior().length != 0) {
            CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation((ACSLNode)loopAnnot);
            throw new UnsupportedSyntaxException(cACSLLocation, "Not yet implemented: Behaviour");
        }
        ArrayList<Specification> arrayList = new ArrayList<Specification>();
        LoopStatement[] loopStatementArray = loopAnnot.getLoopStmt();
        int n = loopStatementArray.length;
        int n2 = 0;
        while (n2 < n) {
            LoopStatement loopStatement = loopStatementArray[n2];
            ContractResult contractResult = (ContractResult)iDispatcher.dispatch((ACSLNode)loopStatement, iDispatcher.getAcslHook());
            assert (contractResult != null);
            arrayList.addAll(Arrays.asList(contractResult.getSpecs()));
            ++n2;
        }
        return new ContractResult(arrayList.toArray(new Specification[arrayList.size()]));
    }

    @Override
    public Result visit(IDispatcher iDispatcher, LoopInvariant loopInvariant) {
        CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation((ACSLNode)loopInvariant);
        ExpressionResult expressionResult = this.mExprResultTransformer.rexIntToBool(this.dispatchSwitch(iDispatcher, loopInvariant.getFormula(), cACSLLocation), cACSLLocation);
        if (!expressionResult.hasNoSideEffects()) {
            throw new UnsupportedSyntaxException(cACSLLocation, "We support only side-effect free specifications.");
        }
        assert (expressionResult != null && expressionResult.getLrValue().getValue() != null);
        Check check = new Check(Spec.INVARIANT);
        CACSLLocation cACSLLocation2 = this.mLocationFactory.createACSLLocation((ACSLNode)loopInvariant);
        LoopInvariantSpecification loopInvariantSpecification = new LoopInvariantSpecification((ILocation)cACSLLocation2, false, expressionResult.getLrValue().getValue());
        check.annotate((IElement)loopInvariantSpecification);
        return new ContractResult(new Specification[]{loopInvariantSpecification});
    }

    @Override
    public Result visit(IDispatcher iDispatcher, LoopVariant loopVariant) {
        CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation((ACSLNode)loopVariant);
        throw new UnsupportedSyntaxException(cACSLLocation, "Not yet implemented: LoopVariant");
    }

    @Override
    public Result visit(IDispatcher iDispatcher, LoopAssigns loopAssigns) {
        CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation((ACSLNode)loopAssigns);
        throw new UnsupportedSyntaxException(cACSLLocation, "Not yet implemented: LoopAssigns");
    }

    @Override
    public Result visit(IDispatcher iDispatcher, de.uni_freiburg.informatik.ultimate.model.acsl.ast.ArrayAccessExpression arrayAccessExpression) {
        CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation((ACSLNode)arrayAccessExpression);
        ExpressionResult expressionResult = (ExpressionResult)iDispatcher.dispatch((ACSLNode)arrayAccessExpression.getArray(), iDispatcher.getAcslHook());
        ExpressionResult expressionResult2 = this.dispatchSwitch(iDispatcher, arrayAccessExpression.getIndex(), cACSLLocation);
        return this.mCHandler.handleArraySubscriptExpression(expressionResult, expressionResult2, iDispatcher.getAcslHook());
    }

    @Override
    public Result visit(IDispatcher iDispatcher, FieldAccessExpression fieldAccessExpression) {
        CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation((ACSLNode)fieldAccessExpression);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        ExpressionResult expressionResult = this.dispatchSwitch(iDispatcher, fieldAccessExpression.getStruct(), cACSLLocation);
        assert (expressionResult.getClass() == ExpressionResult.class);
        String string = fieldAccessExpression.getField();
        expressionResultBuilder.addAllExceptLrValue(expressionResult);
        StructAccessExpression structAccessExpression = ExpressionFactory.constructStructAccessExpression((ILocation)cACSLLocation, (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)expressionResult.getLrValue().getValue(), (String)string);
        RValue rValue = new RValue((de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)structAccessExpression, ((CStructOrUnion)expressionResult.getLrValue().getCType().getUnderlyingType()).getFieldType(string));
        expressionResultBuilder.setLrValue(rValue);
        return expressionResultBuilder.build();
    }

    @Override
    public Result visit(IDispatcher iDispatcher, FreeableExpression freeableExpression) {
        CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation((ACSLNode)freeableExpression);
        ExpressionResult expressionResult = (ExpressionResult)iDispatcher.dispatch((ACSLNode)freeableExpression.getExpression(), iDispatcher.getAcslHook());
        de.uni_freiburg.informatik.ultimate.boogie.ast.Expression expression = (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)expressionResult.getNode();
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        expressionResultBuilder.addAllExceptLrValue(expressionResult);
        expression = ExpressionFactory.constructStructAccessExpression((ILocation)cACSLLocation, (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)expression, (String)"base");
        de.uni_freiburg.informatik.ultimate.boogie.ast.Expression[] expressionArray = new de.uni_freiburg.informatik.ultimate.boogie.ast.Expression[]{expression};
        IdentifierExpression identifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)cACSLLocation, (BoogieType)BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{BoogieType.TYPE_INT}, (BoogieType)BoogieType.TYPE_INT), (String)"#valid", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.GLOBAL, null));
        ArrayAccessExpression arrayAccessExpression = ExpressionFactory.constructNestedArrayAccessExpression((ILocation)cACSLLocation, (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)identifierExpression, (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression[])expressionArray);
        RValue rValue = new RValue((de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)arrayAccessExpression, new CPrimitive(CPrimitive.CPrimitives.INT));
        expressionResultBuilder.setLrValue(rValue);
        return expressionResultBuilder.build();
    }

    @Override
    public Result visit(IDispatcher iDispatcher, MallocableExpression mallocableExpression) {
        CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation((ACSLNode)mallocableExpression);
        ExpressionResult expressionResult = (ExpressionResult)iDispatcher.dispatch((ACSLNode)mallocableExpression.getExpression(), iDispatcher.getAcslHook());
        de.uni_freiburg.informatik.ultimate.boogie.ast.Expression expression = expressionResult.getLrValue().getValue();
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        expressionResultBuilder.addAllExceptLrValue(expressionResult);
        expression = ExpressionFactory.constructStructAccessExpression((ILocation)cACSLLocation, (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)expression, (String)"base");
        de.uni_freiburg.informatik.ultimate.boogie.ast.Expression[] expressionArray = new de.uni_freiburg.informatik.ultimate.boogie.ast.Expression[]{expression};
        IdentifierExpression identifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)cACSLLocation, (BoogieType)BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{BoogieType.TYPE_INT}, (BoogieType)BoogieType.TYPE_INT), (String)"#valid", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.GLOBAL, null));
        ArrayAccessExpression arrayAccessExpression = ExpressionFactory.constructNestedArrayAccessExpression((ILocation)cACSLLocation, (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)identifierExpression, (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression[])expressionArray);
        de.uni_freiburg.informatik.ultimate.boogie.ast.Expression expression2 = ExpressionFactory.constructUnaryExpression((ILocation)cACSLLocation, (UnaryExpression.Operator)UnaryExpression.Operator.LOGICNEG, (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)arrayAccessExpression);
        RValue rValue = new RValue(expression2, new CPrimitive(CPrimitive.CPrimitives.INT));
        expressionResultBuilder.setLrValue(rValue);
        return expressionResultBuilder.build();
    }

    @Override
    public Result visit(IDispatcher iDispatcher, ValidExpression validExpression) {
        CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation((ACSLNode)validExpression);
        ExpressionResult expressionResult = (ExpressionResult)iDispatcher.dispatch((ACSLNode)validExpression.getExpression(), iDispatcher.getAcslHook());
        de.uni_freiburg.informatik.ultimate.boogie.ast.Expression expression = expressionResult.getLrValue().getValue();
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        expressionResultBuilder.addAllExceptLrValue(expressionResult);
        expression = ExpressionFactory.constructStructAccessExpression((ILocation)cACSLLocation, (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)expression, (String)"base");
        de.uni_freiburg.informatik.ultimate.boogie.ast.Expression[] expressionArray = new de.uni_freiburg.informatik.ultimate.boogie.ast.Expression[]{expression};
        IdentifierExpression identifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)cACSLLocation, (BoogieType)BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{BoogieType.TYPE_INT}, (BoogieType)BoogieType.TYPE_INT), (String)"#valid", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.GLOBAL, null));
        ArrayAccessExpression arrayAccessExpression = ExpressionFactory.constructNestedArrayAccessExpression((ILocation)cACSLLocation, (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)identifierExpression, (de.uni_freiburg.informatik.ultimate.boogie.ast.Expression[])expressionArray);
        RValue rValue = new RValue((de.uni_freiburg.informatik.ultimate.boogie.ast.Expression)arrayAccessExpression, new CPrimitive(CPrimitive.CPrimitives.INT));
        expressionResultBuilder.setLrValue(rValue);
        return expressionResultBuilder.build();
    }

    @Override
    public Result visit(IDispatcher iDispatcher, CastExpression castExpression) {
        CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation((ACSLNode)castExpression);
        ICType iCType = AcslTypeUtils.translateAcslTypeToCType(castExpression.getCastedType());
        ExpressionResult expressionResult = (ExpressionResult)iDispatcher.dispatch((ACSLNode)castExpression.getExpression());
        expressionResult = this.mExprResultTransformer.makeRepresentationReadyForConversion(expressionResult, cACSLLocation, iCType, iDispatcher.getAcslHook());
        return this.mExprResultTransformer.performImplicitConversion(expressionResult, iCType, cACSLLocation);
    }

    @Override
    public Result visit(IDispatcher iDispatcher, IfThenElseExpression ifThenElseExpression) {
        CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation((ACSLNode)ifThenElseExpression);
        assert (ifThenElseExpression.getOutgoingNodes().size() == 4);
        ExpressionResult expressionResult = this.dispatchSwitch(iDispatcher, ifThenElseExpression.getCondition(), cACSLLocation);
        ExpressionResult expressionResult2 = this.dispatchSwitch(iDispatcher, ifThenElseExpression.getThenPart(), cACSLLocation);
        ExpressionResult expressionResult3 = this.dispatchSwitch(iDispatcher, ifThenElseExpression.getElsePart(), cACSLLocation);
        return this.mCExpressionTranslator.handleConditionalOperator(cACSLLocation, expressionResult, expressionResult2, expressionResult3, iDispatcher.getAcslHook());
    }

    @Override
    public Result visit(IDispatcher iDispatcher, NullPointer nullPointer) {
        return new ExpressionResult(new RValue(this.mExpressionTranslation.constructNullPointer(this.mLocationFactory.createACSLLocation((ACSLNode)nullPointer)), CPointer.voidPointer()));
    }

    @Override
    public Result visit(IDispatcher iDispatcher, ACSLProblemNode aCSLProblemNode) {
        CACSLLocation cACSLLocation = this.mLocationFactory.createACSLLocation((ACSLNode)aCSLProblemNode);
        throw new UnsupportedSyntaxException(cACSLLocation, "Error during parsing of ACSL (" + aCSLProblemNode.getErrorMessage() + ")");
    }

    private static enum SPEC_TYPE {
        NOT,
        REQUIRES,
        ASSIGNS,
        ENSURES;

    }
}

