/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.ISmtDeclarable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.NonDeclaringTermTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.UltimateNormalFormUtils;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.TermParseUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;

public final class DeclarableFunctionSymbol
implements ISmtDeclarable {
    private final String mId;
    private final String[] mParamIds;
    private final Sort[] mParamSorts;
    private final Sort mResultSort;
    private final Term mFunctionDefinition;
    private Term[] mParamVars;

    public DeclarableFunctionSymbol(String string, Sort[] sortArray, Sort sort) {
        this(string, null, sortArray, sort, null);
    }

    public DeclarableFunctionSymbol(String string, String[] stringArray, Sort[] sortArray, Sort sort, Term term) {
        this.mId = Objects.requireNonNull(string);
        this.mParamSorts = Objects.requireNonNull(sortArray);
        this.mResultSort = Objects.requireNonNull(sort);
        this.mParamIds = stringArray;
        this.mFunctionDefinition = term;
    }

    public static DeclarableFunctionSymbol createFromScriptDefineFun(String string, TermVariable[] termVariableArray, Sort sort, Term term) {
        String[] stringArray = new String[termVariableArray.length];
        Sort[] sortArray = new Sort[termVariableArray.length];
        int n = 0;
        while (n < termVariableArray.length) {
            stringArray[n] = termVariableArray[n].getName();
            sortArray[n] = termVariableArray[n].getSort();
            ++n;
        }
        return new DeclarableFunctionSymbol(string, stringArray, sortArray, sort, term);
    }

    public static DeclarableFunctionSymbol createFromScriptDeclareFun(String string, Sort[] sortArray, Sort sort) {
        return new DeclarableFunctionSymbol(string, sortArray, sort);
    }

    public static DeclarableFunctionSymbol createFromString(Script script, String string, String string2, String[] stringArray, Sort[] sortArray, Sort sort) {
        Term term;
        if (string2 == null) {
            return new DeclarableFunctionSymbol(string, sortArray, sort);
        }
        if (stringArray.length == 0) {
            term = TermParseUtils.parseTerm((Script)script, (String)string2);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(forall (");
            int n = 0;
            while (n < stringArray.length) {
                stringBuilder.append("(");
                stringBuilder.append(stringArray[n]);
                stringBuilder.append(" ");
                stringBuilder.append(sortArray[n]);
                stringBuilder.append(")");
                ++n;
            }
            stringBuilder.append(") ");
            stringBuilder.append(string2);
            stringBuilder.append(")");
            QuantifiedFormula quantifiedFormula = (QuantifiedFormula)TermParseUtils.parseTerm((Script)script, (String)stringBuilder.toString());
            term = quantifiedFormula.getSubformula();
            assert (UltimateNormalFormUtils.respectsUltimateNormalForm(term)) : "SMT function body not in Ultimate normal form";
        }
        return new DeclarableFunctionSymbol(string, stringArray, sortArray, sort, term);
    }

    @Override
    public void defineOrDeclare(Script script) {
        NonDeclaringTermTransferrer nonDeclaringTermTransferrer = new NonDeclaringTermTransferrer(script);
        Sort[] sortArray = nonDeclaringTermTransferrer.transferSorts(this.mParamSorts);
        Sort sort = nonDeclaringTermTransferrer.transferSort(this.mResultSort);
        if (this.mFunctionDefinition == null) {
            script.declareFun(this.mId, sortArray, sort);
        } else {
            TermVariable[] termVariableArray = new TermVariable[this.mParamSorts.length];
            int n = 0;
            while (n < this.mParamSorts.length) {
                if (this.mParamIds[n] == null) {
                    throw new ISmtDeclarable.IllegalSmtDeclarableUsageException("Unnamed parameter in function declaration together with smtdefined attribute");
                }
                termVariableArray[n] = script.variable(this.mParamIds[n], sortArray[n]);
                ++n;
            }
            Term term = new NonDeclaringTermTransferrer(script).transform(this.mFunctionDefinition);
            script.defineFun(this.mId, termVariableArray, sort, term);
        }
    }

    public Term getDefinition() {
        return this.mFunctionDefinition;
    }

    @Override
    public String getName() {
        return this.mId;
    }

    public String[] getParamIds() {
        return this.mParamIds;
    }

    public Sort[] getParamSorts() {
        return this.mParamSorts;
    }

    public Sort getResultSort() {
        return this.mResultSort;
    }

    public Term[] getParamVars() {
        if (this.mParamVars == null) {
            this.mParamVars = this.computeParamVars();
        }
        return this.mParamVars;
    }

    private Term[] computeParamVars() {
        if (this.mFunctionDefinition == null) {
            throw new ISmtDeclarable.IllegalSmtDeclarableUsageException("Cannot compute parameter vars if there is no body");
        }
        HashMap hashMap = new HashMap();
        Arrays.stream(this.mFunctionDefinition.getFreeVars()).forEach(termVariable -> {
            TermVariable termVariable2 = hashMap.put(termVariable.getName(), termVariable);
        });
        this.mParamVars = new Term[this.mParamIds.length];
        int n = 0;
        while (n < this.mParamIds.length) {
            this.mParamVars[n] = (Term)hashMap.get(this.mParamIds[n]);
            ++n;
        }
        return this.mParamVars;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = PrintTerm.quoteIdentifier((String)this.mId);
        stringBuilder.append('(').append(string);
        Sort[] sortArray = this.mParamSorts;
        int n = this.mParamSorts.length;
        int n2 = 0;
        while (n2 < n) {
            Sort sort = sortArray[n2];
            stringBuilder.append(' ').append(sort);
            ++n2;
        }
        stringBuilder.append(' ').append(this.mResultSort);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

