/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.NonTheorySymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.ConnectionPartition;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XjunctPartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class XnfUpd
extends XjunctPartialQuantifierElimination {
    public XnfUpd(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider) {
        super(managedScript, iUltimateServiceProvider);
    }

    @Override
    public String getName() {
        return "unconnected parameter drop";
    }

    @Override
    public String getAcronym() {
        return "UPD";
    }

    @Override
    public boolean resultIsXjunction() {
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Term[] tryToEliminate(int n, Term[] termArray, Set<TermVariable> set) {
        void var11_18;
        Script.LBool lBool;
        Object object;
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        Object object2 = termArray;
        int n2 = termArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = object2[n3];
            hashSet.addAll(Arrays.asList(object.getFreeVars()));
            ++n3;
        }
        set.retainAll(hashSet);
        object = new ConnectionPartition(Arrays.asList(termArray));
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        object2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        for (Set<NonTheorySymbol<?>> set2 : ((ConnectionPartition)object).getConnectedNonTheorySymbols()) {
            boolean bl;
            Set<Term> set3 = ((ConnectionPartition)object).getTermsOfConnectedNonTheorySymbols(set2);
            lBool = SmtUtils.getFreeVars(set3);
            if (!XnfUpd.containsOnlyVariables(set2)) {
                bl = false;
            } else if (n == 0) {
                var15_24 = XnfUpd.isSuperfluousConjunction(this.mScript, set3, lBool, set);
                if (SmtUtils.isTrueLiteral(var15_24)) {
                    bl = true;
                } else {
                    if (SmtUtils.isFalseLiteral(var15_24)) {
                        return new Term[]{var15_24};
                    }
                    if (var15_24 != null) throw new AssertionError((Object)"illegal case");
                    bl = false;
                }
            } else {
                if (n != 1) throw new AssertionError((Object)"unknown quantifier");
                var15_24 = XnfUpd.isSuperfluousDisjunction(this.mScript, set3, (Set<TermVariable>)lBool, set);
                if (SmtUtils.isFalseLiteral(var15_24)) {
                    bl = true;
                } else {
                    if (SmtUtils.isTrueLiteral(var15_24)) {
                        return new Term[]{var15_24};
                    }
                    if (var15_24 != null) throw new AssertionError((Object)"illegal case");
                    bl = false;
                }
            }
            if (bl) {
                arrayList.addAll(lBool);
                object2.addAll(set3);
                continue;
            }
            arrayList2.addAll(lBool);
            arrayList3.addAll(set3);
        }
        List<Term> list = ((ConnectionPartition)object).getTermsWithNonTheorySymbols();
        assert (hashSet.size() == arrayList.size() + arrayList2.size());
        assert (termArray.length == object2.size() + arrayList3.size() + list.size());
        for (Term term : list) {
            lBool = Util.checkSat((Script)this.mScript, (Term)term);
            if (lBool == Script.LBool.UNSAT) {
                if (n == 0) {
                    set.clear();
                    return new Term[]{this.mScript.term("false", new Term[0])};
                }
                if (n != 1) {
                    throw new AssertionError((Object)"unknown quantifier");
                }
                continue;
            }
            if (lBool != Script.LBool.SAT) throw new AssertionError((Object)"expecting sat or unsat");
            if (n == 0) continue;
            if (n != 1) throw new AssertionError((Object)"unknown quantifier");
            set.clear();
            return new Term[]{this.mScript.term("true", new Term[0])};
        }
        if (object2.isEmpty()) {
            return termArray;
        }
        set.removeAll(arrayList);
        if (arrayList3.isEmpty()) {
            if (n == 0) {
                Term[] termArray2 = new Term[]{this.mScript.term("true", new Term[0])};
                return var11_18;
            } else {
                if (n != 1) throw new AssertionError((Object)"unknown quantifier");
                Term[] termArray3 = new Term[]{this.mScript.term("false", new Term[0])};
            }
            return var11_18;
        } else {
            Term[] termArray4 = arrayList3.toArray(new Term[arrayList3.size()]);
        }
        return var11_18;
    }

    private static boolean containsOnlyVariables(Set<NonTheorySymbol<?>> set) {
        Predicate<NonTheorySymbol> predicate = nonTheorySymbol -> nonTheorySymbol instanceof NonTheorySymbol.Variable;
        return set.stream().allMatch(predicate);
    }

    public static Term isSuperfluousConjunction(Script script, Set<Term> set, Set<TermVariable> set2, Set<TermVariable> set3) {
        if (set3.containsAll(set2)) {
            Term term = SmtUtils.and(script, set);
            Script.LBool lBool = Util.checkSat((Script)script, (Term)term);
            if (lBool == Script.LBool.SAT) {
                return script.term("true", new Term[0]);
            }
            if (lBool == Script.LBool.UNSAT) {
                return script.term("false", new Term[0]);
            }
        }
        return null;
    }

    public static Term isSuperfluousDisjunction(Script script, Set<Term> set, Set<TermVariable> set2, Set<TermVariable> set3) {
        if (set3.containsAll(set2)) {
            Term term = SmtUtils.or(script, set.toArray(new Term[set.size()]));
            Script.LBool lBool = Util.checkSat((Script)script, (Term)SmtUtils.not(script, term));
            if (lBool == Script.LBool.SAT) {
                return script.term("false", new Term[0]);
            }
            if (lBool == Script.LBool.UNSAT) {
                return script.term("true", new Term[0]);
            }
        }
        return null;
    }
}

