/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.ISymbolicIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementEngineResult;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.ILooperCheck;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.ILattice;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.PowersetLattice;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.UpsideDownLattice;
import java.util.Set;
import java.util.stream.Collectors;

public class LooperIndependenceRelation<L extends IAction, S>
implements IIndependenceRelation<S, L> {
    private final Set<IPredicate> mPredicates;
    private final ILooperCheck<L> mLooperCheck;
    private final ILattice<Set<IPredicate>> mHierarchy = new UpsideDownLattice((ILattice)new PowersetLattice());

    public LooperIndependenceRelation(Set<IPredicate> set, ILooperCheck<L> iLooperCheck) {
        this.mPredicates = set;
        this.mLooperCheck = iLooperCheck;
    }

    public boolean isSymmetric() {
        return true;
    }

    public boolean isConditional() {
        return false;
    }

    public IIndependenceRelation.Dependence isIndependent(S s, L l, L l2) {
        Script.LBool lBool = this.mLooperCheck.isUniversalLooper(l, this.mPredicates);
        if (lBool == Script.LBool.UNSAT) {
            return IIndependenceRelation.Dependence.INDEPENDENT;
        }
        Script.LBool lBool2 = this.mLooperCheck.isUniversalLooper(l2, this.mPredicates);
        if (lBool2 == Script.LBool.UNSAT) {
            return IIndependenceRelation.Dependence.INDEPENDENT;
        }
        if (lBool == Script.LBool.UNKNOWN || lBool2 == Script.LBool.UNKNOWN) {
            return IIndependenceRelation.Dependence.UNKNOWN;
        }
        return IIndependenceRelation.Dependence.DEPENDENT;
    }

    public ISymbolicIndependenceRelation<L, S> getSymbolicRelation() {
        return null;
    }

    public ILattice<Set<IPredicate>> getHierarchy() {
        return this.mHierarchy;
    }

    public Set<IPredicate> getInitial() {
        return (Set)this.mHierarchy.getTop();
    }

    public static <L extends IIcfgTransition<?>> Set<IPredicate> refine(Set<IPredicate> set, IRefinementEngineResult<L, ?> iRefinementEngineResult) {
        Set set2 = iRefinementEngineResult.getUsedTracePredicates().stream().flatMap(qualifiedTracePredicates -> qualifiedTracePredicates.getPredicates().stream()).collect(Collectors.toSet());
        return DataStructureUtils.union(set, set2);
    }
}

