/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.BinaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IConcurrentProductStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class ConcurrentProduct<LETTER, STATE>
extends BinaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mFstOperand;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mSndOperand;
    private final boolean mConcurrentPrefixProduct;
    private final NestedWordAutomaton<LETTER, STATE> mResult;
    private final StatePairQueue mWorklist = new StatePairQueue();
    private final StatePair2StateMap mInputPair2resultState = new StatePair2StateMap();
    private final HashSet<LETTER> mSynchronizationAlphabet;
    private final IConcurrentProductStateFactory<STATE> mContentFactory;

    public ConcurrentProduct(AutomataLibraryServices automataLibraryServices, IConcurrentProductStateFactory<STATE> iConcurrentProductStateFactory, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider2, boolean bl) {
        super(automataLibraryServices);
        this.mFstOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mSndOperand = iNwaOutgoingLetterAndTransitionProvider2;
        this.mConcurrentPrefixProduct = bl;
        this.mContentFactory = iConcurrentProductStateFactory;
        if (!(!this.mLogger.isWarnEnabled() || NestedWordAutomataUtils.isFiniteAutomaton(iNwaOutgoingLetterAndTransitionProvider) && NestedWordAutomataUtils.isFiniteAutomaton(iNwaOutgoingLetterAndTransitionProvider2))) {
            this.mLogger.warn((Object)"Call alphabet and return alphabet are ignored.");
        }
        this.mSynchronizationAlphabet = new HashSet(iNwaOutgoingLetterAndTransitionProvider.getAlphabet());
        this.mSynchronizationAlphabet.retainAll(iNwaOutgoingLetterAndTransitionProvider2.getAlphabet());
        HashSet hashSet = new HashSet(iNwaOutgoingLetterAndTransitionProvider.getAlphabet());
        hashSet.addAll(iNwaOutgoingLetterAndTransitionProvider2.getAlphabet());
        this.mResult = new NestedWordAutomaton(this.mServices, new VpAlphabet(hashSet), this.mContentFactory);
        this.constructInitialStates();
        while (!this.mWorklist.isEmpty()) {
            this.mWorklist.dequeuePair();
            Object STATE = this.mWorklist.getDequeuedPairFst();
            Object STATE2 = this.mWorklist.getDequeuedPairSnd();
            this.constructOutgoingTransitions(STATE, STATE2);
        }
    }

    private STATE getState(STATE STATE, STATE STATE2, boolean bl) {
        Object STATE3 = this.mInputPair2resultState.get(STATE, STATE2);
        if (STATE3 == null) {
            boolean bl2 = this.mConcurrentPrefixProduct ? this.mFstOperand.isFinal(STATE) || this.mSndOperand.isFinal(STATE2) : this.mFstOperand.isFinal(STATE) && this.mSndOperand.isFinal(STATE2);
            STATE STATE4 = STATE;
            STATE STATE5 = STATE2;
            STATE3 = this.mContentFactory.concurrentProduct(STATE4, STATE5);
            this.mResult.addState(bl, bl2, STATE3);
            this.mInputPair2resultState.put(STATE, STATE2, STATE3);
            this.mWorklist.enqueue(STATE, STATE2);
        }
        return STATE3;
    }

    private void constructOutgoingTransitions(STATE STATE, STATE STATE2) {
        Iterator<OutgoingInternalTransition<LETTER, STATE>> iterator;
        Object object;
        Iterable<OutgoingInternalTransition<LETTER, STATE>> iterable;
        STATE STATE3 = this.getState(STATE, STATE2, false);
        HashSet<LETTER> hashSet = new HashSet<LETTER>(this.mFstOperand.lettersInternal(STATE));
        hashSet.retainAll(this.mSndOperand.lettersInternal(STATE2));
        HashSet<LETTER> hashSet2 = new HashSet<LETTER>(this.mFstOperand.lettersInternal(STATE));
        hashSet2.removeAll(this.mSynchronizationAlphabet);
        HashSet<LETTER> hashSet3 = new HashSet<LETTER>(this.mSndOperand.lettersInternal(STATE2));
        hashSet3.removeAll(this.mSynchronizationAlphabet);
        for (LETTER LETTER : hashSet) {
            iterable = this.mFstOperand.internalSuccessors(STATE, LETTER);
            Iterable<OutgoingInternalTransition<LETTER, STATE>> object2 = this.mSndOperand.internalSuccessors(STATE2, LETTER);
            for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : iterable) {
                object = outgoingInternalTransition.getSucc();
                for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition2 : object2) {
                    STATE STATE4 = outgoingInternalTransition2.getSucc();
                    STATE STATE5 = this.getState(object, STATE4, false);
                    this.mResult.addInternalTransition(STATE3, LETTER, STATE5);
                }
            }
        }
        for (LETTER LETTER : hashSet2) {
            iterable = this.mFstOperand.internalSuccessors(STATE, LETTER);
            for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : iterable) {
                iterator = outgoingInternalTransition.getSucc();
                object = this.getState(iterator, STATE2, false);
                this.mResult.addInternalTransition(STATE3, LETTER, object);
            }
        }
        for (LETTER LETTER : hashSet3) {
            iterable = this.mSndOperand.internalSuccessors(STATE2, LETTER);
            for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : iterable) {
                iterator = outgoingInternalTransition.getSucc();
                object = this.getState(STATE, iterator, false);
                this.mResult.addInternalTransition(STATE3, LETTER, object);
            }
        }
    }

    private void constructInitialStates() {
        for (Object STATE : this.mFstOperand.getInitialStates()) {
            for (Object STATE2 : this.mSndOperand.getInitialStates()) {
                this.getState(STATE, STATE2, true);
            }
        }
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getFirstOperand() {
        return this.mFstOperand;
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getSecondOperand() {
        return this.mSndOperand;
    }

    @Override
    public INestedWordAutomaton<LETTER, STATE> getResult() {
        return this.mResult;
    }

    private class StatePair2StateMap {
        private final Map<STATE, Map<STATE, STATE>> mBackingMap = new HashMap();

        private StatePair2StateMap() {
        }

        protected STATE get(STATE STATE, STATE STATE2) {
            Map map = this.mBackingMap.get(STATE);
            if (map == null) {
                return null;
            }
            return map.get(STATE2);
        }

        protected void put(STATE STATE, STATE STATE2, STATE STATE3) {
            Map map = this.mBackingMap.get(STATE);
            if (map == null) {
                map = new HashMap();
                this.mBackingMap.put(STATE, map);
            }
            map.put(STATE2, STATE3);
        }
    }

    private class StatePairQueue {
        private final Map<STATE, Set<STATE>> mQueue = new HashMap();
        private STATE mDequeuedPairFst;
        private STATE mDequeuedPairSnd;

        private StatePairQueue() {
        }

        protected void enqueue(STATE STATE, STATE STATE2) {
            Set set = this.mQueue.get(STATE);
            if (set == null) {
                set = new HashSet();
                this.mQueue.put(STATE, set);
            }
            set.add(STATE2);
        }

        protected void dequeuePair() {
            assert (this.mDequeuedPairFst == null && this.mDequeuedPairSnd == null) : "Results from last dequeue not yet collected!";
            Iterator iterator = this.mQueue.keySet().iterator();
            this.mDequeuedPairFst = iterator.next();
            assert (this.mQueue.get(this.mDequeuedPairFst) != null);
            Set set = this.mQueue.get(this.mDequeuedPairFst);
            assert (set != null);
            Iterator iterator2 = set.iterator();
            this.mDequeuedPairSnd = iterator2.next();
            set.remove(this.mDequeuedPairSnd);
            if (set.isEmpty()) {
                this.mQueue.remove(this.mDequeuedPairFst);
            }
        }

        protected STATE getDequeuedPairFst() {
            assert (this.mDequeuedPairFst != null) : "No pair dequeued";
            Object STATE = this.mDequeuedPairFst;
            this.mDequeuedPairFst = null;
            return STATE;
        }

        public STATE getDequeuedPairSnd() {
            assert (this.mDequeuedPairSnd != null) : "No pair dequeued";
            Object STATE = this.mDequeuedPairSnd;
            this.mDequeuedPairSnd = null;
            return STATE;
        }

        public boolean isEmpty() {
            return this.mQueue.isEmpty();
        }
    }
}

