/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtsolver.external;

import com.github.jhoenicke.javacup.runtime.SimpleSymbolFactory;
import com.github.jhoenicke.javacup.runtime.Symbol;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.lib.util.MonitoredProcess;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.logic.Assignments;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.Lexer;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.ModelDescription;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.Parser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.output.TeeOutputStream;

public class Executor {
    private MonitoredProcess mProcess;
    private Lexer mLexer;
    private BufferedWriter mWriter;
    private InputStream mStdErr;
    private final Script mScript;
    private final Parser mParser;
    private final String mSolverCmd;
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final String mName;
    private final String mFullPathOfDumpedFile;
    private final String mSetupCommand;
    private final String mExitCommand;
    private final long mTimeout;
    private static final String EOF_ERROR_MSG = "Received EOF on stdin.";

    Executor(String string, Script script, ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, String string2, String string3) throws IOException {
        this(string, script, iLogger, iUltimateServiceProvider, string2, string3, "(set-option :print-success true)", "(exit)", -1L);
    }

    public Executor(String string, Script script, ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, String string2, String string3, String string4, String string5, long l) throws IOException {
        this.mServices = iUltimateServiceProvider;
        this.mSolverCmd = string;
        this.mScript = script;
        this.mLogger = iLogger;
        this.mName = string2;
        this.mFullPathOfDumpedFile = string3;
        this.mSetupCommand = string4;
        this.mExitCommand = string5;
        this.mTimeout = l;
        this.mParser = new Parser();
        this.mParser.setScript(this.mScript);
        this.createProcess();
    }

    private void createProcess() throws IOException {
        OutputStream outputStream;
        this.mProcess = MonitoredProcess.exec((String)this.mSolverCmd, (String)this.mExitCommand, (IUltimateServiceProvider)this.mServices);
        if (this.mProcess == null) {
            String string = this.getLogStringPrefix() + " Could not create process, terminating... ";
            this.mLogger.fatal((Object)string);
            throw new IllegalStateException(string);
        }
        OutputStream outputStream2 = this.mProcess.getOutputStream();
        InputStream inputStream = this.mProcess.getInputStream();
        if (this.mTimeout > 0L) {
            this.mProcess.setCountdownToTermination(this.mTimeout);
        } else {
            this.mProcess.setTerminationAfterTimeout(1000L);
        }
        this.mStdErr = this.mProcess.getErrorStream();
        SimpleSymbolFactory simpleSymbolFactory = new SimpleSymbolFactory();
        this.mLexer = new Lexer(new InputStreamReader(inputStream));
        this.mLexer.setSymbolFactory(simpleSymbolFactory);
        if (this.mFullPathOfDumpedFile != null) {
            File file = new File(this.mFullPathOfDumpedFile);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            outputStream = new TeeOutputStream(outputStream2, (OutputStream)fileOutputStream);
        } else {
            outputStream = outputStream2;
        }
        this.mWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        if (this.mSetupCommand != null) {
            this.input(this.mSetupCommand);
            this.parseSuccess();
        }
    }

    public void input(String string) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)(this.getLogStringPrefix() + " " + string));
        }
        try {
            this.mWriter.write(string + System.lineSeparator() + System.lineSeparator());
            this.mWriter.flush();
        }
        catch (IOException iOException) {
            throw this.convertIOException(iOException);
        }
    }

    public void exit() {
        if (this.mProcess != null && this.mProcess.isRunning()) {
            this.input("(exit)");
            this.mProcess.forceShutdown();
        }
        this.mProcess = null;
    }

    public static List<Symbol> parseSexpr(Lexer lexer) throws IOException {
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        int n = 0;
        do {
            Symbol symbol = lexer.next_token();
            if (symbol.sym == 101) {
                ++n;
            } else if (symbol.sym == 102) {
                --n;
            } else if (symbol.sym == 1) break;
            arrayList.add(symbol);
        } while (n > 0);
        return arrayList;
    }

    private List<Symbol> readAnswer() {
        try {
            List<Symbol> list = Executor.parseSexpr(this.mLexer);
            if (this.mLogger.isDebugEnabled()) {
                for (Symbol symbol : list) {
                    this.mLogger.debug((Object)symbol.toString());
                }
            }
            return list;
        }
        catch (IOException iOException) {
            throw this.convertIOException(iOException);
        }
    }

    public void reset() throws IOException {
        try {
            this.mWriter.write("(exit)\n");
            this.mWriter.flush();
        }
        catch (IOException iOException) {}
        this.mProcess.forceShutdown();
        this.createProcess();
    }

    public Symbol parse(int n) {
        List<Symbol> list = this.readAnswer();
        String string = "";
        try {
            if (this.mStdErr.available() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                while (this.mStdErr.available() > 0) {
                    int n2 = this.mStdErr.read();
                    char c = (char)n2;
                    stringBuilder.append(c);
                }
                string = stringBuilder.toString();
                this.mLogger.warn((Object)(this.getLogStringPrefix() + " " + Executor.generateStderrMessage(string)));
            }
        }
        catch (IOException iOException) {}
        list.add(0, new Symbol(n));
        this.mParser.setAnswer(list);
        try {
            return this.mParser.parse();
        }
        catch (SMTLIBException sMTLIBException) {
            if (this.mServices.getProgressMonitorService().continueProcessing()) {
                if (sMTLIBException.getMessage().equals("EOF")) {
                    throw new SMTLIBException(String.format("%s %s %s", this.getLogStringPrefix(), EOF_ERROR_MSG, Executor.generateStderrMessage(string)), (Throwable)sMTLIBException);
                }
                throw sMTLIBException;
            }
            throw new ToolchainCanceledException(this.getClass());
        }
        catch (IOException iOException) {
            throw this.convertIOException(iOException);
        }
        catch (Exception exception) {
            throw new SMTLIBException(String.format("%s %s %s", this.getLogStringPrefix(), "Unexpected Exception while parsing", Executor.generateStderrMessage(string)), (Throwable)exception);
        }
    }

    public void parseSuccess() {
        this.parse(38);
    }

    public Script.LBool parseCheckSatResult() {
        return (Script.LBool)this.parse((int)6).value;
    }

    public Term[] parseGetAssertionsResult() {
        return (Term[])this.parse((int)17).value;
    }

    public Term[] parseGetUnsatCoreResult() {
        return (Term[])this.parse((int)24).value;
    }

    public Map<Term, Term> parseGetValueResult() {
        return (Map)this.parse((int)25).value;
    }

    public Assignments parseGetAssignmentResult() {
        return (Assignments)this.parse((int)18).value;
    }

    public Object[] parseGetInfoResult() {
        return (Object[])this.parse((int)19).value;
    }

    public ModelDescription parseGetModelResult() {
        return (ModelDescription)this.parse((int)21).value;
    }

    public Object parseGetOptionResult() {
        return this.parse((int)22).value;
    }

    public Term[] parseInterpolants() {
        return (Term[])this.parse((int)20).value;
    }

    public Term parseTerm() {
        return (Term)this.parse((int)57).value;
    }

    private String getLogStringPrefix() {
        if (this.mProcess != null) {
            return String.format("%s (%s)", this.mName, this.mProcess);
        }
        return String.format("%s (dormant, command %s)", this.mName, this.mSolverCmd);
    }

    private static String generateStderrMessage(String string) {
        if (string.isEmpty()) {
            return "No stderr output.";
        }
        return "stderr output: " + string;
    }

    private RuntimeException convertIOException(IOException iOException) {
        if (this.mServices.getProgressMonitorService().continueProcessing()) {
            return new SMTLIBException(this.getLogStringPrefix() + " Connection to SMT solver broken", (Throwable)iOException);
        }
        return new ToolchainCanceledException(this.getClass());
    }
}

