/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.ProductNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.IOpWithDelayedDeadEndRemoval;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.AbstractRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class HoareAnnotationFragments<LETTER extends IAction> {
    private final Map<IPredicate, IPredicate> mPred2ProgPoint = new HashMap<IPredicate, IPredicate>();
    private final Map<IPredicate, HashRelation<IPredicate, IPredicate>> mDeadContexts2ProgPoint2Preds = new HashMap<IPredicate, HashRelation<IPredicate, IPredicate>>();
    private Map<IPredicate, HashRelation<IPredicate, IPredicate>> mLiveContexts2ProgPoint2Preds = new HashMap<IPredicate, HashRelation<IPredicate, IPredicate>>();
    private final HashMap<IPredicate, IPredicate> mContext2Entry = new HashMap();
    private final HashRelation<IPredicate, IPredicate> mProgPoint2StatesWithEmptyContext = new HashRelation();
    private final Set<IPredicate> mHoareAnnotationStates;

    Map<IPredicate, HashRelation<IPredicate, IPredicate>> getDeadContexts2ProgPoint2Preds() {
        return this.mDeadContexts2ProgPoint2Preds;
    }

    Map<IPredicate, HashRelation<IPredicate, IPredicate>> getLiveContexts2ProgPoint2Preds() {
        return this.mLiveContexts2ProgPoint2Preds;
    }

    HashRelation<IPredicate, IPredicate> getProgPoint2StatesWithEmptyContext() {
        return this.mProgPoint2StatesWithEmptyContext;
    }

    HashMap<IPredicate, IPredicate> getCallpred2Entry() {
        return this.mContext2Entry;
    }

    public HoareAnnotationFragments(Set<IPredicate> set) {
        this.mHoareAnnotationStates = Objects.requireNonNull(set);
    }

    public void updateOnIntersection(Map<IPredicate, Map<IPredicate, ProductNwa.ProductState>> map, INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> iNwaOutgoingLetterAndTransitionProvider) {
        IntersectionUpdate intersectionUpdate = new IntersectionUpdate(map);
        this.update(intersectionUpdate, iNwaOutgoingLetterAndTransitionProvider);
    }

    public void updateOnMinimization(Map<IPredicate, IPredicate> map, INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> iNwaOutgoingLetterAndTransitionProvider) {
        MinimizationUpdate minimizationUpdate = new MinimizationUpdate(map);
        this.update(minimizationUpdate, iNwaOutgoingLetterAndTransitionProvider);
    }

    private void update(IUpdate iUpdate, INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> iNwaOutgoingLetterAndTransitionProvider) {
        IPredicate iPredicate;
        IPredicate iPredicate22;
        Set<IPredicate> set = this.mPred2ProgPoint.isEmpty() ? this.mHoareAnnotationStates : new HashSet<IPredicate>(this.mPred2ProgPoint.keySet());
        for (IPredicate iPredicate22 : set) {
            IPredicate iPredicate3 = this.getProgramPoint(iPredicate22);
            iPredicate = iUpdate.getNewPredicates(iPredicate22);
            if (iPredicate == null) continue;
            for (Object object : iPredicate) {
                if (this.mPred2ProgPoint.containsKey(object)) {
                    IPredicate iPredicate4 = this.mPred2ProgPoint.get(object);
                    assert (iPredicate4 == iPredicate3) : "State " + String.valueOf(object) + " cannot represent both " + String.valueOf(iPredicate4) + " and " + String.valueOf(iPredicate3) + "!";
                    continue;
                }
                this.mPred2ProgPoint.put((IPredicate)object, iPredicate3);
            }
            this.mPred2ProgPoint.remove(iPredicate22);
        }
        iPredicate22 = this.mLiveContexts2ProgPoint2Preds;
        this.mLiveContexts2ProgPoint2Preds = new HashMap<IPredicate, HashRelation<IPredicate, IPredicate>>();
        for (Map.Entry entry : iPredicate22.entrySet()) {
            Object object;
            iPredicate = (IPredicate)entry.getKey();
            object = iUpdate.getNewPredicates(iPredicate);
            if (object == null) {
                assert (!this.mDeadContexts2ProgPoint2Preds.containsKey(iPredicate));
                this.mDeadContexts2ProgPoint2Preds.put(iPredicate, (HashRelation<IPredicate, IPredicate>)((HashRelation)entry.getValue()));
                continue;
            }
            IPredicate iPredicate5 = this.mContext2Entry.get(iPredicate);
            this.mContext2Entry.remove(iPredicate);
            int n = 0;
            while (n < object.size()) {
                HashRelation hashRelation;
                if (n == object.size() - 1) {
                    hashRelation = (HashRelation)entry.getValue();
                } else {
                    hashRelation = new HashRelation();
                    hashRelation.addAll((AbstractRelation)entry.getValue());
                }
                this.mLiveContexts2ProgPoint2Preds.put((IPredicate)object.get(n), (HashRelation<IPredicate, IPredicate>)hashRelation);
                IPredicate iPredicate6 = this.getEntry(iNwaOutgoingLetterAndTransitionProvider, (IPredicate)object.get(n));
                if (iPredicate6 == null) {
                    this.mContext2Entry.put((IPredicate)object.get(n), iPredicate5);
                } else {
                    this.mContext2Entry.put((IPredicate)object.get(n), iPredicate6);
                }
                ++n;
            }
        }
    }

    private IPredicate getEntry(INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> iNwaOutgoingLetterAndTransitionProvider, IPredicate iPredicate) {
        Iterator iterator = iNwaOutgoingLetterAndTransitionProvider.callSuccessors((Object)iPredicate).iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        OutgoingCallTransition outgoingCallTransition = (OutgoingCallTransition)iterator.next();
        IPredicate iPredicate2 = (IPredicate)outgoingCallTransition.getSucc();
        if (iterator.hasNext()) {
            throw new UnsupportedOperationException("Unable to compute Hoare annotation if state has several outgoging calls");
        }
        return iPredicate2;
    }

    void addDoubleDecker(IPredicate iPredicate, IPredicate iPredicate2, IPredicate iPredicate3) {
        IPredicate iPredicate4 = this.getProgramPoint(iPredicate2);
        if (!this.mHoareAnnotationStates.contains(iPredicate4)) {
            return;
        }
        if (iPredicate == iPredicate3) {
            this.mProgPoint2StatesWithEmptyContext.addPair((Object)iPredicate4, (Object)iPredicate2);
        } else {
            HashRelation hashRelation = this.mLiveContexts2ProgPoint2Preds.get(iPredicate);
            if (hashRelation == null) {
                hashRelation = new HashRelation();
                this.mLiveContexts2ProgPoint2Preds.put(iPredicate, (HashRelation<IPredicate, IPredicate>)hashRelation);
            }
            hashRelation.addPair((Object)iPredicate4, (Object)iPredicate2);
        }
    }

    private IPredicate getProgramPoint(IPredicate iPredicate) {
        IPredicate iPredicate2 = this.mPred2ProgPoint.get(iPredicate);
        if (iPredicate2 == null) {
            return iPredicate;
        }
        return iPredicate2;
    }

    void addContextEntryPair(IPredicate iPredicate, IPredicate iPredicate2) {
        this.mContext2Entry.put(iPredicate, iPredicate2);
    }

    public void addDeadEndDoubleDeckers(IOpWithDelayedDeadEndRemoval<LETTER, IPredicate> iOpWithDelayedDeadEndRemoval) {
        IPredicate iPredicate = (IPredicate)iOpWithDelayedDeadEndRemoval.getResult().getEmptyStackState();
        for (IOpWithDelayedDeadEndRemoval.UpDownEntry upDownEntry : iOpWithDelayedDeadEndRemoval.getRemovedUpDownEntry()) {
            this.addDoubleDecker((IPredicate)upDownEntry.getDown(), (IPredicate)upDownEntry.getUp(), iPredicate);
            if (upDownEntry.getEntry() != null) {
                this.addContextEntryPair((IPredicate)upDownEntry.getDown(), (IPredicate)upDownEntry.getEntry());
                continue;
            }
            assert (upDownEntry.getDown() == iPredicate);
        }
    }

    @FunctionalInterface
    static interface IUpdate {
        public List<IPredicate> getNewPredicates(IPredicate var1);
    }

    private class IntersectionUpdate
    implements IUpdate {
        private final Map<IPredicate, Map<IPredicate, ProductNwa.ProductState>> mFst2snd2res;

        public IntersectionUpdate(Map<IPredicate, Map<IPredicate, ProductNwa.ProductState>> map) {
            this.mFst2snd2res = map;
        }

        @Override
        public List<IPredicate> getNewPredicates(IPredicate iPredicate) {
            Map<IPredicate, ProductNwa.ProductState> map = this.mFst2snd2res.get(iPredicate);
            if (map == null) {
                return null;
            }
            ArrayList<IPredicate> arrayList = new ArrayList<IPredicate>();
            for (Map.Entry<IPredicate, ProductNwa.ProductState> entry : map.entrySet()) {
                arrayList.add((IPredicate)entry.getValue().getRes());
            }
            return arrayList;
        }
    }

    private static class MinimizationUpdate
    implements IUpdate {
        private final Map<IPredicate, IPredicate> mOld2New;

        public MinimizationUpdate(Map<IPredicate, IPredicate> map) {
            this.mOld2New = map;
        }

        @Override
        public List<IPredicate> getNewPredicates(IPredicate iPredicate) {
            IPredicate iPredicate2 = this.mOld2New.get(iPredicate);
            if (iPredicate2 == null) {
                return null;
            }
            List<IPredicate> list = Collections.singletonList(iPredicate2);
            return list;
        }
    }
}

