/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLType;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import java.util.List;
import java.util.function.Predicate;

public final class Parameter
extends ACSLNode {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(Parameter.class);
    ACSLType parameterType;
    String parameterIdentifier;

    public Parameter(ACSLType aCSLType, String string) {
        this.parameterType = aCSLType;
        this.parameterIdentifier = string;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Parameter: " + String.valueOf(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Parameter").append('[');
        stringBuffer.append(this.parameterType);
        stringBuffer.append(',').append(this.parameterIdentifier);
        return stringBuffer.append(']').toString();
    }

    public ACSLType getParameterType() {
        return this.parameterType;
    }

    public String getParameterIdentifier() {
        return this.parameterIdentifier;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.parameterType);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (aCSLVisitor.visit(this) && this.parameterType != null) {
            this.parameterType.accept(aCSLVisitor);
        }
    }

    @Override
    public Parameter accept(ACSLTransformer aCSLTransformer) {
        Parameter parameter = aCSLTransformer.transform(this);
        if (parameter != this) {
            return parameter;
        }
        ACSLType aCSLType = null;
        if (this.parameterType != null) {
            aCSLType = this.parameterType.accept(aCSLTransformer);
        }
        if (this.parameterType != aCSLType) {
            return new Parameter(aCSLType, this.parameterIdentifier);
        }
        return this;
    }
}

