/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lassoranker.AnalysisType;
import de.uni_freiburg.informatik.ultimate.lassoranker.ArgumentSynthesizer;
import de.uni_freiburg.informatik.ultimate.lassoranker.ILassoRankerPreferences;
import de.uni_freiburg.informatik.ultimate.lassoranker.Lasso;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearTransition;
import de.uni_freiburg.informatik.ultimate.lassoranker.ModelExtractionUtils;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.ITerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.MotzkinTransformation;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.StemOverapproximator;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.SupportingInvariant;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.SupportingInvariantGenerator;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.SupportingInvariantSimplifier;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.RankingTemplate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TerminationArgumentSynthesizer
extends ArgumentSynthesizer {
    private TerminationAnalysisSettings mSettings;
    private final RankingTemplate mTemplate;
    private final Collection<SupportingInvariantGenerator> msi_generators;
    private int mnum_motzkin = 0;
    private RankingFunction mranking_function = null;
    private Collection<SupportingInvariant> mSupportingInvariants = null;
    private final Set<Term> mArrayIndexSupportingInvariants;

    public TerminationArgumentSynthesizer(Lasso lasso, RankingTemplate rankingTemplate, ILassoRankerPreferences iLassoRankerPreferences, TerminationAnalysisSettings terminationAnalysisSettings, Set<Term> set, IUltimateServiceProvider iUltimateServiceProvider) throws IOException {
        super(lasso, iLassoRankerPreferences, rankingTemplate.getName() + "Template", iUltimateServiceProvider);
        this.mSettings = terminationAnalysisSettings;
        this.mLogger.info((Object)("Termination Analysis Settings: " + terminationAnalysisSettings.toString()));
        assert (!this.mSettings.getAnalysis().isDisabled());
        if (this.mSettings.getNumStrictInvariants() == 0 && this.mSettings.getNumNonStrictInvariants() == 0) {
            this.mLogger.info((Object)"Generation of supporting invariants is disabled.");
        }
        if (this.mSettings.getAnalysis().isLinear()) {
            this.mScript.setLogic(Logics.QF_LRA);
        } else {
            this.mScript.setLogic(Logics.QF_NRA);
        }
        if (this.mSettings.getAnalysis() == AnalysisType.LINEAR && !terminationAnalysisSettings.isNonDecreasingInvariants()) {
            this.mLogger.warn((Object)"Termination analysis type is 'Linear', hence invariants must be non-decreasing!");
        }
        this.mTemplate = rankingTemplate;
        this.msi_generators = new ArrayList<SupportingInvariantGenerator>();
        this.mSupportingInvariants = new ArrayList<SupportingInvariant>();
        this.mArrayIndexSupportingInvariants = set;
    }

    @Override
    protected Script constructScript(ILassoRankerPreferences iLassoRankerPreferences, String string) {
        SolverBuilder.SolverMode solverMode = iLassoRankerPreferences.isAnnotateTerms() ? SolverBuilder.SolverMode.External_ModelsAndUnsatCoreMode : SolverBuilder.SolverMode.External_ModelsMode;
        SolverBuilder.SolverSettings solverSettings = iLassoRankerPreferences.getSolverConstructionSettings(solverMode, iLassoRankerPreferences.getBaseNameOfDumpedScript() + "+" + string);
        return SolverBuilder.buildAndInitializeSolver((IUltimateServiceProvider)this.mServices, (SolverBuilder.SolverSettings)solverSettings, (String)"TerminationArgumentSynthesis solver ");
    }

    public Collection<IProgramVar> getSIVars() {
        LinkedHashSet<IProgramVar> linkedHashSet = new LinkedHashSet<IProgramVar>(this.mLasso.getStem().getOutVars().keySet());
        linkedHashSet.retainAll(this.mLasso.getLoop().getInVars().keySet());
        return linkedHashSet;
    }

    public Collection<IProgramVar> getRankVars() {
        LinkedHashSet<IProgramVar> linkedHashSet = new LinkedHashSet<IProgramVar>(this.mLasso.getLoop().getOutVars().keySet());
        linkedHashSet.retainAll(this.mLasso.getLoop().getInVars().keySet());
        return linkedHashSet;
    }

    /*
     * WARNING - void declaration
     */
    private Collection<Term> buildConstraints(LinearTransition linearTransition, LinearTransition linearTransition2, RankingTemplate rankingTemplate, Collection<SupportingInvariantGenerator> collection) {
        LinearInequality linearInequality;
        Object object;
        ArrayList<Term> arrayList = new ArrayList<Term>();
        Collection<IProgramVar> collection2 = this.getSIVars();
        List<List<LinearInequality>> list = rankingTemplate.getConstraints(linearTransition2.getInVars(), linearTransition2.getOutVars());
        List<String> list2 = rankingTemplate.getAnnotations();
        assert (list2.size() == list.size());
        this.mLogger.info((Object)(linearTransition.getNumPolyhedra() + " stem disjuncts"));
        this.mLogger.info((Object)(linearTransition2.getNumPolyhedra() + " loop disjuncts"));
        this.mLogger.info((Object)(list.size() + " template conjuncts."));
        Rational[] rationalArray = new HashSet();
        for (List<LinearInequality> list3 : list) {
            for (LinearInequality linearInequality2 : list3) {
                if (rationalArray.contains(linearInequality2)) continue;
                linearInequality2.negate();
                rationalArray.add(linearInequality2);
            }
        }
        if (this.mSettings.getAnalysis().wantsGuesses()) {
            rationalArray = this.mLasso.guessEigenvalues(false);
            assert (rationalArray.length >= 2);
        } else {
            rationalArray = new Rational[]{};
        }
        int n = 0;
        for (List<LinearInequality> list4 : linearTransition2.getPolyhedra()) {
            ++n;
            int n2 = 0;
            while (n2 < list.size()) {
                List<LinearInequality> list5 = new MotzkinTransformation(this.mServices, this.mScript, this.mSettings.getAnalysis(), this.mPreferences.isAnnotateTerms());
                ((MotzkinTransformation)((Object)list5)).mAnnotation = list2.get(n2) + " " + n;
                ((MotzkinTransformation)((Object)list5)).addInequalities(list4);
                ((MotzkinTransformation)((Object)list5)).addInequalities((Collection<LinearInequality>)list.get(n2));
                assert (this.mSettings.getNumStrictInvariants() >= 0);
                int n3 = 0;
                while (n3 < this.mSettings.getNumStrictInvariants()) {
                    object = new SupportingInvariantGenerator(this.mScript, collection2, true);
                    collection.add((SupportingInvariantGenerator)object);
                    ((MotzkinTransformation)((Object)list5)).addInequality(((SupportingInvariantGenerator)object).generate(linearTransition2.getInVars()));
                    ++n3;
                }
                assert (this.mSettings.getNumNonStrictInvariants() >= 0);
                n3 = 0;
                while (n3 < this.mSettings.getNumNonStrictInvariants()) {
                    object = new SupportingInvariantGenerator(this.mScript, collection2, false);
                    collection.add((SupportingInvariantGenerator)object);
                    linearInequality = ((SupportingInvariantGenerator)object).generate(linearTransition2.getInVars());
                    linearInequality.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ONE;
                    ((MotzkinTransformation)((Object)list5)).addInequality(linearInequality);
                    ++n3;
                }
                this.mLogger.debug(list5);
                arrayList.add(((MotzkinTransformation)((Object)list5)).transform(rationalArray));
                ++n2;
            }
        }
        this.mLogger.debug((Object)("Adding the constraints for " + collection.size() + " supporting invariants."));
        boolean bl = false;
        for (SupportingInvariantGenerator supportingInvariantGenerator : collection) {
            void var11_14;
            ++var11_14;
            n = 0;
            for (List<LinearInequality> list5 : linearTransition.getPolyhedra()) {
                object = new MotzkinTransformation(this.mServices, this.mScript, this.mSettings.getAnalysis(), this.mPreferences.isAnnotateTerms());
                ((MotzkinTransformation)object).mAnnotation = "invariant " + (int)var11_14 + " initiation " + ++n;
                ((MotzkinTransformation)object).addInequalities(list5);
                linearInequality = supportingInvariantGenerator.generate(linearTransition.getOutVars());
                linearInequality.negate();
                linearInequality.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ONE;
                ((MotzkinTransformation)object).addInequality(linearInequality);
                arrayList.add(((MotzkinTransformation)object).transform(rationalArray));
            }
            n = 0;
            for (List<LinearInequality> list5 : linearTransition2.getPolyhedra()) {
                object = new MotzkinTransformation(this.mServices, this.mScript, this.mSettings.getAnalysis(), this.mPreferences.isAnnotateTerms());
                ((MotzkinTransformation)object).mAnnotation = "invariant " + (int)var11_14 + " consecution " + ++n;
                ((MotzkinTransformation)object).addInequalities(list5);
                ((MotzkinTransformation)object).addInequality(supportingInvariantGenerator.generate(linearTransition2.getInVars()));
                linearInequality = supportingInvariantGenerator.generate(linearTransition2.getOutVars());
                linearInequality.mMotzkinCoefficient = this.mSettings.isNonDecreasingInvariants() || this.mSettings.getAnalysis() == AnalysisType.LINEAR ? LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE : LinearInequality.PossibleMotzkinCoefficients.ANYTHING;
                linearInequality.negate();
                ((MotzkinTransformation)object).addInequality(linearInequality);
                arrayList.add(((MotzkinTransformation)object).transform(rationalArray));
            }
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Script.LBool doSynthesis() throws SMTLIBException, TermException, IOException {
        Object object;
        this.mTemplate.init(this);
        if (this.mSettings.getAnalysis().isLinear() && this.mTemplate.getDegree() > 0) {
            this.mLogger.warn((Object)"Using a linear SMT query and a templates of degree > 0, hence this method is incomplete.");
        }
        Collection<IProgramVar> collection = this.getRankVars();
        Collection<IProgramVar> collection2 = this.getSIVars();
        this.mLogger.info((Object)("Template has degree " + this.mTemplate.getDegree() + "."));
        this.mLogger.debug((Object)("Variables for ranking functions: " + String.valueOf(collection)));
        this.mLogger.debug((Object)("Variables for supporting invariants: " + String.valueOf(collection2)));
        LinearTransition linearTransition = this.mLasso.getStem();
        LinearTransition linearTransition2 = this.mLasso.getLoop();
        if (this.mLasso.getStem().isTrue()) {
            this.mLogger.info((Object)"There is no stem transition; disabling supporting invariant generation.");
            this.mSettings = new TerminationAnalysisSettings(new ITerminationAnalysisSettings(){

                @Override
                public AnalysisType getAnalysis() {
                    return TerminationArgumentSynthesizer.this.mSettings.getAnalysis();
                }

                @Override
                public int getNumStrictInvariants() {
                    return 0;
                }

                @Override
                public int getNumNonStrictInvariants() {
                    return 0;
                }

                @Override
                public boolean isNonDecreasingInvariants() {
                    return TerminationArgumentSynthesizer.this.mSettings.isNonDecreasingInvariants();
                }

                @Override
                public boolean isSimplifyTerminationArgument() {
                    return TerminationArgumentSynthesizer.this.mSettings.isSimplifyTerminationArgument();
                }

                @Override
                public boolean isSimplifySupportingInvariants() {
                    return TerminationArgumentSynthesizer.this.mSettings.isSimplifySupportingInvariants();
                }

                @Override
                public boolean isOverapproximateStem() {
                    return TerminationArgumentSynthesizer.this.mSettings.isOverapproximateStem();
                }
            });
        } else if (this.mSettings.isOverapproximateStem()) {
            this.mLogger.info((Object)"Overapproximating stem...");
            int n = linearTransition.getNumInequalities();
            Throwable throwable3 = null;
            object = null;
            try (StemOverapproximator stemOverapproximator = new StemOverapproximator(this.mPreferences, this.mServices);){
                linearTransition = stemOverapproximator.overapproximate(linearTransition);
            }
            catch (Throwable throwable) {
                void var6_10;
                if (throwable3 == null) {
                    Throwable throwable2 = throwable;
                } else if (throwable3 != throwable) {
                    throwable3.addSuppressed(throwable);
                }
                throw var6_10;
            }
            this.mLogger.info((Object)("Reduced " + n + " stem atoms to " + linearTransition.getNumInequalities() + "."));
        }
        Collection<Term> collection3 = this.buildConstraints(linearTransition, linearTransition2, this.mTemplate, this.msi_generators);
        this.mnum_motzkin = collection3.size();
        this.mLogger.info((Object)("We have " + this.getNumMotzkin() + " Motzkin's Theorem applications."));
        this.mLogger.info((Object)("A total of " + this.getNumSIs() + " supporting invariants were added."));
        for (Term term : collection3) {
            this.mScript.assertTerm(term);
        }
        Script.LBool lBool = this.mScript.checkSat();
        if (lBool == Script.LBool.SAT) {
            void var8_21;
            object = new ArrayList<Term>(this.mTemplate.getCoefficients());
            for (SupportingInvariantGenerator supportingInvariantGenerator : this.msi_generators) {
                ((ArrayList)object).addAll(supportingInvariantGenerator.getCoefficients());
            }
            if (this.mSettings.isSimplifyTerminationArgument()) {
                this.mLogger.info((Object)"Found a termination argument, trying to simplify.");
                Map<Term, Rational> map = ModelExtractionUtils.getSimplifiedAssignment_TwoMode(this.mScript, (Collection<Term>)object, this.mLogger, this.mServices);
            } else {
                Map<Term, Rational> map = ModelExtractionUtils.getValuation(this.mScript, (Collection<Term>)object);
            }
            this.mranking_function = this.mTemplate.extractRankingFunction((Map<Term, Rational>)var8_21);
            for (SupportingInvariantGenerator supportingInvariantGenerator : this.msi_generators) {
                this.mSupportingInvariants.add(supportingInvariantGenerator.extractSupportingInvariant((Map<Term, Rational>)var8_21));
            }
            if (this.mSettings.isSimplifySupportingInvariants()) {
                int n = this.mSupportingInvariants.size();
                Object object2 = null;
                Object var11_28 = null;
                try (SupportingInvariantSimplifier supportingInvariantSimplifier = new SupportingInvariantSimplifier(this.mPreferences, this.mServices);){
                    this.mLogger.info((Object)"Simplifying supporting invariants...");
                    this.mSupportingInvariants = supportingInvariantSimplifier.simplify(this.mSupportingInvariants);
                }
                catch (Throwable throwable) {
                    if (object2 == null) {
                        object2 = throwable;
                    } else if (object2 != throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                    throw object2;
                }
                this.mLogger.info("Removed %d redundant supporting invariants from a total of %d.", new Object[]{n - this.mSupportingInvariants.size(), n});
            }
        } else if (lBool == Script.LBool.UNKNOWN) {
            this.mScript.echo(new QuotedObject("Warning solver responded UNKNOWN to the check-sat above"));
        }
        return lBool;
    }

    public int getNumSIs() {
        assert (this.msi_generators != null);
        return this.msi_generators.size();
    }

    public int getNumMotzkin() {
        return this.mnum_motzkin;
    }

    public TerminationArgument getArgument() {
        assert (this.synthesisSuccessful());
        return new TerminationArgument(this.mranking_function, this.mSupportingInvariants, this.mArrayIndexSupportingInvariants);
    }
}

