/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.ComputeStoreInfosAndArrayGroups;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.HeapSeparatorBenchmark;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.HeapSeparatorStatistics;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.LocArrayInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.MemlocArrayManager;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayGroup;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.NoStoreInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.SelectInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.StoreInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.StoreLocationBlock;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IEqualityProvidingIntermediateState;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap3;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class HeapPartitionManager {
    private final NestedMap2<SelectInfo, Integer, StoreLocationBlock> mSelectInfoToDimensionToLocationBlock;
    private final NestedMap2<ArrayGroup, Integer, UnionFind<StoreInfo>> mArrayGroupToDimensionToStoreIndexInfoPartition;
    NestedMap2<SelectInfo, Integer, StoreInfo> mSelectInfoToDimensionToToSampleStoreIndexInfo;
    private boolean mIsFinished = false;
    private final List<IProgramVarOrConst> mHeapArrays;
    private final ILogger mLogger;
    private final NestedMap3<Set<StoreInfo>, ArrayGroup, Integer, StoreLocationBlock> mStoreIndexInfosToArrayGroupToDimensionToLocationBlock;
    private final HeapSeparatorBenchmark mStatistics;
    private final ManagedScript mMgdScript;
    private final MemlocArrayManager mMemLocArrayManager;
    private final ComputeStoreInfosAndArrayGroups<?> mCsiaag;

    public HeapPartitionManager(ILogger iLogger, ManagedScript managedScript, List<IProgramVarOrConst> list, HeapSeparatorBenchmark heapSeparatorBenchmark, MemlocArrayManager memlocArrayManager, ComputeStoreInfosAndArrayGroups<?> computeStoreInfosAndArrayGroups) {
        this.mMgdScript = managedScript;
        this.mLogger = iLogger;
        this.mHeapArrays = list;
        this.mStatistics = heapSeparatorBenchmark;
        this.mMemLocArrayManager = memlocArrayManager;
        this.mCsiaag = computeStoreInfosAndArrayGroups;
        this.mArrayGroupToDimensionToStoreIndexInfoPartition = new NestedMap2();
        this.mSelectInfoToDimensionToLocationBlock = new NestedMap2();
        this.mSelectInfoToDimensionToToSampleStoreIndexInfo = new NestedMap2();
        this.mStoreIndexInfosToArrayGroupToDimensionToLocationBlock = new NestedMap3();
    }

    void processSelect(SelectInfo selectInfo, IEqualityProvidingIntermediateState iEqualityProvidingIntermediateState) {
        if (iEqualityProvidingIntermediateState.isBottom()) {
            this.mLogger.warn((Object)("equality analysis on preprocessed graph computed array read to be unreachable: " + String.valueOf(selectInfo)));
        }
        ArrayIndex arrayIndex = selectInfo.getIndex();
        int n = 1;
        while (n <= arrayIndex.size()) {
            ArrayIndex arrayIndex2 = arrayIndex.getFirst(n);
            LocArrayInfo locArrayInfo = this.mMemLocArrayManager.getOrConstructLocArray(selectInfo.getEdgeInfo(), selectInfo.getArrayCellAccess().getArray(), n, true);
            this.mMgdScript.lock((Object)this);
            Term term2 = SmtUtils.multiDimensionalSelect((Script)this.mMgdScript.getScript(), (Term)locArrayInfo.getTerm(), (ArrayIndex)arrayIndex2);
            this.mMgdScript.unlock((Object)this);
            Set set = iEqualityProvidingIntermediateState.getSetConstraintForExpression(term2);
            if (set == null) {
                this.mLogger.warn((Object)("No literal set constraint found for loc-array access " + String.valueOf(term2) + " at " + String.valueOf(locArrayInfo.getEdge())));
                var9_9 = this.mCsiaag.getStoreInfosForDimensionAndArrayGroup(n, selectInfo.getArrayGroup());
                this.mergeBlocks(selectInfo, n, var9_9);
            } else {
                var9_9 = set.stream().map(term -> this.mCsiaag.getStoreInfoForLocLitTerm((Term)term)).collect(Collectors.toList());
                this.mergeBlocks(selectInfo, n, var9_9);
            }
            ++n;
        }
    }

    private void mergeBlocks(SelectInfo selectInfo, int n, List<StoreInfo> list) {
        assert (list != null && !list.isEmpty());
        ArrayGroup arrayGroup = selectInfo.getArrayGroup();
        this.createPartitionAndBlockIfNecessary(selectInfo, n, list.iterator().next());
        UnionFind unionFind = (UnionFind)this.mArrayGroupToDimensionToStoreIndexInfoPartition.get((Object)arrayGroup, (Object)n);
        if (unionFind == null) {
            throw new AssertionError((Object)"should have been created in createBlockIfNecessary");
        }
        unionFind.findAndConstructEquivalenceClassIfNeeded((Object)list.get(0));
        int n2 = 1;
        while (n2 < list.size()) {
            StoreInfo storeInfo = list.get(n2 - 1);
            StoreInfo storeInfo2 = list.get(n2);
            unionFind.findAndConstructEquivalenceClassIfNeeded((Object)storeInfo2);
            if (!(storeInfo instanceof NoStoreInfo) && !(storeInfo2 instanceof NoStoreInfo)) {
                unionFind.union((Object)storeInfo, (Object)storeInfo2);
            }
            ++n2;
        }
    }

    private void createPartitionAndBlockIfNecessary(SelectInfo selectInfo, int n, StoreInfo storeInfo) {
        ArrayGroup arrayGroup = selectInfo.getArrayGroup();
        assert (selectInfo.getArrayGroup().equals(storeInfo.getArrayGroup()) || storeInfo instanceof NoStoreInfo);
        UnionFind unionFind = (UnionFind)this.mArrayGroupToDimensionToStoreIndexInfoPartition.get((Object)arrayGroup, (Object)n);
        if (unionFind == null) {
            unionFind = new UnionFind();
            this.mArrayGroupToDimensionToStoreIndexInfoPartition.put((Object)arrayGroup, (Object)n, (Object)unionFind);
        }
        this.mSelectInfoToDimensionToToSampleStoreIndexInfo.put((Object)selectInfo, (Object)n, (Object)storeInfo);
        unionFind.findAndConstructEquivalenceClassIfNeeded((Object)storeInfo);
    }

    public void finish() {
        SelectInfo selectInfo;
        for (Triple object : this.mSelectInfoToDimensionToToSampleStoreIndexInfo.entrySet()) {
            StoreInfo storeInfo = (StoreInfo)object.getThird();
            selectInfo = (SelectInfo)object.getFirst();
            Integer n = (Integer)object.getSecond();
            ArrayGroup arrayGroup = selectInfo.getArrayGroup();
            Object object2 = (UnionFind)this.mArrayGroupToDimensionToStoreIndexInfoPartition.get((Object)arrayGroup, (Object)n);
            ImmutableSet immutableSet = object2.getEquivalenceClassMembers((Object)storeInfo);
            StoreLocationBlock storeLocationBlock = this.getOrConstructLocationBlock((Set<StoreInfo>)immutableSet, arrayGroup, n);
            this.mSelectInfoToDimensionToLocationBlock.put((Object)selectInfo, (Object)n, (Object)storeLocationBlock);
            this.mLogger.debug((Object)("adding LocationBlock " + String.valueOf(storeLocationBlock)));
            this.mLogger.debug((Object)("\t at dimension " + String.valueOf(n) + " for " + String.valueOf(selectInfo)));
            this.mLogger.debug((Object)("\t write locations: " + String.valueOf(storeLocationBlock.getLocations())));
        }
        this.mLogger.info((Object)"partitioning result:");
        for (ArrayGroup arrayGroup : this.mCsiaag.getArrayGroups()) {
            this.mStatistics.registerArrayGroup(arrayGroup);
            this.mLogger.info((Object)("\t location blocks for array group " + String.valueOf(arrayGroup)));
            int n = 1;
            while (n <= arrayGroup.getDimensionality()) {
                selectInfo = (UnionFind)this.mArrayGroupToDimensionToStoreIndexInfoPartition.get((Object)arrayGroup, (Object)n);
                int n2 = selectInfo == null ? 0 : selectInfo.getAllElements().size();
                int n3 = selectInfo == null ? 0 : selectInfo.getAllEquivalenceClasses().size();
                this.mLogger.info((Object)("\t at dimension " + n));
                this.mLogger.info((Object)("\t # array writes (possibly including 1 dummy write/NoStoreIndexInfo) : " + n2));
                this.mLogger.info((Object)("\t # location blocks :" + n3));
                this.mStatistics.registerPerArrayAndDimensionInfo(arrayGroup, n, HeapSeparatorStatistics.COUNT_ARRAY_WRITES, n2);
                this.mStatistics.registerPerArrayAndDimensionInfo(arrayGroup, n, HeapSeparatorStatistics.COUNT_BLOCKS, n3);
                this.mLogger.debug((Object)"\t location block contents:");
                if (this.mLogger.isDebugEnabled() && selectInfo != null) {
                    for (Object object2 : selectInfo.getAllEquivalenceClasses()) {
                        this.mLogger.debug((Object)("\t\t " + String.valueOf(object2)));
                    }
                }
                ++n;
            }
        }
        this.mIsFinished = true;
        assert (this.sanityCheck());
    }

    private StoreLocationBlock getOrConstructLocationBlock(Set<StoreInfo> set, ArrayGroup arrayGroup, Integer n) {
        StoreLocationBlock storeLocationBlock = (StoreLocationBlock)this.mStoreIndexInfosToArrayGroupToDimensionToLocationBlock.get(set, (Object)arrayGroup, (Object)n);
        if (storeLocationBlock == null) {
            storeLocationBlock = new StoreLocationBlock(set, arrayGroup, n);
            this.mStoreIndexInfosToArrayGroupToDimensionToLocationBlock.put(set, (Object)arrayGroup, (Object)n, (Object)storeLocationBlock);
            this.mLogger.debug((Object)("creating LocationBlock " + String.valueOf(storeLocationBlock)));
            this.mLogger.debug((Object)("\t with contents " + String.valueOf(storeLocationBlock.getLocations())));
        }
        return storeLocationBlock;
    }

    private boolean sanityCheck() {
        return true;
    }

    public NestedMap2<SelectInfo, Integer, StoreLocationBlock> getSelectInfoToDimensionToLocationBlock() {
        if (!this.mIsFinished) {
            throw new AssertionError();
        }
        return this.mSelectInfoToDimensionToLocationBlock;
    }

    public StoreLocationBlock getLocationBlock(SelectInfo selectInfo, Integer n) {
        if (!this.mIsFinished) {
            throw new AssertionError();
        }
        return (StoreLocationBlock)this.mSelectInfoToDimensionToLocationBlock.get((Object)selectInfo, (Object)n);
    }
}

