/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.GeneralMaxSatSolver;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.IAssignmentCheckerAndGenerator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.VariableStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;

public class InteractiveMaxSatSolver<T>
extends GeneralMaxSatSolver<T> {
    private final Iterable<IAssignmentCheckerAndGenerator<T>> mAssignmentCheckerAndGenerators;

    public InteractiveMaxSatSolver(AutomataLibraryServices automataLibraryServices, Iterable<IAssignmentCheckerAndGenerator<T>> iterable) {
        super(automataLibraryServices);
        this.mAssignmentCheckerAndGenerators = iterable;
    }

    @Override
    public void addVariable(T t) {
        for (IAssignmentCheckerAndGenerator<T> iAssignmentCheckerAndGenerator : this.mAssignmentCheckerAndGenerators) {
            iAssignmentCheckerAndGenerator.addVariable(t);
        }
        super.addVariable(t);
    }

    @Override
    protected void setVariable(T t, boolean bl) {
        super.setVariable(t, bl);
        for (IAssignmentCheckerAndGenerator<T> iAssignmentCheckerAndGenerator : this.mAssignmentCheckerAndGenerators) {
            Iterable<Pair<T, Boolean>> iterable = iAssignmentCheckerAndGenerator.checkAssignment(t, bl);
            if (!this.applyAssignmentsAndReturnTrueIfContradicting(iterable)) continue;
            this.mConjunctionEquivalentToFalse = true;
            return;
        }
    }

    private boolean applyAssignmentsAndReturnTrueIfContradicting(Iterable<Pair<T, Boolean>> iterable) {
        block4: for (Pair<T, Boolean> pair : iterable) {
            Object object = pair.getFirst();
            VariableStatus variableStatus = this.getCurrentVariableStatus(object);
            Boolean bl = (Boolean)pair.getSecond();
            switch (variableStatus) {
                case TRUE: 
                case FALSE: {
                    if (!InteractiveMaxSatSolver.isContradicting(variableStatus, bl)) continue block4;
                    return true;
                }
                case UNSET: {
                    super.setVariable(object, true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown variable status.");
                }
            }
        }
        return false;
    }

    private static boolean isContradicting(VariableStatus variableStatus, Boolean bl) {
        assert (variableStatus == VariableStatus.TRUE || variableStatus == VariableStatus.FALSE) : "Only TRUE or FALSE is allowed.";
        return variableStatus == VariableStatus.TRUE ^ bl;
    }

    @Override
    protected void makeAssignmentPersistent() {
        for (IAssignmentCheckerAndGenerator<T> iAssignmentCheckerAndGenerator : this.mAssignmentCheckerAndGenerators) {
            iAssignmentCheckerAndGenerator.makeAssignmentsPersistent();
        }
        super.makeAssignmentPersistent();
    }

    @Override
    protected void backtrack(T t) {
        for (IAssignmentCheckerAndGenerator<T> iAssignmentCheckerAndGenerator : this.mAssignmentCheckerAndGenerators) {
            iAssignmentCheckerAndGenerator.revertOneScope();
        }
        super.backtrack(t);
    }

    @Override
    protected void decideOne() {
        for (IAssignmentCheckerAndGenerator<T> iAssignmentCheckerAndGenerator : this.mAssignmentCheckerAndGenerators) {
            iAssignmentCheckerAndGenerator.addScope();
        }
        super.decideOne();
    }
}

