/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.ConcurrentProduct;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEquivalent;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.UnaryNetOperation;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.PetriNetUtils;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.PetriNet2FiniteAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IConcurrentProductStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IPetriNet2FiniteAutomatonStateFactory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public final class PrefixProduct<LETTER, PLACE, CRSF extends IPetriNet2FiniteAutomatonStateFactory<PLACE> & IConcurrentProductStateFactory<PLACE>>
extends UnaryNetOperation<LETTER, PLACE, CRSF> {
    private final BoundedPetriNet<LETTER, PLACE> mOperand;
    private final INestedWordAutomaton<LETTER, PLACE> mNwa;
    private final BoundedPetriNet<LETTER, PLACE> mResult;
    private final Map<LETTER, Collection<Transition<LETTER, PLACE>>> mSymbol2netTransitions = new HashMap<LETTER, Collection<Transition<LETTER, PLACE>>>();
    private final Map<LETTER, Collection<AutomatonTransition>> mSymbol2nwaTransitions = new HashMap<LETTER, Collection<AutomatonTransition>>();

    public PrefixProduct(AutomataLibraryServices automataLibraryServices, BoundedPetriNet<LETTER, PLACE> boundedPetriNet, INestedWordAutomaton<LETTER, PLACE> iNestedWordAutomaton) {
        super(automataLibraryServices);
        this.mOperand = boundedPetriNet;
        this.mNwa = iNestedWordAutomaton;
        if (iNestedWordAutomaton.getInitialStates().size() != 1) {
            throw new UnsupportedOperationException("PrefixProduct needs an automaton with exactly one inital state");
        }
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mResult = this.computeResult();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String startMessage() {
        return "Start " + this.getOperationName() + "First Operand " + this.mOperand.sizeInformation() + "Second Operand " + this.mNwa.sizeInformation();
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + " Result " + this.mResult.sizeInformation();
    }

    @Override
    protected IPetriNet<LETTER, PLACE> getOperand() {
        return this.mOperand;
    }

    @Override
    public BoundedPetriNet<LETTER, PLACE> getResult() {
        return this.mResult;
    }

    private void updateSymbol2netTransitions(LETTER LETTER, Transition<LETTER, PLACE> transition) {
        Collection collection = this.mSymbol2netTransitions.computeIfAbsent(LETTER, object -> new LinkedList());
        collection.add(transition);
    }

    private BoundedPetriNet<LETTER, PLACE> computeResult() {
        HashSet<LETTER> hashSet = new HashSet<LETTER>(this.mOperand.getAlphabet());
        hashSet.removeAll(this.mNwa.getVpAlphabet().getInternalAlphabet());
        HashSet<LETTER> hashSet2 = new HashSet<LETTER>(this.mOperand.getAlphabet());
        hashSet2.removeAll(hashSet);
        HashSet hashSet3 = new HashSet(this.mNwa.getVpAlphabet().getInternalAlphabet());
        hashSet3.removeAll(hashSet2);
        HashSet<LETTER> hashSet4 = new HashSet<LETTER>(this.mOperand.getAlphabet());
        hashSet4.addAll(hashSet3);
        boolean bl = this.mOperand.constantTokenAmount();
        BoundedPetriNet boundedPetriNet = new BoundedPetriNet(this.mServices, hashSet4, bl);
        this.addPlacesAndStates(boundedPetriNet);
        for (Transition<LETTER, PLACE> object2 : this.mOperand.getTransitions()) {
            this.updateSymbol2netTransitions(object2.getSymbol(), object2);
        }
        for (Object object2 : this.mNwa.getStates()) {
            for (OutgoingInternalTransition outgoingInternalTransition : this.mNwa.internalSuccessors(object2)) {
                Object LETTER = outgoingInternalTransition.getLetter();
                Object object3 = outgoingInternalTransition.getSucc();
                Collection collection = this.mSymbol2nwaTransitions.computeIfAbsent(LETTER, object -> new HashSet());
                collection.add(new AutomatonTransition(object2, LETTER, object3));
            }
        }
        this.addUnsharedTransitions(hashSet, hashSet3, boundedPetriNet);
        this.addSharedTransitions(hashSet2, boundedPetriNet);
        return boundedPetriNet;
    }

    private void addSharedTransitions(HashSet<LETTER> hashSet, BoundedPetriNet<LETTER, PLACE> boundedPetriNet) {
        for (LETTER LETTER : hashSet) {
            if (!this.mSymbol2netTransitions.containsKey(LETTER)) continue;
            for (Transition<LETTER, PLACE> transition : this.mSymbol2netTransitions.get(LETTER)) {
                if (!this.mSymbol2nwaTransitions.containsKey(LETTER)) continue;
                for (AutomatonTransition automatonTransition : this.mSymbol2nwaTransitions.get(LETTER)) {
                    HashSet hashSet2 = new HashSet();
                    this.addSharedTransitionsHelper(transition, automatonTransition, hashSet2, boundedPetriNet);
                }
            }
        }
    }

    private void addUnsharedTransitions(HashSet<LETTER> hashSet, HashSet<LETTER> hashSet2, BoundedPetriNet<LETTER, PLACE> boundedPetriNet) {
        for (LETTER LETTER : hashSet) {
            for (Transition<LETTER, PLACE> object : this.mSymbol2netTransitions.get(LETTER)) {
                boundedPetriNet.addTransition(object.getSymbol(), object.getPredecessors(), object.getSuccessors());
            }
        }
        for (LETTER LETTER : hashSet2) {
            for (AutomatonTransition automatonTransition : this.mSymbol2nwaTransitions.get(LETTER)) {
                Set set = Set.of(automatonTransition.getPredecessor());
                Set set2 = Set.of(automatonTransition.getSuccessor());
                boundedPetriNet.addTransition(automatonTransition.getSymbol(), ImmutableSet.of(set), ImmutableSet.of(set2));
            }
        }
    }

    private void addSharedTransitionsHelper(Transition<LETTER, PLACE> transition, AutomatonTransition automatonTransition, Set<PLACE> set, BoundedPetriNet<LETTER, PLACE> boundedPetriNet) {
        set.addAll((Collection<PLACE>)transition.getPredecessors());
        set.add(automatonTransition.getPredecessor());
        HashSet<PLACE> hashSet = new HashSet<PLACE>(transition.getSuccessors());
        hashSet.add(automatonTransition.getSuccessor());
        boundedPetriNet.addTransition(transition.getSymbol(), ImmutableSet.of(set), ImmutableSet.of(hashSet));
    }

    private void addPlacesAndStates(BoundedPetriNet<LETTER, PLACE> boundedPetriNet) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        for (PLACE PLACE : this.mOperand.getPlaces()) {
            bl = boundedPetriNet.addPlace(PLACE, bl3 = this.mOperand.getInitialPlaces().contains(PLACE), bl2 = this.mOperand.getAcceptingPlaces().contains(PLACE));
            if (!bl) {
                throw new AssertionError((Object)"Input must not contain place twice.");
            }
        }
        for (PLACE PLACE : this.mNwa.getStates()) {
            bl = boundedPetriNet.addPlace(PLACE, bl3 = this.mNwa.getInitialStates().contains(PLACE), bl2 = this.mNwa.isFinal(PLACE));
            if (bl) continue;
            throw new UnsupportedOperationException(PetriNetUtils.generateStatesAndPlacesDisjointErrorMessage(PLACE));
        }
    }

    @Override
    public boolean checkResult(CRSF CRSF) throws AutomataLibraryException {
        this.mLogger.info((Object)"Testing correctness of prefixProduct");
        Object object = new PetriNet2FiniteAutomaton<LETTER, PLACE>(this.mServices, CRSF, this.mOperand).getResult();
        Object object2 = new PetriNet2FiniteAutomaton<LETTER, PLACE>(this.mServices, CRSF, this.mResult).getResult();
        Object object3 = new ConcurrentProduct<LETTER, PLACE>(this.mServices, (IConcurrentProductStateFactory)CRSF, object, this.mNwa, true).getResult();
        boolean bl = new IsEquivalent(this.mServices, (INwaInclusionStateFactory)CRSF, object2, object3).getResult();
        this.mLogger.info((Object)"Finished testing correctness of prefixProduct");
        return bl;
    }

    private class AutomatonTransition {
        private final PLACE mPredecessor;
        private final LETTER mLetter;
        private final PLACE mSuccessor;

        public AutomatonTransition(PLACE PLACE, LETTER LETTER, PLACE PLACE2) {
            this.mPredecessor = PLACE;
            this.mLetter = LETTER;
            this.mSuccessor = PLACE2;
        }

        public PLACE getPredecessor() {
            return this.mPredecessor;
        }

        public LETTER getSymbol() {
            return this.mLetter;
        }

        public PLACE getSuccessor() {
            return this.mSuccessor;
        }
    }
}

