/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.TestGraphs;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.renderers.DefaultVertexLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.GradientVertexRenderer;
import edu.uci.ics.jung.visualization.renderers.VertexLabelAsShapeRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ChainedTransformer;
import org.apache.commons.collections15.functors.ConstantTransformer;

public class VertexLabelAsShapeDemo
extends JApplet {
    private static final long serialVersionUID = 1017336668368978842L;
    Graph<String, Number> graph = TestGraphs.getOneComponentGraph();
    VisualizationViewer<String, Number> vv;
    Layout<String, Number> layout = new FRLayout<String, Number>(this.graph);

    public VertexLabelAsShapeDemo() {
        Dimension preferredSize = new Dimension(400, 400);
        DefaultVisualizationModel<String, Number> visualizationModel = new DefaultVisualizationModel<String, Number>(this.layout, preferredSize);
        this.vv = new VisualizationViewer<String, Number>(visualizationModel, preferredSize);
        VertexLabelAsShapeRenderer vlasr = new VertexLabelAsShapeRenderer(this.vv.getRenderContext());
        this.vv.getRenderContext().setVertexLabelTransformer(new ChainedTransformer(new Transformer[]{new ToStringLabeller(), new Transformer<String, String>(){

            @Override
            public String transform(String input) {
                return "<html><center>Vertex<p>" + input;
            }
        }}));
        this.vv.getRenderContext().setVertexShapeTransformer(vlasr);
        this.vv.getRenderContext().setVertexLabelRenderer(new DefaultVertexLabelRenderer(Color.red));
        this.vv.getRenderContext().setEdgeDrawPaintTransformer(new ConstantTransformer<Paint>(Color.yellow));
        this.vv.getRenderContext().setEdgeStrokeTransformer(new ConstantTransformer<Stroke>(new BasicStroke(2.5f)));
        this.vv.getRenderer().setVertexRenderer(new GradientVertexRenderer(Color.gray, Color.white, true));
        this.vv.getRenderer().setVertexLabelRenderer(vlasr);
        this.vv.setBackground(Color.black);
        this.vv.setVertexToolTipTransformer(new ToStringLabeller());
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(graphMouse);
        this.vv.addKeyListener(graphMouse.getModeKeyListener());
        Container content = this.getContentPane();
        GraphZoomScrollPane gzsp = new GraphZoomScrollPane(this.vv);
        content.add(gzsp);
        JComboBox modeBox = graphMouse.getModeComboBox();
        modeBox.addItemListener(graphMouse.getModeListener());
        graphMouse.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(VertexLabelAsShapeDemo.this.vv, 1.1f, VertexLabelAsShapeDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(VertexLabelAsShapeDemo.this.vv, 0.9090909f, VertexLabelAsShapeDemo.this.vv.getCenter());
            }
        });
        JPanel controls = new JPanel();
        JPanel zoomControls = new JPanel(new GridLayout(2, 1));
        zoomControls.setBorder(BorderFactory.createTitledBorder("Zoom"));
        zoomControls.add(plus);
        zoomControls.add(minus);
        controls.add(zoomControls);
        controls.add(modeBox);
        content.add((Component)controls, "South");
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(new VertexLabelAsShapeDemo());
        f.pack();
        f.setVisible(true);
    }
}

