/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.RemoveDead;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.cfg2automaton.Cfg2Automaton;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction.IInitialAbstractionProvider;
import java.util.Set;

public class PetriInitialAbstractionProvider<L extends IIcfgTransition<?>>
implements IInitialAbstractionProvider<L, BoundedPetriNet<L, IPredicate>> {
    private static final boolean KEEP_USELESS_SUCCESSOR_PLACES = true;
    private final IUltimateServiceProvider mServices;
    private final PredicateFactory mPredicateFactory;
    private final boolean mRemoveDeadEnds;

    public PetriInitialAbstractionProvider(IUltimateServiceProvider iUltimateServiceProvider, PredicateFactory predicateFactory, boolean bl) {
        this.mServices = iUltimateServiceProvider;
        this.mPredicateFactory = predicateFactory;
        this.mRemoveDeadEnds = bl;
    }

    @Override
    public <LOC extends IcfgLocation> BoundedPetriNet<L, IPredicate> getInitialAbstraction(IIcfg<LOC> iIcfg, Set<LOC> set) throws AutomataOperationCanceledException {
        BoundedPetriNet boundedPetriNet = Cfg2Automaton.constructPetriNetWithSPredicates(this.mServices, iIcfg, set, this.mPredicateFactory);
        if (!this.mRemoveDeadEnds) {
            return boundedPetriNet;
        }
        try {
            return new RemoveDead(new AutomataLibraryServices(this.mServices), boundedPetriNet, null, true).getResult();
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            String string = "removing dead transitions from Petri net that has " + boundedPetriNet.sizeInformation();
            automataOperationCanceledException.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), string));
            throw automataOperationCanceledException;
        }
        catch (PetriNetNot1SafeException petriNetNot1SafeException) {
            throw new AssertionError((Object)petriNetNot1SafeException);
        }
    }
}

