/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AbstractGeneralizedAffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Monomial;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.SparseMapBuilder;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class PolynomialTerm
extends AbstractGeneralizedAffineTerm<Monomial> {
    public PolynomialTerm(Sort sort, Rational rational, Map<Monomial, Rational> map) {
        super(sort, rational, map);
        assert (!PolynomialTermUtils.isAffineMap(map)) : "This PolynomialTerm can be represented as an AffineTerm!";
    }

    public PolynomialTerm() {
    }

    @Override
    protected AbstractGeneralizedAffineTerm<?> constructNew(Sort sort, Rational rational, Map<Monomial, Rational> map) {
        return PolynomialTerm.minimalRepresentation(sort, rational, map);
    }

    @Override
    protected Monomial constructAbstractVar(Term term) {
        return new Monomial(term, Rational.ONE);
    }

    @Override
    public void checkIfTermIsLegalVariable(Term term) {
        if (!(term instanceof TermVariable) && !(term instanceof ApplicationTerm)) {
            throw new IllegalArgumentException("Variable of PolynomialTerm has to be TermVariable or ApplicationTerm");
        }
    }

    public static AbstractGeneralizedAffineTerm<?> mul(IPolynomialTerm iPolynomialTerm2, Rational rational) {
        if (iPolynomialTerm2.isAffine()) {
            PolynomialTermUtils.GeneralizedConstructor generalizedConstructor = AffineTerm::new;
            return PolynomialTermUtils.constructMul(iPolynomialTerm -> ((AffineTerm)iPolynomialTerm).getAbstractVariable2Coefficient(), generalizedConstructor, iPolynomialTerm2, rational);
        }
        PolynomialTermUtils.GeneralizedConstructor generalizedConstructor = PolynomialTerm::minimalRepresentation;
        return PolynomialTermUtils.constructMul(iPolynomialTerm -> iPolynomialTerm.getMonomial2Coefficient(), generalizedConstructor, iPolynomialTerm2, rational);
    }

    private static AbstractGeneralizedAffineTerm<?> minimalRepresentation(Sort sort, Rational rational, Map<Monomial, Rational> map) {
        if (PolynomialTermUtils.isAffineMap(map)) {
            return new AffineTerm(sort, rational, PolynomialTermUtils.convertToAffineMap(map));
        }
        return new PolynomialTerm(sort, rational, map);
    }

    public static IPolynomialTerm mulPolynomials(IPolynomialTerm iPolynomialTerm, IPolynomialTerm iPolynomialTerm2) {
        Rational rational = PolynomialTermUtils.bringValueInRange(iPolynomialTerm.getConstant().mul(iPolynomialTerm2.getConstant()), iPolynomialTerm.getSort());
        Map<Monomial, Rational> map = PolynomialTerm.calculateProductMap(iPolynomialTerm, iPolynomialTerm2);
        return PolynomialTerm.minimalRepresentation(iPolynomialTerm.getSort(), rational, map);
    }

    private static Map<Monomial, Rational> calculateProductMap(IPolynomialTerm iPolynomialTerm, IPolynomialTerm iPolynomialTerm2) {
        SparseMapBuilder sparseMapBuilder = new SparseMapBuilder();
        PolynomialTerm.monoTimesMonoIntoMap((SparseMapBuilder<Monomial, Rational>)sparseMapBuilder, iPolynomialTerm, iPolynomialTerm2);
        PolynomialTerm.monomialsTimesConstantIntoMap((SparseMapBuilder<Monomial, Rational>)sparseMapBuilder, iPolynomialTerm, iPolynomialTerm2);
        PolynomialTerm.monomialsTimesConstantIntoMap((SparseMapBuilder<Monomial, Rational>)sparseMapBuilder, iPolynomialTerm2, iPolynomialTerm);
        return sparseMapBuilder.getBuiltMap();
    }

    private static SparseMapBuilder<Monomial, Rational> monoTimesMonoIntoMap(SparseMapBuilder<Monomial, Rational> sparseMapBuilder, IPolynomialTerm iPolynomialTerm, IPolynomialTerm iPolynomialTerm2) {
        for (Map.Entry<Monomial, Rational> entry : iPolynomialTerm.getMonomial2Coefficient().entrySet()) {
            for (Map.Entry<Monomial, Rational> entry2 : iPolynomialTerm2.getMonomial2Coefficient().entrySet()) {
                Monomial monomial = new Monomial(entry.getKey(), entry2.getKey());
                Rational rational = (Rational)sparseMapBuilder.get((Object)monomial);
                Rational rational2 = rational == null ? entry.getValue().mul(entry2.getValue()) : entry.getValue().mul(entry2.getValue()).add(rational);
                Rational rational3 = PolynomialTermUtils.bringValueInRange(rational2, iPolynomialTerm.getSort());
                if (rational3.equals((Object)Rational.ZERO)) continue;
                sparseMapBuilder.put((Object)monomial, (Object)rational3);
            }
        }
        return sparseMapBuilder;
    }

    private static SparseMapBuilder<Monomial, Rational> monomialsTimesConstantIntoMap(SparseMapBuilder<Monomial, Rational> sparseMapBuilder, IPolynomialTerm iPolynomialTerm, IPolynomialTerm iPolynomialTerm2) {
        for (Map.Entry<Monomial, Rational> entry : iPolynomialTerm.getMonomial2Coefficient().entrySet()) {
            Rational rational = (Rational)sparseMapBuilder.remove((Object)entry.getKey());
            Rational rational2 = rational == null ? entry.getValue().mul(iPolynomialTerm2.getConstant()) : entry.getValue().mul(iPolynomialTerm2.getConstant()).add(rational);
            Rational rational3 = PolynomialTermUtils.bringValueInRange(rational2, iPolynomialTerm.getSort());
            if (rational3.equals((Object)Rational.ZERO)) continue;
            sparseMapBuilder.put((Object)entry.getKey(), (Object)rational3);
        }
        return sparseMapBuilder;
    }

    public static AbstractGeneralizedAffineTerm<?> sum(IPolynomialTerm ... iPolynomialTermArray) {
        PolynomialTermUtils.GeneralizedConstructor generalizedConstructor = PolynomialTerm::minimalRepresentation;
        return PolynomialTermUtils.constructSum(PolynomialTerm::termWrapper, generalizedConstructor, iPolynomialTermArray);
    }

    private static Map<Monomial, Rational> termWrapper(IPolynomialTerm iPolynomialTerm) {
        if (iPolynomialTerm.isAffine()) {
            SparseMapBuilder sparseMapBuilder = new SparseMapBuilder();
            for (Map.Entry<Term, Rational> entry : ((AffineTerm)iPolynomialTerm).getVariable2Coefficient().entrySet()) {
                sparseMapBuilder.put((Object)new Monomial(entry.getKey(), Rational.ONE), (Object)entry.getValue());
            }
            return sparseMapBuilder.getBuiltMap();
        }
        return ((PolynomialTerm)iPolynomialTerm).getMonomial2Coefficient();
    }

    @Override
    protected Term abstractVariableToTerm(Script script, Monomial monomial) {
        return monomial.toTerm(script);
    }

    @Override
    protected Collection<Term> getFreeVars(Monomial monomial) {
        return monomial.getVariable2Exponent().entrySet().stream().flatMap(entry -> Arrays.stream(((Term)entry.getKey()).getFreeVars())).collect(Collectors.toSet());
    }

    @Override
    protected Term abstractVariableTimesCoeffToTerm(Script script, Monomial monomial, Rational rational) {
        return monomial.timesCoefficientToTerm(script, rational);
    }

    @Override
    public Map<Monomial, Rational> getMonomial2Coefficient() {
        return this.mAbstractVariable2Coefficient;
    }

    @Override
    public boolean isVariable(Term term) {
        for (Monomial monomial : this.getMonomial2Coefficient().keySet()) {
            if (!monomial.isVariable(term)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAffine() {
        return false;
    }

    @Override
    public String toString() {
        Map.Entry<Monomial, Rational> entry2;
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<Monomial, Rational> entry2 : this.getMonomial2Coefficient().entrySet()) {
            stringBuilder.append(entry2.getValue().isNegative() ? " - " : " + ");
            stringBuilder.append(String.valueOf(((Rational)entry2.getValue()).abs()) + "*" + String.valueOf(entry2.getKey()));
        }
        if (!this.mConstant.equals((Object)Rational.ZERO) || stringBuilder.length() == 0) {
            if (this.mConstant.isNegative() || stringBuilder.length() > 0) {
                stringBuilder.append(this.mConstant.isNegative() ? " - " : " + ");
            }
            stringBuilder.append(this.mConstant.abs());
        }
        if (((String)((Object)(entry2 = stringBuilder.toString()))).charAt(0) == ' ') {
            entry2 = ((String)((Object)entry2)).substring(1);
        }
        return entry2;
    }

    @Override
    protected Pair<Rational, Rational> computeMinMax() {
        return null;
    }

    @Override
    public PolynomialTerm add(Rational rational) {
        Rational rational2;
        if (SmtSortUtils.isRealSort(this.getSort())) {
            rational2 = this.getConstant().add(rational);
        } else if (SmtSortUtils.isIntSort(this.getSort())) {
            if (!rational.isIntegral()) {
                throw new UnsupportedOperationException("Cannot add non-integral summand if sort is " + String.valueOf(this.getSort()));
            }
            rational2 = this.getConstant().add(rational);
        } else if (SmtSortUtils.isBitvecSort(this.getSort())) {
            if (!rational.isIntegral()) {
                throw new UnsupportedOperationException("Cannot add non-integral summand if sort is " + String.valueOf(this.getSort()));
            }
            rational2 = PolynomialTermUtils.bringBitvectorValueInRange(this.getConstant().add(rational), this.getSort());
        } else {
            throw new AssertionError((Object)("unsupported Sort " + String.valueOf(this.getSort())));
        }
        return new PolynomialTerm(this.getSort(), rational2, this.getAbstractVariable2Coefficient());
    }

    @Override
    public AbstractGeneralizedAffineTerm<?> removeAndNegate(Monomial monomial) {
        boolean bl = true;
        HashMap<Monomial, Rational> hashMap = new HashMap<Monomial, Rational>();
        for (Map.Entry rational2 : this.mAbstractVariable2Coefficient.entrySet()) {
            if (((Monomial)rational2.getKey()).equals(monomial)) continue;
            Rational rational = PolynomialTermUtils.bringValueInRange(((Rational)rational2.getValue()).negate(), this.getSort());
            hashMap.put((Monomial)rational2.getKey(), rational);
            if (((Monomial)rational2.getKey()).isLinear()) continue;
            bl = false;
        }
        Rational rational = PolynomialTermUtils.bringValueInRange(this.getConstant().negate(), this.getSort());
        if (bl) {
            Map<Term, Rational> map = hashMap.entrySet().stream().collect(Collectors.toMap(entry -> ((Monomial)entry.getKey()).getSingleVariable(), entry -> (Rational)entry.getValue()));
            return new AffineTerm(this.getSort(), rational, map);
        }
        return new PolynomialTerm(this.getSort(), rational, (Map<Monomial, Rational>)hashMap);
    }

    @Override
    public AbstractGeneralizedAffineTerm<?> divInvertible(Rational rational) {
        HashMap<Monomial, Rational> hashMap = new HashMap<Monomial, Rational>();
        for (Map.Entry rational22 : this.mAbstractVariable2Coefficient.entrySet()) {
            Rational rational2 = PolynomialTermUtils.divInvertible(this.getSort(), (Rational)rational22.getValue(), rational);
            if (rational2 == null) {
                return null;
            }
            hashMap.put((Monomial)rational22.getKey(), rational2);
        }
        Rational rational3 = PolynomialTermUtils.divInvertible(this.getSort(), this.getConstant(), rational);
        if (rational3 == null) {
            return null;
        }
        return new PolynomialTerm(this.getSort(), rational3, (Map<Monomial, Rational>)hashMap);
    }
}

