/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.Interpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorAtomInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorClauseInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import java.util.Map;

public class EQInterpolator {
    Interpolator mInterpolator;

    public EQInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    static InterpolatorAffineTerm termToAffine(Term term) {
        if (term instanceof AnnotatedTerm) {
            term = ((AnnotatedTerm)term).getSubterm();
        }
        SMTAffineTerm sMTAffineTerm = new SMTAffineTerm(term);
        return new InterpolatorAffineTerm(sMTAffineTerm);
    }

    private Rational getLAFactor(InterpolatorAtomInfo interpolatorAtomInfo, InterpolatorAtomInfo interpolatorAtomInfo2) {
        SMTAffineTerm sMTAffineTerm = new SMTAffineTerm(interpolatorAtomInfo.getEquality().getParameters()[0]);
        sMTAffineTerm.add(Rational.MONE, interpolatorAtomInfo.getEquality().getParameters()[1]);
        assert (!sMTAffineTerm.isConstant());
        Map.Entry<Term, Rational> entry = sMTAffineTerm.getSummands().entrySet().iterator().next();
        Rational rational = entry.getValue();
        Rational rational2 = interpolatorAtomInfo2.getAffineTerm().getSummands().get(entry.getKey());
        assert (rational2 != null && rational2 != Rational.ZERO);
        return rational2.div(rational);
    }

    public Term[] computeInterpolantsTrivialEq(Term term) {
        assert (this.mInterpolator.isNegatedTerm(term));
        Term term2 = this.mInterpolator.getAtom(term);
        assert (((ApplicationTerm)term2).getFunction().getName() == "=");
        Term[] termArray = ((ApplicationTerm)term2).getParameters();
        Interpolator.LitInfo litInfo = this.mInterpolator.getAtomOccurenceInfo(term2);
        Term[] termArray2 = new Term[this.mInterpolator.mNumInterpolants];
        Rational rational = null;
        int n = 0;
        while (n < this.mInterpolator.mNumInterpolants) {
            ApplicationTerm applicationTerm;
            if (litInfo.isAorShared(n)) {
                applicationTerm = this.mInterpolator.mTheory.mFalse;
            } else if (litInfo.isBorShared(n)) {
                applicationTerm = this.mInterpolator.mTheory.mTrue;
            } else {
                SMTAffineTerm sMTAffineTerm;
                if (rational == null) {
                    sMTAffineTerm = new SMTAffineTerm();
                    sMTAffineTerm.add(Rational.ONE, termArray[0]);
                    sMTAffineTerm.add(Rational.MONE, termArray[1]);
                    rational = sMTAffineTerm.getGcd();
                    assert (!sMTAffineTerm.getConstant().div(rational).isIntegral());
                }
                sMTAffineTerm = new SMTAffineTerm();
                sMTAffineTerm.add(Rational.ONE, litInfo.mLhsOccur.isALocal(n) ? termArray[0] : termArray[1]);
                SMTAffineTerm sMTAffineTerm2 = new SMTAffineTerm();
                for (Map.Entry<Term, Rational> entry : sMTAffineTerm.getSummands().entrySet()) {
                    if (entry.getValue().div(rational).isIntegral()) continue;
                    sMTAffineTerm2.add(entry.getValue(), entry.getKey());
                }
                sMTAffineTerm2.add(sMTAffineTerm.getConstant());
                sMTAffineTerm2.add(Rational.MONE, (Term)litInfo.getMixedVar());
                Sort sort2 = termArray[0].getSort();
                Theory theory = this.mInterpolator.mTheory;
                applicationTerm = theory.term("=", new Term[]{theory.term("mod", new Term[]{sMTAffineTerm2.toTerm(sort2), rational.toTerm(sort2)}), Rational.ZERO.toTerm(sort2)});
            }
            termArray2[n] = applicationTerm;
            ++n;
        }
        return termArray2;
    }

    public Term[] computeInterpolants(InterpolatorClauseInfo interpolatorClauseInfo) {
        boolean bl;
        Interpolator.LitInfo litInfo;
        Interpolator.LitInfo litInfo2;
        InterpolatorAtomInfo interpolatorAtomInfo;
        InterpolatorAtomInfo interpolatorAtomInfo2;
        Term[] termArray = null;
        Term[] termArray2 = interpolatorClauseInfo.getLiterals();
        assert (termArray2.length <= 2);
        if (termArray2.length == 1) {
            return this.computeInterpolantsTrivialEq(termArray2[0]);
        }
        Term term = this.mInterpolator.getAtom(termArray2[0]);
        Term term2 = this.mInterpolator.getAtom(termArray2[1]);
        InterpolatorAtomInfo interpolatorAtomInfo3 = this.mInterpolator.getAtomTermInfo(term);
        InterpolatorAtomInfo interpolatorAtomInfo4 = this.mInterpolator.getAtomTermInfo(term2);
        assert (this.mInterpolator.isNegatedTerm(termArray2[0]) != this.mInterpolator.isNegatedTerm(termArray2[1]));
        if (interpolatorAtomInfo3.isLAEquality()) {
            interpolatorAtomInfo2 = interpolatorAtomInfo3;
            interpolatorAtomInfo = interpolatorAtomInfo4;
            litInfo2 = this.mInterpolator.getAtomOccurenceInfo(term);
            litInfo = this.mInterpolator.getAtomOccurenceInfo(term2);
            bl = term2 != termArray2[1];
        } else {
            interpolatorAtomInfo2 = interpolatorAtomInfo4;
            interpolatorAtomInfo = interpolatorAtomInfo3;
            litInfo2 = this.mInterpolator.getAtomOccurenceInfo(term2);
            litInfo = this.mInterpolator.getAtomOccurenceInfo(term);
            boolean bl2 = bl = term != termArray2[0];
        }
        assert (interpolatorAtomInfo2.isLAEquality() && interpolatorAtomInfo.isCCEquality());
        Rational rational = this.getLAFactor(interpolatorAtomInfo, interpolatorAtomInfo2);
        termArray = new Term[this.mInterpolator.mNumInterpolants];
        int n = 0;
        while (n < this.mInterpolator.mNumInterpolants) {
            ApplicationTerm applicationTerm;
            if (litInfo.isAorShared(n) && litInfo2.isAorShared(n)) {
                applicationTerm = this.mInterpolator.mTheory.mFalse;
            } else if (litInfo.isBorShared(n) && litInfo2.isBorShared(n)) {
                applicationTerm = this.mInterpolator.mTheory.mTrue;
            } else {
                InterpolatorAffineTerm interpolatorAffineTerm = new InterpolatorAffineTerm();
                TermVariable termVariable = null;
                boolean bl3 = false;
                ApplicationTerm applicationTerm2 = interpolatorAtomInfo.getEquality();
                if (litInfo.isALocal(n)) {
                    interpolatorAffineTerm.add(rational, EQInterpolator.termToAffine(applicationTerm2.getParameters()[0]));
                    interpolatorAffineTerm.add(rational.negate(), EQInterpolator.termToAffine(applicationTerm2.getParameters()[1]));
                    if (!bl) {
                        bl3 = true;
                    }
                } else if (litInfo.isMixed(n)) {
                    if (!bl) {
                        termVariable = litInfo.getMixedVar();
                    }
                    if (litInfo.mLhsOccur.isALocal(n)) {
                        interpolatorAffineTerm.add(rational, EQInterpolator.termToAffine(applicationTerm2.getParameters()[0]));
                        interpolatorAffineTerm.add(rational.negate(), (Term)litInfo.getMixedVar());
                    } else {
                        interpolatorAffineTerm.add(rational, (Term)litInfo.getMixedVar());
                        interpolatorAffineTerm.add(rational.negate(), EQInterpolator.termToAffine(applicationTerm2.getParameters()[1]));
                    }
                }
                if (litInfo2.isALocal(n)) {
                    interpolatorAffineTerm.add(Rational.MONE, interpolatorAtomInfo2.getAffineTerm());
                    if (bl) {
                        bl3 = true;
                    }
                } else if (litInfo2.isMixed(n)) {
                    if (bl) {
                        termVariable = litInfo2.getMixedVar();
                    }
                    interpolatorAffineTerm.add(Rational.MONE, litInfo2.getAPart(n));
                    interpolatorAffineTerm.add(Rational.ONE, (Term)litInfo2.getMixedVar());
                }
                interpolatorAffineTerm.mul(interpolatorAffineTerm.getGcd().inverse());
                if (termVariable != null) {
                    Rational rational2 = interpolatorAffineTerm.getSummands().remove(termVariable);
                    assert (rational2.isIntegral());
                    boolean bl4 = termVariable.getSort().getName().equals("Int");
                    if (bl4 && rational2.abs() != Rational.ONE) {
                        if (rational2.signum() > 0) {
                            interpolatorAffineTerm.negate();
                        }
                        var22_24 = interpolatorAffineTerm.toSMTLib(this.mInterpolator.mTheory, bl4);
                        var23_25 = rational2.abs().toTerm(termVariable.getSort());
                        applicationTerm = this.mInterpolator.mTheory.and(new Term[]{this.mInterpolator.mTheory.term("@EQ", new Term[]{termVariable, this.mInterpolator.mTheory.term("div", new Term[]{var22_24, var23_25})}), this.mInterpolator.mTheory.term("=", new Term[]{this.mInterpolator.mTheory.term("mod", new Term[]{var22_24, var23_25}), Rational.ZERO.toTerm(termVariable.getSort())})});
                    } else {
                        interpolatorAffineTerm.mul(rational2.negate().inverse());
                        var22_24 = interpolatorAffineTerm.toSMTLib(this.mInterpolator.mTheory, bl4);
                        applicationTerm = this.mInterpolator.mTheory.term("@EQ", new Term[]{termVariable, var22_24});
                    }
                } else if (interpolatorAffineTerm.isConstant()) {
                    if (interpolatorAffineTerm.getConstant() != InfinitesimalNumber.ZERO) {
                        bl3 ^= true;
                    }
                    applicationTerm = bl3 ? this.mInterpolator.mTheory.mFalse : this.mInterpolator.mTheory.mTrue;
                } else {
                    boolean bl5 = interpolatorAffineTerm.isInt();
                    Sort sort = this.mInterpolator.mTheory.getSort(bl5 ? "Int" : "Real", new Sort[0]);
                    var22_24 = interpolatorAffineTerm.toSMTLib(this.mInterpolator.mTheory, bl5);
                    var23_25 = Rational.ZERO.toTerm(sort);
                    applicationTerm = bl3 ? this.mInterpolator.mTheory.not(this.mInterpolator.mTheory.equals(new Term[]{var22_24, var23_25})) : this.mInterpolator.mTheory.equals(new Term[]{var22_24, var23_25});
                }
            }
            termArray[n] = applicationTerm;
            ++n;
        }
        return termArray;
    }
}

