/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.sign;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractStateBinaryOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.sign.SignDomainState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.sign.SignDomainValue;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;

public class SignMergeOperator
implements IAbstractStateBinaryOperator<SignDomainState> {
    private static final int BUFFER_SIZE = 100;

    protected SignMergeOperator() {
    }

    public SignDomainState apply(SignDomainState signDomainState, SignDomainState signDomainState2) {
        assert (signDomainState != null);
        assert (signDomainState2 != null);
        if (!signDomainState.hasSameVariables(signDomainState2)) {
            throw new UnsupportedOperationException("Cannot merge two states with a disjoint set of variables.");
        }
        SignDomainState signDomainState3 = signDomainState.createCopy();
        ImmutableSet<IProgramVarOrConst> immutableSet = signDomainState.getVariables();
        for (IProgramVarOrConst iProgramVarOrConst : immutableSet) {
            SignDomainValue signDomainValue = (SignDomainValue)signDomainState.getValue(iProgramVarOrConst);
            SignDomainValue signDomainValue2 = (SignDomainValue)signDomainState2.getValue(iProgramVarOrConst);
            signDomainState3.setValue(iProgramVarOrConst, SignMergeOperator.computeMergedValue(signDomainValue, signDomainValue2));
        }
        return signDomainState3;
    }

    private static SignDomainValue computeMergedValue(SignDomainValue signDomainValue, SignDomainValue signDomainValue2) {
        if (signDomainValue.getValue() == signDomainValue2.getValue()) {
            return new SignDomainValue(signDomainValue.getValue());
        }
        if (signDomainValue.getValue() == SignDomainValue.SignValues.BOTTOM || signDomainValue2.getValue() == SignDomainValue.SignValues.BOTTOM) {
            return new SignDomainValue(SignDomainValue.SignValues.BOTTOM);
        }
        if (signDomainValue.getValue() == SignDomainValue.SignValues.POSITIVE && signDomainValue2.getValue() == SignDomainValue.SignValues.NEGATIVE || signDomainValue.getValue() == SignDomainValue.SignValues.NEGATIVE && signDomainValue2.getValue() == SignDomainValue.SignValues.POSITIVE) {
            return new SignDomainValue(SignDomainValue.SignValues.TOP);
        }
        if (signDomainValue.getValue() == SignDomainValue.SignValues.ZERO || signDomainValue2.getValue() == SignDomainValue.SignValues.ZERO) {
            return new SignDomainValue(SignDomainValue.SignValues.TOP);
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("Unable to handle value1 = ").append((Object)signDomainValue.getValue()).append(" and value2 = ").append((Object)signDomainValue2.getValue()).append('.');
        throw new UnsupportedOperationException(stringBuilder.toString());
    }
}

