/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithSeverity;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.List;

public class AnnotationCheckResult<ELEM extends IElement, EXPR>
extends AbstractResult
implements IResultWithSeverity {
    final IBacktranslationService mTranslatorSequence;
    private final List<LoopFreeSegment<ELEM>> mSegmentsValid;
    private final List<LoopFreeSegment<ELEM>> mSegmentsUnknown;
    private final List<LoopFreeSegmentWithStatePair<ELEM, EXPR>> mSegmentsInvalid;
    private final List<Pair<CategorizedProgramPoint, CategorizedProgramPoint>> mNonCycleFreeSubgraphs;
    private final List<CategorizedProgramPoint> mLoopLocationsWithoutInvariant;
    private final AnnotationState mAnnotationState;

    public AnnotationCheckResult(String string, IBacktranslationService iBacktranslationService, List<LoopFreeSegment<ELEM>> list, List<LoopFreeSegment<ELEM>> list2, List<LoopFreeSegmentWithStatePair<ELEM, EXPR>> list3, List<Pair<CategorizedProgramPoint, CategorizedProgramPoint>> list4, List<CategorizedProgramPoint> list5) {
        super(string);
        this.mTranslatorSequence = iBacktranslationService;
        this.mSegmentsValid = list;
        this.mSegmentsUnknown = list2;
        this.mSegmentsInvalid = list3;
        this.mNonCycleFreeSubgraphs = list4;
        this.mLoopLocationsWithoutInvariant = list5;
        this.mAnnotationState = this.determineAnnotationState(list, list2, list3, list4, list5);
    }

    private AnnotationState determineAnnotationState(List<LoopFreeSegment<ELEM>> list, List<LoopFreeSegment<ELEM>> list2, List<LoopFreeSegmentWithStatePair<ELEM, EXPR>> list3, List<Pair<CategorizedProgramPoint, CategorizedProgramPoint>> list4, List<CategorizedProgramPoint> list5) {
        AnnotationState annotationState = list3.isEmpty() && list4.isEmpty() && list5.isEmpty() ? (list2.isEmpty() ? AnnotationState.VALID : AnnotationState.UNKNOWN) : AnnotationState.INVALID;
        return annotationState;
    }

    public AnnotationState getAnnotationState() {
        return this.mAnnotationState;
    }

    public IResultWithSeverity.Severity getSeverity() {
        return switch (this.mAnnotationState) {
            case AnnotationState.VALID -> IResultWithSeverity.Severity.INFO;
            case AnnotationState.UNKNOWN, AnnotationState.INVALID -> IResultWithSeverity.Severity.ERROR;
            default -> throw new MatchException(null, null);
        };
    }

    public String getShortDescription() {
        return switch (this.mAnnotationState) {
            case AnnotationState.INVALID -> "Annotation is not a valid proof of correctness.";
            case AnnotationState.UNKNOWN -> "Insufficient resources for checking whether annotation is a valid proof of correctness.";
            case AnnotationState.VALID -> "Annotation is a valid proof of correctness.";
            default -> throw new MatchException(null, null);
        };
    }

    public String getLongDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getShortDescription());
        stringBuilder.append(System.lineSeparator());
        for (CategorizedProgramPoint object : this.mLoopLocationsWithoutInvariant) {
            stringBuilder.append(this.loopLocationsWithoutInvariantToString(object, this.mTranslatorSequence));
            stringBuilder.append(System.lineSeparator());
        }
        for (Pair pair : this.mNonCycleFreeSubgraphs) {
            stringBuilder.append(this.nonCycleFreeSubgraphToString((Pair<CategorizedProgramPoint, CategorizedProgramPoint>)pair, this.mTranslatorSequence));
            stringBuilder.append(System.lineSeparator());
        }
        for (LoopFreeSegmentWithStatePair loopFreeSegmentWithStatePair : this.mSegmentsInvalid) {
            stringBuilder.append(AnnotationCheckResult.invalidSegmentToString(loopFreeSegmentWithStatePair, this.mTranslatorSequence));
            stringBuilder.append(System.lineSeparator());
        }
        for (LoopFreeSegment loopFreeSegment : this.mSegmentsUnknown) {
            stringBuilder.append(AnnotationCheckResult.unknownSegmentToString(loopFreeSegment));
            stringBuilder.append(System.lineSeparator());
        }
        for (LoopFreeSegment loopFreeSegment : this.mSegmentsValid) {
            stringBuilder.append(AnnotationCheckResult.validSegmentToString(loopFreeSegment));
            stringBuilder.append(System.lineSeparator());
        }
        return stringBuilder.toString();
    }

    private String loopLocationsWithoutInvariantToString(CategorizedProgramPoint categorizedProgramPoint, IBacktranslationService iBacktranslationService) {
        return "Missing invariants at " + String.valueOf(categorizedProgramPoint) + ".";
    }

    private String nonCycleFreeSubgraphToString(Pair<CategorizedProgramPoint, CategorizedProgramPoint> pair, IBacktranslationService iBacktranslationService) {
        return "Not cycle-free: Subgraph between " + String.valueOf(pair.getFirst()) + " and " + String.valueOf(pair.getSecond()) + ".";
    }

    public static <E> String validSegmentToString(LoopFreeSegment<E> loopFreeSegment) {
        return "Annotation is valid for " + String.valueOf(loopFreeSegment) + ".";
    }

    public static <E> String unknownSegmentToString(LoopFreeSegment<E> loopFreeSegment) {
        return "Insufficient resources for checking whether annotation is valid for " + String.valueOf(loopFreeSegment) + ".";
    }

    public static <ELEM, E> String invalidSegmentToString(LoopFreeSegmentWithStatePair<ELEM, E> loopFreeSegmentWithStatePair, IBacktranslationService iBacktranslationService) {
        return "Annotation is not valid for " + String.valueOf(loopFreeSegmentWithStatePair) + ". One counterexample starts in " + iBacktranslationService.translateProgramStateToString(loopFreeSegmentWithStatePair.getStateBefore()) + " and ends in " + iBacktranslationService.translateProgramStateToString(loopFreeSegmentWithStatePair.getStateAfter()) + ".";
    }

    public static enum AnnotationState {
        VALID,
        UNKNOWN,
        INVALID;

    }

    public static abstract class CategorizedProgramPoint {
        private final ILocation mLocation;

        public CategorizedProgramPoint(ILocation iLocation) {
            this.mLocation = iLocation;
        }

        protected ILocation getLocation() {
            return this.mLocation;
        }
    }

    public static class CheckPoint
    extends CategorizedProgramPoint {
        final Check mCheck;

        public CheckPoint(ILocation iLocation, Check check) {
            super(iLocation);
            this.mCheck = check;
        }

        public String toString() {
            return "check that " + this.mCheck.getPositiveMessage() + " at line " + this.getLocation().getStartLine();
        }
    }

    public static class Label
    extends CategorizedProgramPoint {
        public Label(ILocation iLocation) {
            super(iLocation);
        }

        public String toString() {
            return "label at line " + this.getLocation().getStartLine();
        }
    }

    public static class LoopFreeSegment<E> {
        final CategorizedProgramPoint mCppBefore;
        final CategorizedProgramPoint mCppAfter;

        public LoopFreeSegment(CategorizedProgramPoint categorizedProgramPoint, CategorizedProgramPoint categorizedProgramPoint2) {
            this.mCppBefore = categorizedProgramPoint;
            this.mCppAfter = categorizedProgramPoint2;
        }

        public String toString() {
            return "all loop-free paths from " + String.valueOf(this.mCppBefore) + " to " + String.valueOf(this.mCppAfter);
        }
    }

    public static class LoopFreeSegmentWithStatePair<ELEM, E>
    extends LoopFreeSegment<ELEM> {
        final IProgramExecution.ProgramState<E> mStateBefore;
        final IProgramExecution.ProgramState<E> mStateAfter;

        public LoopFreeSegmentWithStatePair(CategorizedProgramPoint categorizedProgramPoint, CategorizedProgramPoint categorizedProgramPoint2, IProgramExecution.ProgramState<E> programState, IProgramExecution.ProgramState<E> programState2) {
            super(categorizedProgramPoint, categorizedProgramPoint2);
            this.mStateBefore = programState;
            this.mStateAfter = programState2;
        }

        public IProgramExecution.ProgramState<E> getStateBefore() {
            return this.mStateBefore;
        }

        public IProgramExecution.ProgramState<E> getStateAfter() {
            return this.mStateAfter;
        }
    }

    public static class LoopHead
    extends CategorizedProgramPoint {
        public LoopHead(ILocation iLocation) {
            super(iLocation);
        }

        public String toString() {
            return "loop head at line " + this.getLocation().getStartLine();
        }
    }

    public static class ProcedureEntry
    extends CategorizedProgramPoint {
        final String mProcedureName;

        public ProcedureEntry(ILocation iLocation, String string) {
            super(iLocation);
            this.mProcedureName = string;
        }

        public String toString() {
            return "entry of procedure " + this.mProcedureName;
        }
    }

    public static class ProcedureExit
    extends CategorizedProgramPoint {
        final String mProcedureName;

        public ProcedureExit(ILocation iLocation, String string) {
            super(iLocation);
            this.mProcedureName = string;
        }

        public String toString() {
            return "exit of procedure " + this.mProcedureName;
        }
    }
}

