/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.util;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.UncheckedURISyntaxException;
import de.uni_freiburg.informatik.ultimate.util.ReflectionUtil;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Dictionary;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class RcpUtils {
    private RcpUtils() {
    }

    public static String getVersion(String string) {
        Bundle bundle = Platform.getBundle((String)string);
        if (bundle == null) {
            return "UNKNOWN";
        }
        Dictionary dictionary = bundle.getHeaders();
        if (dictionary != null) {
            return (String)dictionary.get("Bundle-Version");
        }
        return "UNKNOWN";
    }

    public static File getWorkingDirectory() {
        try {
            return URIUtil.toFile((URI)Platform.getInstallLocation().getURL().toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new UncheckedURISyntaxException(uRISyntaxException);
        }
    }

    public static String getInstanceLocationPath() {
        URL uRL;
        Location location = Platform.getInstanceLocation();
        if (location != null && (uRL = location.getURL()) != null) {
            return uRL.getPath();
        }
        return null;
    }

    public static String[] getFrameworkArguments() {
        EnvironmentInfo environmentInfo = RcpUtils.getEnvironmentInfo();
        return environmentInfo.getFrameworkArgs();
    }

    public static EnvironmentInfo getEnvironmentInfo() {
        BundleContext bundleContext = Platform.getBundle((String)"de.uni_freiburg.informatik.ultimate.core").getBundleContext();
        if (bundleContext == null) {
            return null;
        }
        ServiceReference serviceReference = bundleContext.getServiceReference(EnvironmentInfo.class.getName());
        if (serviceReference == null) {
            return null;
        }
        EnvironmentInfo environmentInfo = (EnvironmentInfo)bundleContext.getService(serviceReference);
        if (environmentInfo == null) {
            return null;
        }
        bundleContext.ungetService(serviceReference);
        return environmentInfo;
    }

    public static ReflectionUtil.UrlConverter getBundleProtocolResolver() {
        return uRL -> FileLocator.toFileURL((URL)uRL);
    }
}

