/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.ltl2aut.ast;

import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableSimpleAST;
import de.uni_freiburg.informatik.ultimate.ltl2aut.ast.AstNode;
import de.uni_freiburg.informatik.ultimate.ltl2aut.ast.BinaryType;

public class BinaryOperator
extends AstNode {
    private final BinaryType type;

    public BinaryOperator(BinaryType binaryType) {
        this.type = binaryType;
    }

    public BinaryOperator(BinaryType binaryType, AstNode astNode, AstNode astNode2) {
        this.type = binaryType;
        this.addOutgoing((IModifiableSimpleAST)astNode);
        this.addOutgoing((IModifiableSimpleAST)astNode2);
    }

    @Override
    public String toString() {
        String string = switch (this.type) {
            case BinaryType.and -> " && ";
            case BinaryType.or -> " || ";
            case BinaryType.minus -> " - ";
            case BinaryType.plus -> " + ";
            case BinaryType.times -> " * ";
            case BinaryType.divide -> " / ";
            default -> throw new MatchException(null, null);
        };
        StringBuilder stringBuilder = new StringBuilder("( ");
        int n = 0;
        while (n < this.getOutgoingNodes().size() - 1) {
            stringBuilder.append(((AstNode)((Object)this.getOutgoingNodes().get(n))).toString()).append(string);
            ++n;
        }
        stringBuilder.append(((AstNode)((Object)this.getOutgoingNodes().get(n))).toString());
        stringBuilder.append(" )");
        return stringBuilder.toString();
    }

    public BinaryType getType() {
        return this.type;
    }
}

