/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg;

import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ForkStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.JoinStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IStorable;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.ForkThreadCurrent;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.GotoEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.JoinThreadCurrent;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.ParallelComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Return;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.SequentialComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import de.uni_freiburg.informatik.ultimate.util.datastructures.SerialProvider;
import java.util.List;

public class CodeBlockFactory
implements IStorable {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final ManagedScript mMgdScript;
    private final CfgSmtToolkit mMgvManager;
    private final SerialProvider mSerialProvider;

    public CodeBlockFactory(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, CfgSmtToolkit cfgSmtToolkit, IIcfgSymbolTable iIcfgSymbolTable, SerialProvider serialProvider) {
        this.mSerialProvider = serialProvider;
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mMgdScript = managedScript;
        this.mMgvManager = cfgSmtToolkit;
    }

    public Call constructCall(BoogieIcfgLocation boogieIcfgLocation, BoogieIcfgLocation boogieIcfgLocation2, CallStatement callStatement) {
        return new Call(this.makeFreshSerial(), boogieIcfgLocation, boogieIcfgLocation2, callStatement, this.mLogger);
    }

    public ForkThreadCurrent constructForkCurrentThread(BoogieIcfgLocation boogieIcfgLocation, BoogieIcfgLocation boogieIcfgLocation2, ForkStatement forkStatement, boolean bl) {
        return new ForkThreadCurrent(this.makeFreshSerial(), boogieIcfgLocation, boogieIcfgLocation2, forkStatement, bl, this.mLogger);
    }

    public JoinThreadCurrent constructJoinCurrentThread(BoogieIcfgLocation boogieIcfgLocation, BoogieIcfgLocation boogieIcfgLocation2, JoinStatement joinStatement) {
        return new JoinThreadCurrent(this.makeFreshSerial(), boogieIcfgLocation, boogieIcfgLocation2, joinStatement, this.mLogger);
    }

    public GotoEdge constructGotoEdge(BoogieIcfgLocation boogieIcfgLocation, BoogieIcfgLocation boogieIcfgLocation2) {
        return new GotoEdge(this.makeFreshSerial(), boogieIcfgLocation, boogieIcfgLocation2, this.mLogger);
    }

    public ParallelComposition constructParallelComposition(BoogieIcfgLocation boogieIcfgLocation, BoogieIcfgLocation boogieIcfgLocation2, List<CodeBlock> list, SmtUtils.SimplificationTechnique simplificationTechnique) {
        return new ParallelComposition(this.makeFreshSerial(), boogieIcfgLocation, boogieIcfgLocation2, this.mMgdScript, this.mServices, list);
    }

    public Return constructReturn(BoogieIcfgLocation boogieIcfgLocation, BoogieIcfgLocation boogieIcfgLocation2, Call call) {
        return new Return(this.makeFreshSerial(), boogieIcfgLocation, boogieIcfgLocation2, call, this.mLogger);
    }

    public SequentialComposition constructSequentialComposition(BoogieIcfgLocation boogieIcfgLocation, BoogieIcfgLocation boogieIcfgLocation2, boolean bl, boolean bl2, List<CodeBlock> list, SmtUtils.SimplificationTechnique simplificationTechnique) {
        return new SequentialComposition(this.makeFreshSerial(), boogieIcfgLocation, boogieIcfgLocation2, this.mMgvManager, bl, bl2, this.mServices, list, simplificationTechnique);
    }

    public SequentialComposition constructSequentialCompositionAndDisconnectEdges(BoogieIcfgLocation boogieIcfgLocation, BoogieIcfgLocation boogieIcfgLocation2, boolean bl, boolean bl2, List<CodeBlock> list, SmtUtils.SimplificationTechnique simplificationTechnique) {
        SequentialComposition sequentialComposition = this.constructSequentialComposition(boogieIcfgLocation, boogieIcfgLocation2, bl, bl2, list, simplificationTechnique);
        for (CodeBlock codeBlock : list) {
            codeBlock.disconnectSource();
            codeBlock.disconnectTarget();
            ModelUtils.copyAnnotations((IElement)codeBlock, (IElement)sequentialComposition);
        }
        return sequentialComposition;
    }

    public StatementSequence constructStatementSequence(BoogieIcfgLocation boogieIcfgLocation, BoogieIcfgLocation boogieIcfgLocation2, Statement statement) {
        return new StatementSequence(this.makeFreshSerial(), boogieIcfgLocation, boogieIcfgLocation2, statement, this.mLogger);
    }

    public StatementSequence constructStatementSequence(BoogieIcfgLocation boogieIcfgLocation, BoogieIcfgLocation boogieIcfgLocation2, List<Statement> list) {
        return new StatementSequence(this.makeFreshSerial(), boogieIcfgLocation, boogieIcfgLocation2, list, this.mLogger);
    }

    public Summary constructSummary(BoogieIcfgLocation boogieIcfgLocation, BoogieIcfgLocation boogieIcfgLocation2, CallStatement callStatement, boolean bl) {
        return new Summary(this.makeFreshSerial(), boogieIcfgLocation, boogieIcfgLocation2, callStatement, bl, this.mLogger);
    }

    private int makeFreshSerial() {
        return this.mSerialProvider.getFreshSerial();
    }

    public CodeBlock copyCodeBlock(CodeBlock codeBlock, BoogieIcfgLocation boogieIcfgLocation, BoogieIcfgLocation boogieIcfgLocation2) {
        if (codeBlock instanceof Call) {
            Call call = this.constructCall(boogieIcfgLocation, boogieIcfgLocation2, ((Call)codeBlock).getCallStatement());
            call.setTransitionFormula(codeBlock.getTransformula());
            return call;
        }
        if (codeBlock instanceof Return) {
            Return return_ = this.constructReturn(boogieIcfgLocation, boogieIcfgLocation2, ((Return)codeBlock).getCorrespondingCall());
            return_.setTransitionFormula(codeBlock.getTransformula());
            return return_;
        }
        if (codeBlock instanceof StatementSequence) {
            List<Statement> list = ((StatementSequence)codeBlock).getStatements();
            StatementSequence statementSequence = this.constructStatementSequence(boogieIcfgLocation, boogieIcfgLocation2, list);
            statementSequence.setTransitionFormula(codeBlock.getTransformula());
            return statementSequence;
        }
        if (codeBlock instanceof Summary) {
            CallStatement callStatement = ((Summary)codeBlock).getCallStatement();
            boolean bl = ((Summary)codeBlock).calledProcedureHasImplementation();
            Summary summary = this.constructSummary(boogieIcfgLocation, boogieIcfgLocation2, callStatement, bl);
            summary.setTransitionFormula(codeBlock.getTransformula());
            return summary;
        }
        if (codeBlock instanceof GotoEdge) {
            return this.constructGotoEdge(boogieIcfgLocation, boogieIcfgLocation2);
        }
        throw new UnsupportedOperationException("unsupported kind of CodeBlock: " + ((Object)((Object)codeBlock)).getClass().getSimpleName());
    }

    public void destroy() {
    }

    public static CodeBlockFactory getFactory(IToolchainStorage iToolchainStorage) {
        return (CodeBlockFactory)iToolchainStorage.getStorable(CodeBlockFactory.class.getName());
    }

    public void storeFactory(IToolchainStorage iToolchainStorage) {
        iToolchainStorage.putStorable(CodeBlockFactory.class.getName(), (IStorable)this);
    }

    @Deprecated
    public CfgSmtToolkit getToolkit() {
        return this.mMgvManager;
    }
}

