/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.Options;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata.IBuchiNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata.StateNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement.BuchiNwaComplement;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement.IStateNwaComplement;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement.NCSB;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement.SuccessorGenerator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement.SuccessorResult;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntIterator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntSet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.UtilIntSet;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;

public class StateNwaNCSB
extends StateNwa
implements IStateNwaComplement {
    private final BuchiNwaComplement mComplement;
    private final IBuchiNwa mOperand;
    private final NCSB mNCSB;

    public StateNwaNCSB(BuchiNwaComplement buchiNwaComplement, int n, NCSB nCSB) {
        super(buchiNwaComplement, n);
        this.mComplement = buchiNwaComplement;
        this.mOperand = buchiNwaComplement.getOperand();
        this.mNCSB = nCSB;
    }

    public NCSB getNCSB() {
        return this.mNCSB;
    }

    @Override
    public IBuchiNwa getOperand() {
        return this.mOperand;
    }

    @Override
    public IBuchiNwa getComplement() {
        return this.mComplement;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StateNwaNCSB stateNwaNCSB = (StateNwaNCSB)object;
        return this.mNCSB.equals(stateNwaNCSB.mNCSB);
    }

    private SuccessorResult computeSuccDoubleDeckers_CallOrInternal(IntSet intSet, int n, boolean bl) {
        IntIterator intIterator = intSet.iterator();
        SuccessorResult successorResult = new SuccessorResult();
        while (intIterator.hasNext()) {
            int n2 = intIterator.next();
            int n3 = this.mComplement.getDownState(n2);
            int n4 = this.mComplement.getUpState(n2);
            IntSet intSet2 = null;
            IntSet intSet3 = null;
            boolean bl2 = this.mComplement.getAlphabetInternal().get(n);
            if (bl2) {
                intSet2 = this.mOperand.getSuccessorsInternal(n4, n);
                intSet3 = this.mComplement.generateDeckers(n3, intSet2);
            } else {
                intSet2 = this.mOperand.getSuccessorsCall(n4, n);
                intSet3 = this.mComplement.generateDeckers(n4, intSet2);
            }
            if (bl && this.noTransitionAssertion_MinusF(n4, intSet2)) {
                successorResult.hasSuccessor = false;
                return successorResult;
            }
            successorResult.mSuccs.or(intSet3);
            if (!bl) continue;
            if (this.mOperand.isFinal(n4)) {
                successorResult.mInterFSuccs.or(intSet3);
                continue;
            }
            successorResult.mMinusFSuccs.or(intSet3);
        }
        return successorResult;
    }

    private IntSet computeSuccessors(NCSB nCSB, IntSet intSet, IntSet intSet2, int n, int n2) {
        if (nCSB.getSSet().overlap(this.mComplement.getFinalDeckers()) || intSet.overlap(nCSB.getSSet())) {
            return UtilIntSet.newIntSet();
        }
        SuccessorGenerator successorGenerator = new SuccessorGenerator(this.mNCSB.getBSet().isEmpty(), nCSB, intSet, intSet2, this.mComplement.getFinalDeckers());
        IntSet intSet3 = UtilIntSet.newIntSet();
        while (successorGenerator.hasNext()) {
            NCSB nCSB2 = successorGenerator.next();
            if (nCSB2 == null) continue;
            StateNwaNCSB stateNwaNCSB = this.mComplement.addState(nCSB2);
            if (this.mComplement.getAlphabetInternal().get(n2)) {
                super.addSuccessorInternal(n2, stateNwaNCSB.getId());
            } else if (this.mComplement.getAlphabetCall().get(n2)) {
                super.addSuccessorCall(n2, stateNwaNCSB.getId());
            } else {
                super.addSuccessorReturn(n, n2, stateNwaNCSB.getId());
            }
            intSet3.set(stateNwaNCSB.getId());
        }
        return intSet3;
    }

    private IntSet computeSuccCallOrInternal(int n) {
        IntSet intSet = UtilIntSet.newIntSet();
        IntSet intSet2 = UtilIntSet.newIntSet();
        SuccessorResult successorResult = this.computeSuccDoubleDeckers_CallOrInternal(this.mNCSB.getBSet(), n, true);
        if (!successorResult.hasSuccessor) {
            return UtilIntSet.newIntSet();
        }
        IntSet intSet3 = successorResult.mSuccs;
        intSet.or(successorResult.mMinusFSuccs);
        intSet2.or(successorResult.mInterFSuccs);
        IntSet intSet4 = this.mNCSB.copyCSet();
        intSet4.andNot(this.mNCSB.getBSet());
        successorResult = this.computeSuccDoubleDeckers_CallOrInternal(intSet4, n, !Options.lazyS);
        if (!successorResult.hasSuccessor) {
            return UtilIntSet.newIntSet();
        }
        IntSet intSet5 = successorResult.mSuccs;
        intSet5.or(intSet3);
        intSet.or(successorResult.mMinusFSuccs);
        intSet2.or(successorResult.mInterFSuccs);
        successorResult = this.computeSuccDoubleDeckers_CallOrInternal(this.mNCSB.getNSet(), n, false);
        IntSet intSet6 = successorResult.mSuccs;
        successorResult = this.computeSuccDoubleDeckers_CallOrInternal(this.mNCSB.getSSet(), n, false);
        IntSet intSet7 = successorResult.mSuccs;
        return this.computeSuccessors(new NCSB(intSet6, intSet5, intSet7, intSet3), intSet, intSet2, -1, n);
    }

    @Override
    public IntSet getSuccessorsInternal(int n) {
        assert (this.mComplement.getAlphabetInternal().get(n));
        if (super.getEnabledLettersInternal().contains(n)) {
            return super.getSuccessorsInternal(n);
        }
        return this.computeSuccCallOrInternal(n);
    }

    private boolean noTransitionAssertion_MinusF(int n, IntSet intSet) {
        return !this.mOperand.isFinal(n) && intSet.isEmpty();
    }

    @Override
    public IntSet getSuccessorsCall(int n) {
        assert (this.mComplement.getAlphabetCall().get(n));
        if (super.getEnabledLettersCall().contains(n)) {
            return super.getSuccessorsCall(n);
        }
        return this.computeSuccCallOrInternal(n);
    }

    private IntSet computeSuccReturn(int n, int n2) {
        StateNwaNCSB stateNwaNCSB = (StateNwaNCSB)this.mComplement.getState(n);
        NCSB nCSB = stateNwaNCSB.getNCSB();
        IntSet intSet = UtilIntSet.newIntSet();
        IntSet intSet2 = UtilIntSet.newIntSet();
        TIntObjectMap<List<Integer>> tIntObjectMap = this.doubleDeckerSetToMap(nCSB);
        SuccessorResult successorResult = this.computeSuccDoubleDeckers_Return(this.mNCSB.getBSet(), tIntObjectMap, n2, true);
        if (!successorResult.hasSuccessor) {
            return UtilIntSet.newIntSet();
        }
        IntSet intSet3 = successorResult.mSuccs;
        intSet.or(successorResult.mMinusFSuccs);
        intSet2.or(successorResult.mInterFSuccs);
        IntSet intSet4 = this.mNCSB.getCSet().clone();
        intSet4.andNot(this.mNCSB.getBSet());
        successorResult = this.computeSuccDoubleDeckers_Return(intSet4, tIntObjectMap, n2, !Options.lazyS);
        if (!successorResult.hasSuccessor) {
            return UtilIntSet.newIntSet();
        }
        IntSet intSet5 = successorResult.mSuccs;
        intSet5.or(intSet3);
        intSet.or(successorResult.mMinusFSuccs);
        intSet2.or(successorResult.mInterFSuccs);
        successorResult = this.computeSuccDoubleDeckers_Return(this.mNCSB.getNSet(), tIntObjectMap, n2, false);
        if (!successorResult.hasSuccessor) {
            return UtilIntSet.newIntSet();
        }
        IntSet intSet6 = successorResult.mSuccs;
        successorResult = this.computeSuccDoubleDeckers_Return(this.mNCSB.getSSet(), tIntObjectMap, n2, false);
        if (!successorResult.hasSuccessor) {
            return UtilIntSet.newIntSet();
        }
        IntSet intSet7 = successorResult.mSuccs;
        return this.computeSuccessors(new NCSB(intSet6, intSet5, intSet7, intSet3), intSet, intSet2, n, n2);
    }

    @Override
    public IntSet getSuccessorsReturn(int n, int n2) {
        assert (this.mComplement.getAlphabetReturn().get(n2));
        if (super.getEnabledLettersReturn().contains(n2) && super.getEnabledHiersReturn(n2).contains(n)) {
            return super.getSuccessorsReturn(n, n2);
        }
        return this.computeSuccReturn(n, n2);
    }

    private SuccessorResult computeSuccDoubleDeckers_Return(IntSet intSet, TIntObjectMap<List<Integer>> tIntObjectMap, int n, boolean bl) {
        SuccessorResult successorResult = new SuccessorResult();
        for (int n2 : intSet.iterable()) {
            int n3 = this.mComplement.getDownState(n2);
            int n4 = this.mComplement.getUpState(n2);
            if (!tIntObjectMap.containsKey(n3)) {
                successorResult.hasSuccessor = false;
                return successorResult;
            }
            IntSet intSet2 = this.mOperand.getSuccessorsReturn(n4, n3, n);
            if (bl && this.noTransitionAssertion_MinusF(n4, intSet2)) {
                successorResult.hasSuccessor = false;
                return successorResult;
            }
            List list = (List)tIntObjectMap.get(n3);
            for (Integer n5 : list) {
                IntSet intSet3 = this.mComplement.generateDeckers(n5, intSet2);
                successorResult.mSuccs.or(intSet3);
                if (!bl) continue;
                if (this.mOperand.isFinal(n4)) {
                    successorResult.mInterFSuccs.or(intSet3);
                    continue;
                }
                successorResult.mMinusFSuccs.or(intSet3);
            }
        }
        return successorResult;
    }

    private TIntObjectMap<List<Integer>> doubleDeckerSetToMap(NCSB nCSB) {
        IntSet intSet = nCSB.copyNSet();
        intSet.or(nCSB.getCSet());
        intSet.or(nCSB.getSSet());
        return this.doubleDeckerSetToMap(intSet, false);
    }

    private TIntObjectMap<List<Integer>> doubleDeckerSetToMap(IntSet intSet, boolean bl) {
        TIntObjectHashMap tIntObjectHashMap = new TIntObjectHashMap();
        for (int n : intSet.iterable()) {
            int n2 = this.mComplement.getDownState(n);
            int n3 = this.mComplement.getUpState(n);
            List list = null;
            int n4 = bl ? n2 : n3;
            int n5 = !bl ? n2 : n3;
            list = tIntObjectHashMap.containsKey(n4) ? (List)tIntObjectHashMap.get(n4) : new ArrayList();
            list.add(n5);
            tIntObjectHashMap.put(n4, list);
        }
        return tIntObjectHashMap;
    }

    @Override
    public String toString() {
        return "(" + this.outputSet(this.mNCSB.getNSet()) + "," + this.outputSet(this.mNCSB.getCSet()) + "," + this.outputSet(this.mNCSB.getSSet()) + "," + this.outputSet(this.mNCSB.getBSet()) + ")";
    }

    private String outputSet(IntSet intSet) {
        IntIterator intIterator = intSet.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        boolean bl = true;
        while (intIterator.hasNext()) {
            if (!bl) {
                stringBuilder.append(",");
            }
            bl = false;
            stringBuilder.append(this.mComplement.getDoubleDecker(intIterator.next()).toString());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        return this.mNCSB.hashCode();
    }
}

