/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EqualityManager;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.TTSubstitution;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class TermTuple {
    public final int arity;
    public final Term[] terms;

    private TermTuple(Term[] termArray, int n) {
        this.terms = termArray;
        this.arity = n;
    }

    public TermTuple(Term[] termArray) {
        this(termArray, termArray.length);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TermTuple)) {
            return false;
        }
        TermTuple termTuple = (TermTuple)object;
        if (termTuple.arity != this.arity) {
            return false;
        }
        int n = 0;
        while (n < this.arity) {
            if (!termTuple.terms[n].equals(this.terms[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        return HashUtils.hashJenkins((int)31, (Object[])this.terms);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        String string = "";
        Term[] termArray = this.terms;
        int n = this.terms.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray[n2];
            stringBuilder.append(string + term.toString());
            string = ", ";
            ++n2;
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public TTSubstitution match(TermTuple termTuple, EqualityManager equalityManager) {
        return this.match(termTuple, new TTSubstitution(), equalityManager);
    }

    public TTSubstitution match(TermTuple termTuple, TTSubstitution tTSubstitution, EqualityManager equalityManager) {
        assert (this.arity == termTuple.arity);
        TermTuple termTuple2 = tTSubstitution.apply(new TermTuple(this.terms));
        TermTuple termTuple3 = tTSubstitution.apply(new TermTuple(termTuple.terms));
        TTSubstitution tTSubstitution2 = tTSubstitution;
        int n = 0;
        while (n < this.terms.length) {
            Term term = termTuple2.terms[n];
            Term term2 = termTuple3.terms[n];
            TermVariable termVariable = null;
            Term term3 = null;
            if (!term.equals(term2)) {
                if (term2 instanceof TermVariable) {
                    termVariable = (TermVariable)term2;
                    term3 = term;
                } else if (term instanceof TermVariable) {
                    termVariable = (TermVariable)term;
                    term3 = term2;
                }
                if (termVariable == null) {
                    ArrayList<CCEquality> arrayList = equalityManager.isEqual((ApplicationTerm)term, (ApplicationTerm)term2);
                    if (arrayList == null) {
                        return null;
                    }
                    tTSubstitution2.addEquality(term, term2, arrayList);
                    assert (false) : "TODO: rework/rethink equality handling (now that we switched to CDCL..)";
                } else {
                    tTSubstitution2.addSubs(term3, termVariable);
                }
                termTuple2 = tTSubstitution2.apply(termTuple2);
                termTuple3 = tTSubstitution2.apply(termTuple3);
            }
            ++n;
        }
        assert (tTSubstitution2.apply(this).equals(tTSubstitution2.apply(termTuple))) : "the returned substitution should be a unifier";
        return tTSubstitution2;
    }

    public boolean onlyContainsConstants() {
        boolean bl = true;
        Term[] termArray = this.terms;
        int n = this.terms.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray[n2];
            bl &= term.getFreeVars().length == 0;
            ++n2;
        }
        return bl;
    }

    public TermTuple applySubstitution(Map<TermVariable, Term> map) {
        Term[] termArray = new Term[this.terms.length];
        int n = 0;
        while (n < termArray.length) {
            termArray[n] = this.terms[n] instanceof TermVariable && map.containsKey(this.terms[n]) ? map.get(this.terms[n]) : this.terms[n];
            ++n;
        }
        assert (this.nonNull(termArray)) : "substitution created a null-entry";
        return new TermTuple(termArray);
    }

    private boolean nonNull(Term[] termArray) {
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            if (term == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public HashSet<TermVariable> getFreeVars() {
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        Term[] termArray = this.terms;
        int n = this.terms.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray[n2];
            if (term instanceof TermVariable) {
                hashSet.add((TermVariable)term);
            }
            ++n2;
        }
        return hashSet;
    }

    public HashSet<ApplicationTerm> getConstants() {
        HashSet<ApplicationTerm> hashSet = new HashSet<ApplicationTerm>();
        Term[] termArray = this.terms;
        int n = this.terms.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray[n2];
            if (term instanceof ApplicationTerm) {
                hashSet.add((ApplicationTerm)term);
            }
            ++n2;
        }
        return hashSet;
    }

    public boolean isGround() {
        return this.getFreeVars().size() == 0;
    }
}

