/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultIcfgSymbolTable
implements IIcfgSymbolTable {
    protected final Map<TermVariable, IProgramVar> mTermVariable2ProgramVar = new HashMap<TermVariable, IProgramVar>();
    protected final Map<FunctionSymbol, IProgramFunction> mFunSym2ProgramFunction = new HashMap<FunctionSymbol, IProgramFunction>();
    protected final Set<IProgramNonOldVar> mGlobals = new HashSet<IProgramNonOldVar>();
    protected final Set<IProgramConst> mConstants = new HashSet<IProgramConst>();
    protected final HashRelation<String, ILocalProgramVar> mLocals = new HashRelation();
    protected boolean mConstructionFinished = false;

    public DefaultIcfgSymbolTable() {
    }

    public DefaultIcfgSymbolTable(IIcfgSymbolTable iIcfgSymbolTable, Set<String> set) {
        for (IProgramConst object : iIcfgSymbolTable.getConstants()) {
            this.add(object);
        }
        for (IProgramNonOldVar iProgramNonOldVar : iIcfgSymbolTable.getGlobals()) {
            this.add(iProgramNonOldVar);
        }
        for (String string : set) {
            for (ILocalProgramVar iLocalProgramVar : iIcfgSymbolTable.getLocals(string)) {
                this.add(iLocalProgramVar);
            }
        }
        assert (this.checkGlobals());
    }

    @Override
    public IProgramVar getProgramVar(TermVariable termVariable) {
        return this.mTermVariable2ProgramVar.get(termVariable);
    }

    @Override
    public IProgramFunction getProgramFun(FunctionSymbol functionSymbol) {
        return this.mFunSym2ProgramFunction.get(functionSymbol);
    }

    @Override
    public Set<IProgramNonOldVar> getGlobals() {
        return Collections.unmodifiableSet(this.mGlobals);
    }

    @Override
    public Set<IProgramConst> getConstants() {
        return Collections.unmodifiableSet(this.mConstants);
    }

    @Override
    public Set<ILocalProgramVar> getLocals(String string) {
        Set set = this.mLocals.getImage((Object)string);
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.mLocals.getImage((Object)string));
    }

    public void addFun(IProgramFunction iProgramFunction) {
        this.mFunSym2ProgramFunction.put(iProgramFunction.getFunctionSymbol(), iProgramFunction);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(IProgramVarOrConst iProgramVarOrConst) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, unable to add new variables or constants.");
        }
        if (iProgramVarOrConst instanceof IProgramConst) {
            IProgramConst iProgramConst = (IProgramConst)iProgramVarOrConst;
            this.mConstants.add(iProgramConst);
            this.mFunSym2ProgramFunction.put(iProgramConst.getDefaultConstant().getFunction(), iProgramConst);
            return;
        } else {
            if (!(iProgramVarOrConst instanceof IProgramVar)) throw new AssertionError((Object)"unknown kind of variable");
            IProgramVar iProgramVar = (IProgramVar)iProgramVarOrConst;
            this.mTermVariable2ProgramVar.put(iProgramVar.getTermVariable(), iProgramVar);
            if (iProgramVar instanceof IProgramOldVar || iProgramVar.isOldvar()) {
                throw new IllegalArgumentException("cannot add oldvar, add nonoldvar instead: " + String.valueOf(iProgramVar));
            }
            if (iProgramVar instanceof ILocalProgramVar) {
                this.mLocals.addPair((Object)iProgramVar.getProcedure(), (Object)((ILocalProgramVar)iProgramVar));
                return;
            } else {
                if (!(iProgramVar instanceof IProgramNonOldVar)) throw new AssertionError((Object)"unknown kind of variable");
                IProgramNonOldVar iProgramNonOldVar = (IProgramNonOldVar)iProgramVar;
                this.mGlobals.add(iProgramNonOldVar);
                IProgramOldVar iProgramOldVar = iProgramNonOldVar.getOldVar();
                this.mTermVariable2ProgramVar.put(iProgramOldVar.getTermVariable(), iProgramOldVar);
                assert (Objects.equals(iProgramOldVar.getNonOldVar(), iProgramVar)) : "getNonOldVar() and getOldVar() should match, but do not! Oldvar: " + String.valueOf(iProgramOldVar) + " Var: " + String.valueOf(iProgramVar);
                return;
            }
        }
    }

    public void finishConstruction() {
        this.mConstructionFinished = true;
        assert (this.checkGlobals());
    }

    private boolean checkGlobals() {
        if (this.mTermVariable2ProgramVar.entrySet().stream().anyMatch(entry -> entry.getValue() == null)) {
            throw new AssertionError((Object)"Null entry in TermVar2ProgramVar");
        }
        Set set = this.mTermVariable2ProgramVar.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet());
        Set set2 = set.stream().filter(IProgramVar::isOldvar).collect(Collectors.toSet());
        Optional<IProgramOldVar> optional = set2.stream().map(iProgramVar -> (IProgramOldVar)iProgramVar).filter(iProgramOldVar -> !set.contains(iProgramOldVar.getNonOldVar())).findAny();
        if (optional.isPresent()) {
            throw new AssertionError((Object)("old var with no corresponding var: " + String.valueOf(optional.get())));
        }
        return true;
    }

    @Override
    public Set<ApplicationTerm> computeAllDefaultConstants() {
        LinkedHashSet<ApplicationTerm> linkedHashSet = new LinkedHashSet<ApplicationTerm>();
        this.mGlobals.stream().map(iProgramNonOldVar -> iProgramNonOldVar.getDefaultConstant()).forEachOrdered(linkedHashSet::add);
        this.mLocals.getSetOfPairs().stream().map(entry -> ((ILocalProgramVar)entry.getValue()).getDefaultConstant()).forEachOrdered(linkedHashSet::add);
        return linkedHashSet;
    }
}

