/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ITransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.EqualityAnalysisResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IEqualityAnalysisResultProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.MapEliminationSettings;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.MapEliminator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class MapEliminationTransformer
implements ITransformulaTransformer {
    private final IEqualityAnalysisResultProvider<IcfgLocation, IIcfg<?>> mEqualityProvider;
    private final Map<TransFormula, ModifiableTransFormula> mTransFormulas;
    private final Map<TransFormula, IcfgLocation> mSourceLocations;
    private final Map<TransFormula, IcfgLocation> mTargetLocations;
    private MapEliminator mMapEliminator = null;
    private final ManagedScript mManagedScript;
    private final ReplacementVarFactory mReplacementVarFactory;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final IIcfgSymbolTable mSymbolTable;
    private final MapEliminationSettings mSettings;

    public MapEliminationTransformer(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, ManagedScript managedScript, IIcfgSymbolTable iIcfgSymbolTable, ReplacementVarFactory replacementVarFactory, MapEliminationSettings mapEliminationSettings, IEqualityAnalysisResultProvider<IcfgLocation, IIcfg<?>> iEqualityAnalysisResultProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mSymbolTable = iIcfgSymbolTable;
        this.mSettings = mapEliminationSettings;
        this.mEqualityProvider = iEqualityAnalysisResultProvider;
        this.mTransFormulas = new HashMap<TransFormula, ModifiableTransFormula>();
        this.mSourceLocations = new HashMap<TransFormula, IcfgLocation>();
        this.mTargetLocations = new HashMap<TransFormula, IcfgLocation>();
        this.mManagedScript = Objects.requireNonNull(managedScript);
        this.mReplacementVarFactory = Objects.requireNonNull(replacementVarFactory);
    }

    @Override
    public void preprocessIcfg(IIcfg<?> iIcfg) {
        IcfgEdgeIterator icfgEdgeIterator = new IcfgEdgeIterator(iIcfg);
        while (icfgEdgeIterator.hasNext()) {
            IIcfgReturnTransition iIcfgReturnTransition;
            IcfgEdge icfgEdge = icfgEdgeIterator.next();
            IcfgLocation icfgLocation = icfgEdge.getSource();
            IcfgLocation icfgLocation2 = icfgEdge.getTarget();
            if (icfgEdge instanceof IIcfgReturnTransition) {
                iIcfgReturnTransition = (IIcfgReturnTransition)icfgEdge;
                this.saveTransformula((TransFormula)iIcfgReturnTransition.getAssignmentOfReturn(), icfgLocation, icfgLocation2);
                this.saveTransformula((TransFormula)iIcfgReturnTransition.getLocalVarsAssignmentOfCall(), icfgLocation, icfgLocation2);
                continue;
            }
            iIcfgReturnTransition = icfgEdge.getTransformula();
            this.saveTransformula((TransFormula)iIcfgReturnTransition, icfgLocation, icfgLocation2);
        }
        this.mMapEliminator = new MapEliminator(this.mServices, this.mLogger, this.mManagedScript, this.mSymbolTable, this.mReplacementVarFactory, this.mTransFormulas.values(), this.mSettings);
        this.mEqualityProvider.preprocess(iIcfg);
    }

    private void saveTransformula(TransFormula transFormula, IcfgLocation icfgLocation, IcfgLocation icfgLocation2) {
        ModifiableTransFormula modifiableTransFormula = ModifiableTransFormulaUtils.buildTransFormula((TransFormula)transFormula, (ReplacementVarFactory)this.mReplacementVarFactory, (ManagedScript)this.mManagedScript);
        this.mTransFormulas.put(transFormula, modifiableTransFormula);
        this.mSourceLocations.put(transFormula, icfgLocation);
        this.mTargetLocations.put(transFormula, icfgLocation2);
    }

    @Override
    public ITransformulaTransformer.TransformulaTransformationResult transform(IIcfgTransition<? extends IcfgLocation> iIcfgTransition, UnmodifiableTransFormula unmodifiableTransFormula) {
        ModifiableTransFormula modifiableTransFormula = this.mTransFormulas.get(unmodifiableTransFormula);
        EqualityAnalysisResult equalityAnalysisResult = this.mEqualityProvider.getAnalysisResult((Object)this.mSourceLocations.get(unmodifiableTransFormula), this.mMapEliminator.getDoubletons());
        EqualityAnalysisResult equalityAnalysisResult2 = this.mEqualityProvider.getAnalysisResult((Object)this.mTargetLocations.get(unmodifiableTransFormula), this.mMapEliminator.getDoubletons());
        ModifiableTransFormula modifiableTransFormula2 = this.mMapEliminator.eliminateMaps(modifiableTransFormula, equalityAnalysisResult, equalityAnalysisResult2);
        return new ITransformulaTransformer.TransformulaTransformationResult(TransFormulaBuilder.constructCopy((ManagedScript)this.mManagedScript, (TransFormula)modifiableTransFormula2, Collections.emptySet(), Collections.emptySet(), Collections.emptyMap()), true);
    }

    @Override
    public String getName() {
        return MapEliminationTransformer.class.getSimpleName();
    }

    @Override
    public IIcfgSymbolTable getNewIcfgSymbolTable() {
        return this.mReplacementVarFactory.constructIIcfgSymbolTable();
    }

    @Override
    public HashRelation<String, IProgramNonOldVar> getNewModifiedGlobals() {
        return this.mReplacementVarFactory.constructModifiableGlobalsTable().getProcToGlobals();
    }
}

