/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.simplifier;

import de.uni_freiburg.informatik.ultimate.util.simplifier.INormalFormable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class NormalFormTransformer<E> {
    private final INormalFormable<E> mWrapper;

    public NormalFormTransformer(INormalFormable<E> iNormalFormable) {
        this.mWrapper = iNormalFormable;
    }

    public E toNnf(E e) {
        if (e == null) {
            return null;
        }
        if (this.mWrapper.isAtom(e)) {
            return e;
        }
        if (this.mWrapper.isLiteral(e)) {
            if (!this.mWrapper.isNot(e)) {
                return e;
            }
            E e2 = this.mWrapper.getOperand(e);
            if (this.mWrapper.isTrue(e2)) {
                return this.mWrapper.makeFalse();
            }
            if (this.mWrapper.isFalse(e2)) {
                return this.mWrapper.makeTrue();
            }
            return e;
        }
        E e3 = e;
        e3 = this.makeNnf(e3);
        e3 = this.simplify(e3);
        return e3;
    }

    public E toDnf(E e) {
        if (e == null) {
            return null;
        }
        if (this.mWrapper.isAtom(e)) {
            return e;
        }
        E e2 = e;
        e2 = this.makeNnf(e2);
        e2 = this.simplify(e2);
        e2 = this.skolemize(e2);
        e2 = this.makeDnf(e2);
        e2 = this.simplifyDnf(e2);
        return e2;
    }

    public E rewriteNotEquals(E e) {
        if (e == null) {
            return null;
        }
        E e2 = this.toNnf(e);
        if (this.mWrapper.isAtom(e2)) {
            return this.mWrapper.rewritePredNotEquals(e2);
        }
        if (this.mWrapper.isLiteral(e2)) {
            return e2;
        }
        if (this.mWrapper.isNot(e2)) {
            E e3;
            E e4 = this.mWrapper.getOperand(e2);
            if (e4 == (e3 = this.mWrapper.negatePred(e4))) {
                return e2;
            }
            return this.mWrapper.rewritePredNotEquals(e3);
        }
        if (this.mWrapper.isAnd(e2)) {
            ArrayDeque<E> arrayDeque = new ArrayDeque<E>();
            Iterator<E> iterator = this.mWrapper.getOperands(e2);
            while (iterator.hasNext()) {
                E e5 = this.rewriteNotEquals(iterator.next());
                iterator.remove();
                arrayDeque.addFirst(e5);
            }
            return this.mWrapper.makeAnd(arrayDeque.iterator());
        }
        if (this.mWrapper.isOr(e2)) {
            ArrayDeque<E> arrayDeque = new ArrayDeque<E>();
            Iterator<E> iterator = this.mWrapper.getOperands(e2);
            while (iterator.hasNext()) {
                E e6 = this.rewriteNotEquals(iterator.next());
                iterator.remove();
                arrayDeque.addFirst(e6);
            }
            return this.mWrapper.makeOr(arrayDeque.iterator());
        }
        throw new UnsupportedOperationException();
    }

    public Collection<E> toDnfDisjuncts(E e) {
        E e2 = this.toDnf(e);
        if (e2 == null) {
            return null;
        }
        if (!this.mWrapper.isOr(e2)) {
            return Collections.singleton(e2);
        }
        return this.toTermsTopLevel(e2);
    }

    public E simplify(E e) {
        if (this.mWrapper.isAnd(e) || this.mWrapper.isOr(e)) {
            return this.simplifyAndOr(e);
        }
        return e;
    }

    private Collection<E> toTermsTopLevel(E e) {
        if (e == null) {
            return null;
        }
        ArrayList<E> arrayList = new ArrayList<E>();
        Iterator<E> iterator = this.mWrapper.getOperands(e);
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    private E simplifyDnf(E e) {
        E e2 = this.simplify(e);
        if (!this.mWrapper.isOr(e2)) {
            return e2;
        }
        LinkedHashSet<E> linkedHashSet = this.getSet(this.mWrapper.getOperands(e2));
        Iterator<E> iterator = this.mWrapper.getOperands(e2);
        while (iterator.hasNext()) {
            E e3 = iterator.next();
            linkedHashSet.remove(e3);
            boolean bl = true;
            for (Object e4 : linkedHashSet) {
                if (!this.isSubformula(e3, e4)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            linkedHashSet.add(e3);
        }
        return this.mWrapper.makeOr(linkedHashSet.iterator());
    }

    private boolean isSubformula(E e, E e2) {
        if (this.mWrapper.isEqual(e, e2)) {
            return true;
        }
        if (this.mWrapper.isAtom(e)) {
            return false;
        }
        if (this.mWrapper.isAtom(e2) || this.mWrapper.isNot(e2) && this.mWrapper.isAtom(this.mWrapper.getOperand(e2)) ? this.isOperandSubset(e, e2) : (this.mWrapper.isAnd(e) && this.mWrapper.isAnd(e2) ? this.isOperandSubset(e, e2) : this.mWrapper.isOr(e) && this.mWrapper.isOr(e2) && this.isOperandSubset(e, e2))) {
            return true;
        }
        Iterator<E> iterator = this.mWrapper.getOperands(e);
        while (iterator.hasNext()) {
            if (!this.isSubformula(iterator.next(), e2)) continue;
            return true;
        }
        return false;
    }

    private boolean isOperandSubset(E e, E e2) {
        LinkedHashSet<E> linkedHashSet = this.getSet(this.mWrapper.getOperands(e));
        Iterator<E> iterator = this.mWrapper.getOperands(e2);
        boolean bl = true;
        while (iterator.hasNext()) {
            if (linkedHashSet.contains(iterator.next())) continue;
            bl = false;
        }
        return bl;
    }

    private LinkedHashSet<E> getSet(Iterator<E> iterator) {
        LinkedHashSet<E> linkedHashSet = new LinkedHashSet<E>();
        while (iterator.hasNext()) {
            linkedHashSet.add(iterator.next());
        }
        return linkedHashSet;
    }

    private E skolemize(E e) {
        return e;
    }

    private E makeDnf(E e) {
        if (this.mWrapper.isAtom(e)) {
            return e;
        }
        if (this.mWrapper.isNot(e)) {
            if (this.mWrapper.isAtom(this.mWrapper.getOperand(e))) {
                return e;
            }
            throw new AssertionError((Object)"Input not in NNF");
        }
        if (this.mWrapper.isAnd(e)) {
            E e2;
            ArrayDeque<E> arrayDeque = new ArrayDeque<E>();
            Iterator<E> iterator = this.mWrapper.getOperands(e);
            while (iterator.hasNext()) {
                e2 = this.makeDnf(iterator.next());
                iterator.remove();
                arrayDeque.add(e2);
            }
            while (!arrayDeque.isEmpty()) {
                Object e3;
                E e4;
                Iterator<E> iterator2;
                ArrayList<E> arrayList;
                e2 = arrayDeque.removeLast();
                if (arrayDeque.isEmpty()) {
                    return e2;
                }
                Object e5 = arrayDeque.removeLast();
                if (this.mWrapper.isOr(e2)) {
                    if (this.mWrapper.isOr(e5)) {
                        arrayList = new ArrayList<E>();
                        iterator2 = this.mWrapper.getOperands(e2);
                        while (iterator2.hasNext()) {
                            Iterator<E> iterator3 = this.mWrapper.getOperands(e5);
                            E e6 = iterator2.next();
                            while (iterator3.hasNext()) {
                                arrayList.add(this.mWrapper.makeAnd(e6, iterator3.next()));
                                iterator3.remove();
                            }
                            iterator2.remove();
                        }
                        arrayDeque.addFirst(this.mWrapper.makeOr(arrayList.iterator()));
                        continue;
                    }
                    e4 = e2;
                    e3 = e5;
                } else if (this.mWrapper.isOr(e5)) {
                    e4 = e5;
                    e3 = e2;
                } else {
                    arrayDeque.addFirst(this.mWrapper.makeAnd(e2, e5));
                    continue;
                }
                arrayList = new ArrayList();
                iterator2 = this.mWrapper.getOperands(e4);
                while (iterator2.hasNext()) {
                    arrayList.add(this.mWrapper.makeAnd(iterator2.next(), e3));
                    iterator2.remove();
                }
                arrayDeque.addFirst(this.mWrapper.makeOr(arrayList.iterator()));
            }
            throw new AssertionError();
        }
        if (this.mWrapper.isOr(e)) {
            ArrayList<E> arrayList = new ArrayList<E>();
            Iterator<E> iterator = this.mWrapper.getOperands(e);
            while (iterator.hasNext()) {
                arrayList.add(this.makeDnf(iterator.next()));
            }
            return this.mWrapper.makeOr(arrayList.iterator());
        }
        if (this.mWrapper.isExists(e)) {
            return this.mWrapper.changeExists(e, this.makeDnf(this.mWrapper.getOperand(e)));
        }
        if (this.mWrapper.isForall(e)) {
            return this.mWrapper.changeForall(e, this.makeDnf(this.mWrapper.getOperand(e)));
        }
        throw new AssertionError();
    }

    private E makeNnf(E e) {
        if (this.mWrapper.isAtom(e)) {
            return e;
        }
        if (this.mWrapper.isNot(e)) {
            E e2 = this.mWrapper.getOperand(e);
            if (this.mWrapper.isTrue(e2)) {
                return this.mWrapper.makeFalse();
            }
            if (this.mWrapper.isFalse(e2)) {
                return this.mWrapper.makeTrue();
            }
            if (this.mWrapper.isAtom(e2)) {
                return e;
            }
            if (this.mWrapper.isNot(e2)) {
                return this.makeNnf(this.mWrapper.getOperand(e2));
            }
            if (this.mWrapper.isOr(e2)) {
                ArrayDeque<E> arrayDeque = new ArrayDeque<E>();
                Iterator<E> iterator = this.mWrapper.getOperands(e2);
                while (iterator.hasNext()) {
                    arrayDeque.add(this.makeNnf(this.mWrapper.makeNot(iterator.next())));
                }
                return this.mWrapper.makeAnd(arrayDeque.iterator());
            }
            if (this.mWrapper.isAnd(e2)) {
                ArrayDeque<E> arrayDeque = new ArrayDeque<E>();
                Iterator<E> iterator = this.mWrapper.getOperands(e2);
                while (iterator.hasNext()) {
                    arrayDeque.add(this.makeNnf(this.mWrapper.makeNot(iterator.next())));
                }
                return this.mWrapper.makeOr(arrayDeque.iterator());
            }
            if (this.mWrapper.isForall(e2)) {
                return this.mWrapper.changeExists(e2, this.makeNnf(this.mWrapper.makeNot(this.mWrapper.getOperand(e2))));
            }
            if (this.mWrapper.isExists(e2)) {
                return this.mWrapper.changeForall(e2, this.makeNnf(this.mWrapper.makeNot(this.mWrapper.getOperand(e2))));
            }
            throw new AssertionError();
        }
        if (this.mWrapper.isOr(e)) {
            ArrayDeque<E> arrayDeque = new ArrayDeque<E>();
            Iterator<E> iterator = this.mWrapper.getOperands(e);
            while (iterator.hasNext()) {
                arrayDeque.add(this.makeNnf(iterator.next()));
            }
            return this.mWrapper.makeOr(arrayDeque.iterator());
        }
        if (this.mWrapper.isAnd(e)) {
            ArrayDeque<E> arrayDeque = new ArrayDeque<E>();
            Iterator<E> iterator = this.mWrapper.getOperands(e);
            while (iterator.hasNext()) {
                arrayDeque.add(this.makeNnf(iterator.next()));
            }
            return this.mWrapper.makeAnd(arrayDeque.iterator());
        }
        if (this.mWrapper.isForall(e)) {
            return this.mWrapper.changeForall(e, this.makeNnf(this.mWrapper.getOperand(e)));
        }
        if (this.mWrapper.isExists(e)) {
            return this.mWrapper.changeExists(e, this.makeNnf(this.mWrapper.getOperand(e)));
        }
        throw new AssertionError();
    }

    private E simplifyAndOr(E e) {
        E e2;
        E e3;
        E e4 = this.mWrapper.makeTrue();
        E e5 = this.mWrapper.makeFalse();
        boolean bl = this.mWrapper.isAnd(e);
        if (bl) {
            e3 = e4;
            e2 = e5;
        } else {
            e3 = e5;
            e2 = e4;
        }
        LinkedHashSet<E> linkedHashSet = new LinkedHashSet<E>();
        Iterator<E> iterator = this.mWrapper.getOperands(e);
        while (iterator.hasNext()) {
            E e6 = iterator.next();
            if (this.mWrapper.isEqual(e6, e3)) continue;
            if (this.mWrapper.isEqual(e6, e2)) {
                return e6;
            }
            linkedHashSet.addAll(this.mWrapper.normalizeNesting(e, e6));
        }
        if (linkedHashSet.size() <= 1) {
            if (linkedHashSet.isEmpty()) {
                return e3;
            }
            return linkedHashSet.iterator().next();
        }
        if (bl) {
            return this.mWrapper.makeAnd(linkedHashSet.iterator());
        }
        return this.mWrapper.makeOr(linkedHashSet.iterator());
    }
}

