/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.mcr;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.mcr.IInterpolantProvider;
import de.uni_freiburg.informatik.ultimate.lib.mcr.McrUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IDomainSpecificOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermDomainOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndexEqualityManager;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelectOverNestedStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelectOverStoreEliminationUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ThreeValuedEquivalenceRelation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SpWpInterpolantProvider<LETTER extends IIcfgTransition<?>>
implements IInterpolantProvider<LETTER> {
    private final ILogger mLogger;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final ArrayIndexEqualityManager mAiem;
    private final ManagedScript mManagedScript;
    private final IUltimateServiceProvider mServices;
    private final IPredicateUnifier mPredicateUnifier;
    protected final PredicateTransformer<Term, IPredicate, TransFormula> mPredicateTransformer;
    protected final Script mScript;

    public SpWpInterpolantProvider(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, ManagedScript managedScript, SmtUtils.SimplificationTechnique simplificationTechnique, IPredicateUnifier iPredicateUnifier) {
        this.mManagedScript = managedScript;
        this.mScript = managedScript.getScript();
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mSimplificationTechnique = simplificationTechnique;
        this.mPredicateUnifier = iPredicateUnifier;
        this.mPredicateTransformer = new PredicateTransformer(this.mManagedScript, (IDomainSpecificOperationProvider)new TermDomainOperationProvider(this.mServices, this.mManagedScript));
        this.mAiem = new ArrayIndexEqualityManager(new ThreeValuedEquivalenceRelation(), this.mScript.term("true", new Term[0]), 0, this.mLogger, this.mManagedScript);
        this.mAiem.unlockSolver();
    }

    @Override
    public <STATE> void addInterpolants(INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, Map<STATE, IPredicate> map) {
        Term term;
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        HashMap<Object, Set<Object>> hashMap = new HashMap<Object, Set<Object>>();
        for (Map.Entry<STATE, IPredicate> object2 : map.entrySet()) {
            Object object = McrUtils.getTermVariables(object2.getValue().getVars());
            hashSet.addAll((Collection<TermVariable>)object);
            hashMap.put(object2.getKey(), (Set<Object>)object);
        }
        List<Object> list = McrUtils.reversedTopologicalOrdering(iNestedWordAutomaton, map::containsKey);
        for (Object object : list) {
            term = new HashSet();
            for (OutgoingInternalTransition outgoingInternalTransition : iNestedWordAutomaton.internalSuccessors(object)) {
                term.addAll(McrUtils.getTermVariables(((IIcfgTransition)outgoingInternalTransition.getLetter()).getTransformula().getInVars().keySet()));
                term.addAll((Collection)hashMap.get(outgoingInternalTransition.getSucc()));
            }
            term.retainAll(hashSet);
            hashMap.put(object, (Set<Object>)term);
        }
        if (!this.useReversedOrder()) {
            Collections.reverse(list);
        }
        for (Object object : list) {
            OutgoingInternalTransition outgoingInternalTransition;
            term = this.calculateTerm(iNestedWordAutomaton, object, map);
            outgoingInternalTransition = this.getPredicateWithAbstraction(term, (Set)hashMap.get(object));
            if (outgoingInternalTransition == null) continue;
            map.put(object, (IPredicate)outgoingInternalTransition);
        }
    }

    private IPredicate getPredicateWithAbstraction(Term term, Set<TermVariable> set) {
        Term term2 = McrUtils.abstractVariables(term, set, this.getQuantifier(), this.mManagedScript, this.mServices, this.mLogger, this.mSimplificationTechnique);
        if (!QuantifierUtils.isQuantifierFree((Term)term2)) {
            return null;
        }
        List list = MultiDimensionalSelectOverNestedStore.extractMultiDimensionalSelectOverNestedStore((Term)term2, (boolean)false);
        for (MultiDimensionalSelectOverNestedStore multiDimensionalSelectOverNestedStore : list) {
            term2 = MultiDimensionalSelectOverStoreEliminationUtils.replace((ManagedScript)this.mManagedScript, (ArrayIndexEqualityManager)this.mAiem, (Term)term2, (MultiDimensionalSelectOverNestedStore)multiDimensionalSelectOverNestedStore);
        }
        return this.mPredicateUnifier.getOrConstructPredicate(term2);
    }

    protected abstract <STATE> Term calculateTerm(INestedWordAutomaton<LETTER, STATE> var1, STATE var2, Map<STATE, IPredicate> var3);

    protected abstract boolean useReversedOrder();

    protected abstract int getQuantifier();
}

