/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.BinaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IStateDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEquivalent;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.PowersetDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.DeterminizedState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.DifferenceDD;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IDeterminizeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IIntersectionStateFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DifferenceSadd<LETTER, STATE>
extends BinaryNwaOperation<LETTER, STATE, INwaInclusionStateFactory<STATE>> {
    private final INestedWordAutomaton<LETTER, STATE> mMinuend;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mSubtrahend;
    private final NestedWordAutomaton<LETTER, STATE> mDifference;
    private final IStateDeterminizer<LETTER, STATE> mStateDeterminizer;
    private final Map<DifferenceState, STATE> mDiff2res = new HashMap<DifferenceState, STATE>();
    private final Map<STATE, DifferenceState> mRes2diff = new HashMap<STATE, DifferenceState>();
    private final Map<STATE, Set<STATE>> mVisited = new HashMap<STATE, Set<STATE>>();
    private final List<SummaryState> mWorklist = new LinkedList<SummaryState>();
    private final Map<STATE, Set<STATE>> mSummary = new HashMap<STATE, Set<STATE>>();
    private final STATE mAuxiliaryEmptyStackState;
    private final IIntersectionStateFactory<STATE> mContentFactory;

    public <SF extends IDeterminizeStateFactory<STATE> & IIntersectionStateFactory<STATE>> DifferenceSadd(AutomataLibraryServices automataLibraryServices, SF SF, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) throws AutomataLibraryException {
        this(automataLibraryServices, SF, iNestedWordAutomaton, iNwaOutgoingLetterAndTransitionProvider, new PowersetDeterminizer<LETTER, STATE>(iNwaOutgoingLetterAndTransitionProvider, true, SF));
    }

    public DifferenceSadd(AutomataLibraryServices automataLibraryServices, IIntersectionStateFactory<STATE> iIntersectionStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, IStateDeterminizer<LETTER, STATE> iStateDeterminizer) throws AutomataLibraryException {
        super(automataLibraryServices);
        if (!NestedWordAutomataUtils.sameAlphabet(iNestedWordAutomaton, iNwaOutgoingLetterAndTransitionProvider)) {
            throw new AutomataLibraryException(this.getClass(), "Unable to apply operation to automata with different alphabets.");
        }
        this.mContentFactory = iIntersectionStateFactory;
        this.mMinuend = iNestedWordAutomaton;
        this.mSubtrahend = iNwaOutgoingLetterAndTransitionProvider;
        this.mStateDeterminizer = iStateDeterminizer;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mDifference = new NestedWordAutomaton(this.mServices, iNestedWordAutomaton.getVpAlphabet(), iIntersectionStateFactory);
        this.mAuxiliaryEmptyStackState = this.mDifference.getEmptyStackState();
        this.computeDifference();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String startMessage() {
        return "Start " + this.getOperationName() + ". Minuend " + this.mMinuend.sizeInformation() + ". Subtrahend " + this.mSubtrahend.sizeInformation();
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Result " + this.mDifference.sizeInformation();
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getFirstOperand() {
        return this.mMinuend;
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getSecondOperand() {
        return this.mSubtrahend;
    }

    @Override
    public INestedWordAutomaton<LETTER, STATE> getResult() {
        return this.mDifference;
    }

    public boolean wasVisited(STATE STATE, STATE STATE2) {
        Set<STATE> set = this.mVisited.get(STATE2);
        if (set == null) {
            return false;
        }
        return set.contains(STATE);
    }

    public void markVisited(STATE STATE, STATE STATE2) {
        Set<STATE> set = this.mVisited.get(STATE2);
        if (set == null) {
            set = new HashSet<STATE>();
            this.mVisited.put(STATE2, set);
        }
        set.add(STATE);
    }

    public void enqueueAndMark(STATE STATE, STATE STATE2) {
        if (!this.wasVisited(STATE, STATE2)) {
            this.markVisited(STATE, STATE2);
            SummaryState summaryState = new SummaryState(STATE2, STATE);
            this.mWorklist.add(summaryState);
        }
    }

    public void addSummary(STATE STATE, STATE STATE2) {
        Set<STATE> set = this.mSummary.get(STATE);
        if (set == null) {
            set = new HashSet<STATE>();
            this.mSummary.put(STATE, set);
        }
        set.add(STATE2);
    }

    private Set<STATE> getKnownCallerStates(STATE STATE) {
        Set<STATE> set = this.mVisited.get(STATE);
        if (set == null) {
            return new HashSet(0);
        }
        return set;
    }

    public void computeDifference() {
        DeterminizedState<LETTER, STATE> determinizedState = this.mStateDeterminizer.initialState();
        for (Object object : this.mMinuend.getInitialStates()) {
            DifferenceState differenceState = new DifferenceState(object, determinizedState);
            STATE STATE = this.mContentFactory.intersection(differenceState.mMinuendState, this.mStateDeterminizer.getState(differenceState.mSubtrahendDeterminizedState));
            this.mDifference.addState(true, differenceState.isFinal(), STATE);
            this.mDiff2res.put(differenceState, STATE);
            this.mRes2diff.put(STATE, differenceState);
            this.enqueueAndMark(this.mAuxiliaryEmptyStackState, STATE);
        }
        while (!this.mWorklist.isEmpty()) {
            Object object;
            object = this.mWorklist.remove(0);
            this.processSummaryState((SummaryState)object);
            if (!this.mSummary.containsKey(((SummaryState)object).mPresentState)) continue;
            for (Iterator iterator : this.mSummary.get(((SummaryState)object).mPresentState)) {
                this.enqueueAndMark(((SummaryState)object).getCallerState(), iterator);
            }
        }
    }

    private void processSummaryState(SummaryState summaryState) {
        Object object;
        Object object2;
        Object object3;
        DeterminizedState<LETTER, STATE> determinizedState;
        Object STATE = summaryState.getPresentState();
        DifferenceState differenceState = this.mRes2diff.get(STATE);
        Object STATE2 = differenceState.getMinuendState();
        DeterminizedState determinizedState2 = differenceState.getSubtrahendDeterminizedState();
        for (Object LETTER : this.mMinuend.lettersInternal(STATE2)) {
            if (!this.mSubtrahend.getVpAlphabet().getInternalAlphabet().contains(LETTER)) continue;
            determinizedState = this.mStateDeterminizer.internalSuccessor(determinizedState2, LETTER);
            for (OutgoingInternalTransition object4 : this.mMinuend.internalSuccessors(STATE2, LETTER)) {
                object3 = object4.getSucc();
                object2 = new DifferenceState(object3, determinizedState);
                object = this.getResState((DifferenceState)object2);
                this.mDifference.addInternalTransition(STATE, LETTER, object);
                this.enqueueAndMark(summaryState.getCallerState(), object);
            }
        }
        for (Object LETTER : this.mMinuend.lettersCall(STATE2)) {
            if (!this.mSubtrahend.getVpAlphabet().getCallAlphabet().contains(LETTER)) continue;
            determinizedState = this.mStateDeterminizer.callSuccessor(determinizedState2, LETTER);
            for (OutgoingCallTransition outgoingCallTransition : this.mMinuend.callSuccessors(STATE2, LETTER)) {
                object3 = outgoingCallTransition.getSucc();
                object2 = new DifferenceState(object3, determinizedState);
                object = this.getResState((DifferenceState)object2);
                this.mDifference.addCallTransition(STATE, LETTER, object);
                this.enqueueAndMark(STATE, object);
            }
        }
        for (Object LETTER : this.mMinuend.lettersReturn(STATE2)) {
            if (!this.mSubtrahend.getVpAlphabet().getReturnAlphabet().contains(LETTER) || (determinizedState = summaryState.getCallerState()) == this.mAuxiliaryEmptyStackState) continue;
            DifferenceState differenceState2 = this.mRes2diff.get(determinizedState);
            Iterator iterator = differenceState2.getMinuendState();
            object3 = differenceState2.getSubtrahendDeterminizedState();
            object2 = this.mMinuend.returnSuccessors(STATE2, iterator, LETTER);
            object = this.mStateDeterminizer.returnSuccessor(determinizedState2, object3, LETTER);
            Iterator iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                OutgoingReturnTransition outgoingReturnTransition = (OutgoingReturnTransition)iterator2.next();
                Object STATE3 = outgoingReturnTransition.getSucc();
                DifferenceState differenceState3 = new DifferenceState(STATE3, object);
                STATE STATE4 = this.getResState(differenceState3);
                this.mDifference.addReturnTransition((DeterminizedState<LETTER, STATE>)STATE, determinizedState, LETTER, (DeterminizedState<LETTER, STATE>)STATE4);
                this.addSummary(determinizedState, STATE4);
                for (Object object4 : this.getKnownCallerStates(determinizedState)) {
                    this.enqueueAndMark(object4, STATE4);
                }
            }
        }
    }

    STATE getResState(DifferenceState differenceState) {
        if (this.mDiff2res.containsKey(differenceState)) {
            return this.mDiff2res.get(differenceState);
        }
        STATE STATE = this.mContentFactory.intersection(differenceState.mMinuendState, this.mStateDeterminizer.getState(differenceState.mSubtrahendDeterminizedState));
        this.mDifference.addState(false, differenceState.isFinal(), STATE);
        this.mDiff2res.put(differenceState, STATE);
        this.mRes2diff.put(STATE, differenceState);
        return STATE;
    }

    @Override
    public boolean checkResult(INwaInclusionStateFactory<STATE> iNwaInclusionStateFactory) throws AutomataLibraryException {
        boolean bl = true;
        if (this.mStateDeterminizer instanceof PowersetDeterminizer) {
            this.mLogger.info((Object)("Start testing correctness of " + this.getOperationName()));
            Object object = new DifferenceDD<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, this.mMinuend, this.mSubtrahend).getResult();
            bl = new IsEquivalent<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, object, this.mDifference).getResult();
            if (!bl) {
                this.mLogger.info((Object)("Finished testing correctness of " + this.getOperationName()));
            } else {
                this.mLogger.warn((Object)"Unable to test correctness if state determinizer is not the PowersetDeterminizer.");
            }
            AutomatonDefinitionPrinter.writeToFileIfPreferred(this.mServices, this.getOperationName() + "Failed", "language is different", this.mMinuend, this.mSubtrahend);
        }
        return bl;
    }

    private class DifferenceState {
        private static final int PRIME_1 = 3;
        private static final int PRIME_2 = 5;
        private final STATE mMinuendState;
        private final DeterminizedState<LETTER, STATE> mSubtrahendDeterminizedState;
        private final boolean mIsFinal;
        private final int mHashCode;

        public DifferenceState(STATE STATE, DeterminizedState<LETTER, STATE> determinizedState) {
            this.mMinuendState = STATE;
            this.mSubtrahendDeterminizedState = determinizedState;
            this.mIsFinal = DifferenceSadd.this.mMinuend.isFinal(STATE) && !determinizedState.containsFinal();
            this.mHashCode = 3 * STATE.hashCode() + 5 * determinizedState.hashCode();
        }

        public STATE getMinuendState() {
            return this.mMinuendState;
        }

        public DeterminizedState<LETTER, STATE> getSubtrahendDeterminizedState() {
            return this.mSubtrahendDeterminizedState;
        }

        public boolean isFinal() {
            return this.mIsFinal;
        }

        public boolean equals(Object object) {
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            DifferenceState differenceState = (DifferenceState)object;
            return differenceState.mMinuendState.equals(this.mMinuendState) && this.mSubtrahendDeterminizedState.equals(differenceState.mSubtrahendDeterminizedState);
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public String toString() {
            return "<[< " + this.mMinuendState.toString() + " , " + this.mSubtrahendDeterminizedState.toString() + ">]>";
        }
    }

    private class SummaryState {
        private static final int PRIME_1 = 3;
        private static final int PRIME_2 = 5;
        private final STATE mCallerState;
        private final STATE mPresentState;
        private final int mHashCode;

        public SummaryState(STATE STATE, STATE STATE2) {
            this.mCallerState = STATE2;
            this.mPresentState = STATE;
            this.mHashCode = 3 * STATE2.hashCode() + 5 * STATE.hashCode();
        }

        public STATE getCallerState() {
            return this.mCallerState;
        }

        public STATE getPresentState() {
            return this.mPresentState;
        }

        public boolean equals(Object object) {
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SummaryState summaryState = (SummaryState)object;
            return this.mPresentState.equals(summaryState.mPresentState) && this.mCallerState.equals(summaryState.mCallerState);
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public String toString() {
            return "CallerState: " + String.valueOf(this.mCallerState) + "  State: " + String.valueOf(this.mPresentState);
        }
    }
}

