/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ArrayTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CongruencePath;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;

public class WeakCongruencePath
extends CongruencePath {
    final ArrayTheory mArrayTheory;

    public WeakCongruencePath(ArrayTheory arrayTheory) {
        super(arrayTheory.getCClosure());
        this.mArrayTheory = arrayTheory;
    }

    public Clause computeSelectOverWeakEQ(CCAppTerm cCAppTerm, CCAppTerm cCAppTerm2, boolean bl) {
        CCTerm cCTerm = cCAppTerm.getArg();
        CCTerm cCTerm2 = cCAppTerm2.getArg();
        CCTerm cCTerm3 = ((CCAppTerm)cCAppTerm.getFunc()).getArg();
        CCTerm cCTerm4 = ((CCAppTerm)cCAppTerm2.getFunc()).getArg();
        this.computePath(cCTerm, cCTerm2);
        WeakSubPath weakSubPath = this.computeWeakPath(cCTerm3, cCTerm4, cCTerm, bl);
        this.mAllPaths.addFirst(weakSubPath);
        return this.generateClause(new SymmetricPair<CCTerm>(cCAppTerm, cCAppTerm2), bl, CCAnnotation.RuleKind.READ_OVER_WEAKEQ);
    }

    public Clause computeSelectConstOverWeakEQ(CCAppTerm cCAppTerm, CCAppTerm cCAppTerm2, boolean bl) {
        CCTerm cCTerm = cCAppTerm2.getArg();
        CCTerm cCTerm2 = cCAppTerm.getArg();
        CCTerm cCTerm3 = ((CCAppTerm)cCAppTerm.getFunc()).getArg();
        WeakSubPath weakSubPath = this.computeWeakPath(cCTerm3, cCAppTerm2, cCTerm2, bl);
        this.mAllPaths.addFirst(weakSubPath);
        return this.generateClause(new SymmetricPair<CCTerm>(cCAppTerm, cCTerm), bl, CCAnnotation.RuleKind.READ_CONST_WEAKEQ);
    }

    public Clause computeConstOverWeakEQ(CCAppTerm cCAppTerm, CCAppTerm cCAppTerm2, boolean bl) {
        CCTerm cCTerm = cCAppTerm.getArg();
        CCTerm cCTerm2 = cCAppTerm2.getArg();
        HashSet<CCTerm> hashSet = new HashSet<CCTerm>();
        Cursor cursor = new Cursor(cCAppTerm, this.mArrayTheory.mCongRoots.get(cCAppTerm.getRepresentative()));
        Cursor cursor2 = new Cursor(cCAppTerm2, this.mArrayTheory.mCongRoots.get(cCAppTerm2.getRepresentative()));
        CongruencePath.SubPath subPath = this.collectPathPrimary(cursor, cursor2, hashSet, bl);
        this.mAllPaths.addFirst(subPath);
        return this.generateClause(new SymmetricPair<CCTerm>(cCTerm, cCTerm2), bl, CCAnnotation.RuleKind.CONST_WEAKEQ);
    }

    public Clause computeWeakeqExt(CCTerm cCTerm, CCTerm cCTerm2, boolean bl) {
        assert (cCTerm != cCTerm2);
        LinkedHashSet<CCTerm> linkedHashSet = new LinkedHashSet<CCTerm>();
        Cursor cursor = new Cursor(cCTerm, this.mArrayTheory.mCongRoots.get(cCTerm.getRepresentative()));
        Cursor cursor2 = new Cursor(cCTerm2, this.mArrayTheory.mCongRoots.get(cCTerm2.getRepresentative()));
        CongruencePath.SubPath subPath = this.collectPathPrimary(cursor, cursor2, linkedHashSet, bl);
        for (CCTerm cCTerm3 : linkedHashSet) {
            WeakSubPath weakSubPath = this.computeWeakCongruencePath(cCTerm, cCTerm2, cCTerm3, bl);
            this.mAllPaths.addFirst(weakSubPath);
        }
        this.mAllPaths.addFirst(subPath);
        return this.generateClause(new SymmetricPair<CCTerm>(cCTerm, cCTerm2), bl, CCAnnotation.RuleKind.WEAKEQ_EXT);
    }

    private WeakSubPath computeWeakPath(CCTerm cCTerm, CCTerm cCTerm2, CCTerm cCTerm3, boolean bl) {
        LinkedHashSet<CCTerm> linkedHashSet = new LinkedHashSet<CCTerm>();
        CCTerm cCTerm4 = cCTerm3.getRepresentative();
        Cursor cursor = new Cursor(cCTerm, this.mArrayTheory.mCongRoots.get(cCTerm.getRepresentative()));
        Cursor cursor2 = new Cursor(cCTerm2, this.mArrayTheory.mCongRoots.get(cCTerm2.getRepresentative()));
        WeakSubPath weakSubPath = new WeakSubPath(cCTerm3, cCTerm, bl);
        WeakSubPath weakSubPath2 = new WeakSubPath(cCTerm3, cCTerm2, bl);
        assert (cursor.mArrayNode.getWeakIRepresentative(cCTerm4) == cursor2.mArrayNode.getWeakIRepresentative(cCTerm4));
        int n = cursor.mArrayNode.countSecondaryEdges(cCTerm4);
        int n2 = cursor2.mArrayNode.countSecondaryEdges(cCTerm4);
        while (n > n2) {
            this.collectPathOneSecondary(cursor, weakSubPath, linkedHashSet, bl);
            --n;
        }
        while (n2 > n) {
            this.collectPathOneSecondary(cursor2, weakSubPath2, linkedHashSet, bl);
            --n2;
        }
        while (cursor.mArrayNode.findSecondaryNode(cCTerm4) != cursor2.mArrayNode.findSecondaryNode(cCTerm4)) {
            this.collectPathOneSecondary(cursor, weakSubPath, linkedHashSet, bl);
            this.collectPathOneSecondary(cursor2, weakSubPath2, linkedHashSet, bl);
        }
        weakSubPath.addSubPath(this.collectPathPrimary(cursor, cursor2, linkedHashSet, bl));
        weakSubPath.addSubPath(weakSubPath2);
        for (CCTerm cCTerm5 : linkedHashSet) {
            this.computeIndexDiseq(cCTerm3, cCTerm5);
        }
        return weakSubPath;
    }

    private WeakSubPath computeWeakCongruencePath(CCTerm cCTerm, CCTerm cCTerm2, CCTerm cCTerm3, boolean bl) {
        CCTerm cCTerm4;
        CCTerm cCTerm5;
        CCAppTerm cCAppTerm;
        CCTerm cCTerm6;
        WeakSubPath weakSubPath;
        ArrayTheory.ArrayNode arrayNode;
        CCTerm cCTerm7 = cCTerm3.getRepresentative();
        ArrayTheory.ArrayNode arrayNode2 = this.mArrayTheory.mCongRoots.get(cCTerm.getRepresentative());
        ArrayTheory.ArrayNode arrayNode3 = this.mArrayTheory.mCongRoots.get(cCTerm2.getRepresentative());
        ArrayTheory.ArrayNode arrayNode4 = arrayNode2.getWeakIRepresentative(cCTerm7);
        if (arrayNode4 == (arrayNode = arrayNode3.getWeakIRepresentative(cCTerm7))) {
            return this.computeWeakPath(cCTerm, cCTerm2, cCTerm3, bl);
        }
        if (arrayNode4.mConstTerm != null) {
            weakSubPath = this.computeWeakPath(cCTerm, arrayNode4.mConstTerm, cCTerm3, bl);
            cCTerm6 = ArrayTheory.getValueFromConst(arrayNode4.mConstTerm);
        } else {
            cCAppTerm = arrayNode4.mSelects.get(cCTerm7);
            cCTerm5 = ArrayTheory.getArrayFromSelect(cCAppTerm);
            this.computePath(cCTerm3, ArrayTheory.getIndexFromSelect(cCAppTerm));
            weakSubPath = this.computeWeakPath(cCTerm, cCTerm5, cCTerm3, bl);
            cCTerm6 = cCAppTerm;
        }
        if (arrayNode.mConstTerm != null) {
            weakSubPath.addEntry(arrayNode.mConstTerm, null);
            weakSubPath.addSubPath(this.computeWeakPath(arrayNode.mConstTerm, cCTerm2, cCTerm3, bl));
            cCTerm4 = ArrayTheory.getValueFromConst(arrayNode.mConstTerm);
        } else {
            cCAppTerm = arrayNode.mSelects.get(cCTerm7);
            cCTerm5 = ArrayTheory.getArrayFromSelect(cCAppTerm);
            this.computePath(cCTerm3, ArrayTheory.getIndexFromSelect(cCAppTerm));
            weakSubPath.addEntry(cCTerm5, null);
            weakSubPath.addSubPath(this.computeWeakPath(cCTerm5, cCTerm2, cCTerm3, bl));
            cCTerm4 = cCAppTerm;
        }
        assert (cCTerm6.getRepresentative() == cCTerm4.getRepresentative());
        if (cCTerm6 != cCTerm4) {
            this.computePath(cCTerm6, cCTerm4);
        }
        return weakSubPath;
    }

    public void collectPathOnePrimary(Cursor cursor, CongruencePath.SubPath subPath, HashSet<CCTerm> hashSet) {
        Object object;
        CCAppTerm cCAppTerm;
        ArrayTheory.ArrayNode arrayNode = cursor.mArrayNode;
        CCTerm cCTerm = cCAppTerm = arrayNode.mPrimaryStore;
        CCTerm cCTerm2 = ArrayTheory.getArrayFromStore(cCAppTerm);
        if (cCTerm2.mRepStar == cursor.mArrayNode.mTerm) {
            object = cCTerm2;
            cCTerm2 = cCTerm;
            cCTerm = object;
        }
        assert (cCTerm.mRepStar == arrayNode.mTerm);
        assert (cCTerm2.mRepStar == arrayNode.mPrimaryEdge.mTerm);
        if (cursor.mTerm != cCTerm) {
            this.computePath(cursor.mTerm, cCTerm);
            object = (CongruencePath.SubPath)this.mAllPaths.removeFirst();
            subPath.addSubPath((CongruencePath.SubPath)object);
        }
        subPath.addEntry(cCTerm2, null);
        cursor.update(cCTerm2, arrayNode.mPrimaryEdge);
        hashSet.add(ArrayTheory.getIndexFromStore(cCAppTerm));
    }

    private CongruencePath.SubPath collectPathPrimary(Cursor cursor, Cursor cursor2, HashSet<CCTerm> hashSet, boolean bl) {
        CongruencePath.SubPath subPath = new CongruencePath.SubPath(cursor.mTerm, bl);
        CongruencePath.SubPath subPath2 = new CongruencePath.SubPath(cursor2.mTerm, bl);
        int n = cursor.mArrayNode.countPrimaryEdges();
        int n2 = cursor2.mArrayNode.countPrimaryEdges();
        while (n > n2) {
            this.collectPathOnePrimary(cursor, subPath, hashSet);
            --n;
        }
        while (n2 > n) {
            this.collectPathOnePrimary(cursor2, subPath2, hashSet);
            --n2;
        }
        while (cursor.mArrayNode != cursor2.mArrayNode) {
            this.collectPathOnePrimary(cursor, subPath, hashSet);
            this.collectPathOnePrimary(cursor2, subPath2, hashSet);
        }
        if (cursor.mTerm != cursor2.mTerm) {
            this.computePath(cursor.mTerm, cursor2.mTerm);
            CongruencePath.SubPath subPath3 = (CongruencePath.SubPath)this.mAllPaths.removeFirst();
            subPath.addSubPath(subPath3);
        }
        subPath.addSubPath(subPath2);
        return subPath;
    }

    private void collectPathOneSecondary(Cursor cursor, WeakSubPath weakSubPath, HashSet<CCTerm> hashSet, boolean bl) {
        CCAppTerm cCAppTerm;
        ArrayTheory.ArrayNode arrayNode = cursor.mArrayNode.findSecondaryNode(weakSubPath.mIdxRep);
        CCTerm cCTerm = cCAppTerm = arrayNode.mSecondaryStore;
        CCTerm cCTerm2 = ArrayTheory.getArrayFromStore(cCAppTerm);
        ArrayTheory.ArrayNode arrayNode2 = this.mArrayTheory.mCongRoots.get(cCTerm.mRepStar);
        ArrayTheory.ArrayNode arrayNode3 = this.mArrayTheory.mCongRoots.get(cCTerm2.mRepStar);
        if (arrayNode3.findSecondaryNode(weakSubPath.mIdxRep) == arrayNode) {
            ArrayTheory.ArrayNode arrayNode4 = arrayNode3;
            arrayNode3 = arrayNode2;
            arrayNode2 = arrayNode4;
            CCTerm cCTerm3 = cCTerm2;
            cCTerm2 = cCTerm;
            cCTerm = cCTerm3;
        }
        assert (arrayNode2.findSecondaryNode(weakSubPath.mIdxRep) == arrayNode);
        weakSubPath.addSubPath(this.collectPathPrimary(cursor, new Cursor(cCTerm, arrayNode2), hashSet, bl));
        weakSubPath.addEntry(cCTerm2, null);
        cursor.update(cCTerm2, arrayNode3);
        hashSet.add(ArrayTheory.getIndexFromStore(cCAppTerm));
    }

    private void computeIndexDiseq(CCTerm cCTerm, CCTerm cCTerm2) {
        CCEquality cCEquality = this.mArrayTheory.getCClosure().createEquality(cCTerm, cCTerm2, false);
        if (cCEquality != null) {
            this.mAllLiterals.add(cCEquality.negate());
        }
    }

    private Clause generateClause(SymmetricPair<CCTerm> symmetricPair, boolean bl, CCAnnotation.RuleKind ruleKind) {
        Object object3;
        Object object2;
        if (symmetricPair != null && (object2 = this.mArrayTheory.getCClosure().createEquality(symmetricPair.getFirst(), symmetricPair.getSecond(), false)) != null) {
            this.mAllLiterals.add(((Literal)object2).negate());
        }
        object2 = new Literal[this.mAllLiterals.size()];
        int n = 0;
        for (Object object3 : this.mAllLiterals) {
            object2[n++] = ((Literal)object3).negate();
        }
        object3 = new Clause((Literal[])object2);
        if (bl) {
            ((Clause)object3).setProof(new LeafNode(-5, this.createAnnotation(symmetricPair, ruleKind)));
        }
        return object3;
    }

    private CCAnnotation createAnnotation(SymmetricPair<CCTerm> symmetricPair, CCAnnotation.RuleKind ruleKind) {
        return new CCAnnotation(symmetricPair, (Collection<CongruencePath.SubPath>)this.mAllPaths, ruleKind);
    }

    private static class Cursor {
        public CCTerm mTerm;
        public ArrayTheory.ArrayNode mArrayNode;

        public Cursor(CCTerm cCTerm, ArrayTheory.ArrayNode arrayNode) {
            this.mTerm = cCTerm;
            this.mArrayNode = arrayNode;
        }

        public void update(CCTerm cCTerm, ArrayTheory.ArrayNode arrayNode) {
            this.mTerm = cCTerm;
            this.mArrayNode = arrayNode;
        }
    }

    static class WeakSubPath
    extends CongruencePath.SubPath {
        private final CCTerm mIdx;
        private final CCTerm mIdxRep;

        public WeakSubPath(CCTerm cCTerm, CCTerm cCTerm2, boolean bl) {
            super(cCTerm2, bl);
            this.mIdx = cCTerm;
            this.mIdxRep = cCTerm.getRepresentative();
        }

        @Override
        public String toString() {
            return "Weakpath " + String.valueOf(this.mIdx) + (String)(this.mTermsOnPath == null ? "" : " " + this.mTermsOnPath.toString());
        }

        public CCTerm getIndex() {
            return this.mIdx;
        }
    }
}

