/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.ComputeStoreInfosAndArrayGroups;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.LocArrayInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.LocArrayReadInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.EdgeInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.NoStoreInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.StoreInfo;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.HeapSepProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap3;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MemlocArrayManager {
    private boolean mFrozen;
    public static final String LOC_ARRAY_PREFIX = "#loc";
    public static final String LOC_SORT_PREFIX = "#locsort";
    public static final String INITLOCLIT_PREFIX = "#initloclit";
    private final ManagedScript mMgdScript;
    private final Map<Integer, Sort> mDimToLocSort = new HashMap<Integer, Sort>();
    private final NestedMap3<EdgeInfo, Term, Integer, LocArrayInfo> mEdgeToArrayTermToDimToLocArray = new NestedMap3();
    private final NestedMap2<IProgramVarOrConst, Integer, IProgramVarOrConst> mArrayPvocToDimToLocArrayPvoc = new NestedMap2();
    private final Map<Sort, HeapSepProgramConst> mLocArraySortToInitLocLit = new HashMap<Sort, HeapSepProgramConst>();
    private final Set<IProgramNonOldVar> mGlobalLocArrays = new HashSet<IProgramNonOldVar>();
    private final Map<Term, HeapSepProgramConst> mInitLocLitTermToPvoc = new HashMap<Term, HeapSepProgramConst>();
    private final Map<HeapSepProgramConst, NoStoreInfo> mInitLocPvocToNoStoreInfo = new HashMap<HeapSepProgramConst, NoStoreInfo>();
    private final ComputeStoreInfosAndArrayGroups<?> mCsiag;
    private int mNoStoreInfoCounter = -1;

    public MemlocArrayManager(ManagedScript managedScript, ComputeStoreInfosAndArrayGroups<?> computeStoreInfosAndArrayGroups) {
        this.mMgdScript = managedScript;
        this.mFrozen = false;
        this.mCsiag = computeStoreInfosAndArrayGroups;
    }

    public Sort getMemlocSort(int n) {
        Sort sort = this.mDimToLocSort.get(n);
        if (sort == null) {
            String string = LOC_SORT_PREFIX + n;
            this.mMgdScript.getScript().declareSort(string, 0);
            sort = this.mMgdScript.getScript().sort(string, new Sort[0]);
            this.mDimToLocSort.put(n, sort);
        }
        return sort;
    }

    public Set<HeapSepProgramConst> getInitLocLits() {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        return new HashSet<HeapSepProgramConst>(this.mLocArraySortToInitLocLit.values());
    }

    public LocArrayInfo getOrConstructLocArray(EdgeInfo edgeInfo, Term term, int n) {
        return this.getOrConstructLocArray(edgeInfo, term, n, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LocArrayInfo getOrConstructLocArray(EdgeInfo edgeInfo, Term term, int n, boolean bl) {
        LocArrayInfo locArrayInfo = (LocArrayInfo)this.mEdgeToArrayTermToDimToLocArray.get((Object)edgeInfo, (Object)term, (Object)n);
        if (locArrayInfo != null) return locArrayInfo;
        if (bl) {
            IProgramVarOrConst iProgramVarOrConst = edgeInfo.getProgramVarOrConstForTerm(term);
            assert (edgeInfo.getOutVar(term) == iProgramVarOrConst);
            assert (edgeInfo.getInVar(term) == iProgramVarOrConst);
            assert (!edgeInfo.getEdge().getTransformula().getAssignedVars().contains(iProgramVarOrConst));
            Sort sort = this.computeLocArraySort(term.getSort(), n);
            this.mMgdScript.lock((Object)this);
            IProgramVarOrConst iProgramVarOrConst2 = this.getLocArrayPvocForArrayPvoc(iProgramVarOrConst, n, sort);
            this.mMgdScript.unlock((Object)this);
            locArrayInfo = new LocArrayReadInfo(edgeInfo, iProgramVarOrConst2, iProgramVarOrConst2.getTerm());
            this.mEdgeToArrayTermToDimToLocArray.put((Object)edgeInfo, (Object)term, (Object)n, (Object)locArrayInfo);
            return locArrayInfo;
        } else {
            TermVariable termVariable;
            IProgramVarOrConst iProgramVarOrConst;
            assert (!this.mFrozen);
            this.mMgdScript.lock((Object)this);
            Sort sort = this.computeLocArraySort(term.getSort(), n);
            if (!(term instanceof TermVariable)) throw new UnsupportedOperationException("todo: deal with constants");
            IProgramVar iProgramVar = edgeInfo.getInVar(term);
            IProgramVar iProgramVar2 = edgeInfo.getOutVar(term);
            boolean bl2 = edgeInfo.getAuxVars().contains(term);
            if (iProgramVar != null) {
                iProgramVarOrConst = this.getLocArrayPvocForArrayPvoc((IProgramVarOrConst)iProgramVar, n, sort);
                termVariable = this.mMgdScript.constructFreshTermVariable(this.sanitizeVarName(LOC_ARRAY_PREFIX + String.valueOf(term) + "_" + n), sort);
            } else if (iProgramVar2 != null) {
                iProgramVarOrConst = this.getLocArrayPvocForArrayPvoc((IProgramVarOrConst)iProgramVar2, n, sort);
                termVariable = this.mMgdScript.constructFreshTermVariable(this.sanitizeVarName(LOC_ARRAY_PREFIX + String.valueOf(term) + "_" + n), sort);
            } else {
                if (!bl2) throw new AssertionError();
                iProgramVarOrConst = null;
                termVariable = this.mMgdScript.constructFreshTermVariable(this.sanitizeVarName(LOC_ARRAY_PREFIX + String.valueOf(term) + "_" + n), sort);
            }
            iProgramVar = this.getOrConstructInitLocLitForLocArraySort(sort, n);
            locArrayInfo = new LocArrayInfo(edgeInfo, iProgramVarOrConst, (Term)termVariable, this.computeInitConstantArrayForLocArray((HeapSepProgramConst)iProgramVar, sort, this));
            this.mMgdScript.unlock((Object)this);
            this.mEdgeToArrayTermToDimToLocArray.put((Object)edgeInfo, (Object)term, (Object)n, (Object)locArrayInfo);
        }
        return locArrayInfo;
    }

    public Term getInitConstArrayForGlobalLocArray(IProgramNonOldVar iProgramNonOldVar, Object object) {
        Sort sort = iProgramNonOldVar.getSort();
        int n = new MultiDimensionalSort(sort).getDimension();
        HeapSepProgramConst heapSepProgramConst = this.getOrConstructInitLocLitForLocArraySort(sort, n);
        return this.computeInitConstantArrayForLocArray(heapSepProgramConst, sort, object);
    }

    public Set<IProgramNonOldVar> getGlobalLocArrays() {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        return Collections.unmodifiableSet(this.mGlobalLocArrays);
    }

    private HeapSepProgramConst getOrConstructInitLocLitForLocArraySort(Sort sort, int n) {
        assert (new MultiDimensionalSort(sort).getDimension() == n);
        HeapSepProgramConst heapSepProgramConst = this.mLocArraySortToInitLocLit.get(sort);
        if (heapSepProgramConst == null) {
            assert (this.mMgdScript.isLockOwner((Object)this));
            String string = INITLOCLIT_PREFIX + n;
            this.mMgdScript.declareFun((Object)this, string, new Sort[0], this.getMemlocSort(n));
            ApplicationTerm applicationTerm = (ApplicationTerm)this.mMgdScript.term((Object)this, string, new Term[0]);
            heapSepProgramConst = new HeapSepProgramConst(applicationTerm);
            this.mInitLocLitTermToPvoc.put((Term)applicationTerm, heapSepProgramConst);
            this.mLocArraySortToInitLocLit.put(sort, heapSepProgramConst);
            this.mInitLocPvocToNoStoreInfo.put(heapSepProgramConst, new NoStoreInfo(this.mNoStoreInfoCounter--));
        }
        return heapSepProgramConst;
    }

    private IProgramVarOrConst getLocArrayPvocForArrayPvoc(IProgramVarOrConst iProgramVarOrConst, int n, Sort sort) {
        assert (this.mMgdScript.isLockOwner((Object)this)) : "locking before calling this, by convention (unclear if there are compelling arguments for the convention)";
        IProgramVarOrConst iProgramVarOrConst2 = (IProgramVarOrConst)this.mArrayPvocToDimToLocArrayPvoc.get((Object)iProgramVarOrConst, (Object)n);
        if (iProgramVarOrConst2 == null) {
            if (iProgramVarOrConst instanceof IProgramNonOldVar) {
                iProgramVarOrConst2 = ProgramVarUtils.constructGlobalProgramVarPair((String)this.sanitizeVarName("#loc_" + String.valueOf(iProgramVarOrConst) + "_" + String.valueOf(sort)), (Sort)sort, (ManagedScript)this.mMgdScript, (Object)this);
                this.mGlobalLocArrays.add((IProgramNonOldVar)iProgramVarOrConst2);
            } else if (iProgramVarOrConst instanceof ILocalProgramVar) {
                iProgramVarOrConst2 = ProgramVarUtils.constructLocalProgramVar((String)this.sanitizeVarName("#loc_" + String.valueOf(iProgramVarOrConst) + "_" + String.valueOf(sort)), (String)((ILocalProgramVar)iProgramVarOrConst).getProcedure(), (Sort)sort, (ManagedScript)this.mMgdScript, (Object)this);
            } else {
                if (iProgramVarOrConst instanceof IProgramConst) {
                    throw new UnsupportedOperationException("todo: deal with constants");
                }
                throw new AssertionError((Object)"unforseen case");
            }
            this.mArrayPvocToDimToLocArrayPvoc.put((Object)iProgramVarOrConst, (Object)n, (Object)iProgramVarOrConst2);
        }
        return iProgramVarOrConst2;
    }

    private String sanitizeVarName(String string) {
        String string2 = string.replace("|", "").replaceAll("\\ ", "-");
        if (string2.isEmpty()) {
            throw new AssertionError();
        }
        return string2;
    }

    private Sort computeLocArraySort(Sort sort, int n) {
        MultiDimensionalSort multiDimensionalSort = new MultiDimensionalSort(sort);
        assert (multiDimensionalSort.getDimension() > 0);
        ArrayDeque arrayDeque = new ArrayDeque(multiDimensionalSort.getIndexSorts());
        int n2 = 0;
        while (n2 < multiDimensionalSort.getDimension() - n) {
            arrayDeque.pollLast();
            ++n2;
        }
        assert (arrayDeque.size() == n);
        Sort sort2 = this.getMemlocSort(n);
        while (!arrayDeque.isEmpty()) {
            Sort sort3 = (Sort)arrayDeque.pollLast();
            sort2 = SmtSortUtils.getArraySort((Script)this.mMgdScript.getScript(), (Sort)sort3, (Sort)sort2);
        }
        return sort2;
    }

    private Term computeInitConstantArrayForLocArray(HeapSepProgramConst heapSepProgramConst, Sort sort, Object object) {
        MultiDimensionalSort multiDimensionalSort = new MultiDimensionalSort(sort);
        if (multiDimensionalSort.getDimension() == 1) {
            return this.mMgdScript.term(object, "const", null, sort, new Term[]{heapSepProgramConst.getTerm()});
        }
        assert (!sort.getArguments()[0].isArraySort());
        Term term = this.computeInitConstantArrayForLocArray(heapSepProgramConst, sort.getArguments()[1], object);
        return this.mMgdScript.term(object, "const", null, sort, new Term[]{term});
    }

    public LocArrayInfo getLocArray(EdgeInfo edgeInfo, Term term, int n) {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        LocArrayInfo locArrayInfo = (LocArrayInfo)this.mEdgeToArrayTermToDimToLocArray.get((Object)edgeInfo, (Object)term, (Object)n);
        if (locArrayInfo == null) {
            throw new IllegalArgumentException();
        }
        return locArrayInfo;
    }

    public HeapSepProgramConst getInitLocLitPvocForLocLitTerm(Term term) {
        return this.mInitLocLitTermToPvoc.get(term);
    }

    public boolean isInitLocPvoc(HeapSepProgramConst heapSepProgramConst) {
        boolean bl = this.mInitLocPvocToNoStoreInfo.containsKey(heapSepProgramConst);
        assert (bl == this.mInitLocLitTermToPvoc.containsValue(heapSepProgramConst));
        return bl;
    }

    public StoreInfo getNoStoreInfo(HeapSepProgramConst heapSepProgramConst) {
        return this.mInitLocPvocToNoStoreInfo.get(heapSepProgramConst);
    }

    public void freeze() {
        if (this.mFrozen) {
            throw new AssertionError();
        }
        this.mFrozen = true;
    }

    public boolean isArrayTermSubjectToSeparation(EdgeInfo edgeInfo, Term term) {
        return this.mCsiag.isArrayTermSubjectToSeparation(edgeInfo, term);
    }
}

