/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.walker;

import de.uni_freiburg.informatik.ultimate.core.model.observers.IObserver;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.visitors.SimpleRCFGVisitor;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.walker.IRCFGVisitorDispatcher;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.walker.IRCFGWalker;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public abstract class ObserverDispatcher {
    protected List<SimpleRCFGVisitor> mObservers = new LinkedList<SimpleRCFGVisitor>();
    protected final ILogger mLogger;
    protected IRCFGWalker mWalker;

    public ObserverDispatcher(ILogger iLogger) {
        this.mLogger = iLogger;
    }

    public void setWalker(IRCFGWalker iRCFGWalker) {
        this.mWalker = iRCFGWalker;
    }

    public boolean addObserver(IObserver iObserver) {
        if (!(iObserver instanceof SimpleRCFGVisitor)) {
            this.mLogger.error((Object)"RCFGWalker only accepts RCFGVisitors");
            return false;
        }
        return this.mObservers.add((SimpleRCFGVisitor)iObserver);
    }

    public boolean removeObserver(IObserver iObserver) {
        return this.mObservers.remove(iObserver);
    }

    public void removeAllObservers() {
        this.mObservers.clear();
    }

    public boolean containsObserver(IObserver iObserver) {
        return this.mObservers.contains(iObserver);
    }

    public abstract void run(Collection<IcfgEdge> var1);

    protected abstract void callObservers(IRCFGVisitorDispatcher var1);

    public abstract boolean abortCurrentBranch();

    public abstract boolean abortAll();
}

