/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.csv;

import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CsvUtils {
    public static <T extends ICsvProvider<?>, K extends ICsvProvider<?>> K convertComplete(T t, IExplicitConverter<T, K> iExplicitConverter) {
        return (K)((ICsvProvider)iExplicitConverter.convert(t));
    }

    public static <T, K> ICsvProvider<K> convertPerValue(ICsvProvider<T> iCsvProvider, IExplicitConverter<T, K> iExplicitConverter) {
        SimpleCsvProvider simpleCsvProvider = new SimpleCsvProvider(iCsvProvider.getColumnTitles());
        List<String> list = iCsvProvider.getRowHeaders();
        List<List<T>> list2 = iCsvProvider.getTable();
        int n = 0;
        while (n < list2.size()) {
            Object object2;
            List<T> list3 = list2.get(n);
            ArrayList<K> arrayList = new ArrayList<K>();
            for (Object object2 : list3) {
                arrayList.add(iExplicitConverter.convert(object2));
            }
            object2 = list.get(n);
            simpleCsvProvider.addRow((String)object2, arrayList);
            ++n;
        }
        return simpleCsvProvider;
    }

    public static <T> ICsvProvider<T> flatten(ICsvProvider<T> iCsvProvider, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<T> arrayList2 = new ArrayList<T>();
        List<List<T>> list = iCsvProvider.getTable();
        int n = 0;
        while (n < iCsvProvider.getColumnTitles().size()) {
            String string2 = iCsvProvider.getColumnTitles().get(n);
            int n2 = 0;
            while (n2 < iCsvProvider.getRowHeaders().size()) {
                String string3 = iCsvProvider.getRowHeaders().get(n2);
                arrayList.add(string2 + string + string3);
                arrayList2.add(list.get(n2).get(n));
                ++n2;
            }
            ++n;
        }
        SimpleCsvProvider<T> simpleCsvProvider = new SimpleCsvProvider<T>(arrayList);
        simpleCsvProvider.addRow(arrayList2);
        return simpleCsvProvider;
    }

    public static <T> ICsvProvider<T> projectColumn(ICsvProvider<T> iCsvProvider, String string) {
        return CsvUtils.projectColumn(iCsvProvider, Collections.singleton(string));
    }

    public static <T> ICsvProvider<T> projectColumn(ICsvProvider<T> iCsvProvider, String[] stringArray) {
        return CsvUtils.projectColumn(iCsvProvider, Arrays.asList(stringArray));
    }

    public static <T> ICsvProvider<T> projectColumn(ICsvProvider<T> iCsvProvider, Collection<String> collection) {
        SimpleCsvProvider simpleCsvProvider = new SimpleCsvProvider(new ArrayList<String>(collection));
        if (iCsvProvider.isEmpty()) {
            return simpleCsvProvider;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string : collection) {
            int n = -1;
            int arrayList2 = 0;
            while (arrayList2 < iCsvProvider.getColumnTitles().size()) {
                String string2 = iCsvProvider.getColumnTitles().get(arrayList2);
                if (string2.equals(string)) {
                    n = arrayList2;
                    break;
                }
                ++arrayList2;
            }
            arrayList.add(n);
        }
        int n = 0;
        for (String string : iCsvProvider.getRowHeaders()) {
            ArrayList<T> arrayList2 = new ArrayList<T>();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                if (n2 == -1) {
                    arrayList2.add(null);
                    continue;
                }
                arrayList2.add(iCsvProvider.getRow(n).get(n2));
            }
            ++n;
            simpleCsvProvider.addRow(string, arrayList2);
        }
        return simpleCsvProvider;
    }

    public static <T> ICsvProvider<T> addColumn(ICsvProvider<T> iCsvProvider, String string, int n, List<T> list) {
        if (n < 0 || n > iCsvProvider.getColumnTitles().size()) {
            throw new IllegalArgumentException();
        }
        List<String> list2 = iCsvProvider.getColumnTitles();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        int n3 = 0;
        while (n2 < list2.size() + 1) {
            if (n2 == n) {
                arrayList.add(n2, string);
            } else {
                arrayList.add(n2, list2.get(n3));
                ++n3;
            }
            ++n2;
        }
        SimpleCsvProvider simpleCsvProvider = new SimpleCsvProvider(arrayList);
        n3 = 0;
        for (List<T> list3 : iCsvProvider.getTable()) {
            ArrayList<T> arrayList2 = new ArrayList<T>();
            int n4 = 0;
            int n5 = 0;
            while (n4 < arrayList.size()) {
                if (n4 == n) {
                    arrayList2.add(n4, list.get(n3));
                } else {
                    arrayList2.add(n4, list3.get(n5));
                    ++n5;
                }
                ++n4;
            }
            simpleCsvProvider.addRow(iCsvProvider.getRowHeaders().get(n3), arrayList2);
            ++n3;
        }
        return simpleCsvProvider;
    }

    public static <T> ICsvProvider<T> transpose(ICsvProvider<T> iCsvProvider) {
        if (iCsvProvider == null || iCsvProvider.isEmpty()) {
            throw new IllegalArgumentException("provider may not be null or empty");
        }
        ArrayList<String> arrayList = new ArrayList<String>(iCsvProvider.getRowHeaders());
        SimpleCsvProvider simpleCsvProvider = new SimpleCsvProvider(arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>(iCsvProvider.getColumnTitles());
        int n = 0;
        for (String string : arrayList2) {
            ArrayList<T> arrayList3 = new ArrayList<T>();
            for (List<T> list : iCsvProvider.getTable()) {
                arrayList3.add(list.get(n));
            }
            simpleCsvProvider.addRow(string, arrayList3);
            ++n;
        }
        return simpleCsvProvider;
    }

    public static ICsvProvider<Object> concatenateRowsUnchecked(ICsvProvider<?> iCsvProvider, ICsvProvider<?> iCsvProvider2) {
        return CsvUtils.concatenateRows(iCsvProvider, iCsvProvider2);
    }

    public static <T> ICsvProvider<T> concatenateRows(ICsvProvider<T> iCsvProvider, ICsvProvider<T> iCsvProvider2) {
        List<T> list;
        int n;
        List<String> list2;
        List<String> list3 = iCsvProvider.getColumnTitles();
        List<String> list4 = iCsvProvider2.getColumnTitles();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        if (list3.isEmpty()) {
            list2 = list4;
        } else if (list4.isEmpty()) {
            list2 = list4;
        } else {
            list2 = new ArrayList<String>();
            int n2 = 0;
            n = 0;
            while (n2 < list3.size() || n < list4.size()) {
                String string = null;
                if (n2 < list3.size()) {
                    string = list3.get(n2);
                }
                Object object = null;
                if (n < list4.size()) {
                    object = list4.get(n);
                }
                if (string != null && string.equals(object)) {
                    list2.add(string);
                    ++n2;
                    ++n;
                    continue;
                }
                if (n2 < list3.size() && !list4.contains(string)) {
                    if (n < list4.size() && !list3.contains(object) && ((String)object).compareTo(string) < 0) {
                        list2.add((String)object);
                        arrayList.add(n2);
                        ++n;
                        continue;
                    }
                    list2.add(string);
                    arrayList2.add(n);
                    ++n2;
                    continue;
                }
                if (n < list4.size() && !list3.contains(object)) {
                    list2.add((String)object);
                    arrayList.add(n2);
                    ++n;
                    continue;
                }
                throw new IllegalArgumentException("unable to merge, both providers have similar columns but in different order");
            }
        }
        SimpleCsvProvider<T> simpleCsvProvider = new SimpleCsvProvider<T>(list2);
        n = 0;
        for (String string : iCsvProvider.getRowHeaders()) {
            list = iCsvProvider.getRow(n);
            simpleCsvProvider.addRow(string, CsvUtils.insertNullElements(list, arrayList));
            ++n;
        }
        n = 0;
        for (String string : iCsvProvider2.getRowHeaders()) {
            list = iCsvProvider2.getRow(n);
            simpleCsvProvider.addRow(string, CsvUtils.insertNullElements(list, arrayList2));
            ++n;
        }
        return simpleCsvProvider;
    }

    public static <T, K extends ICsvProvider<T>> ICsvProvider<T> concatenateRows(List<K> list) {
        ICsvProvider iCsvProvider = new SimpleCsvProvider(new ArrayList<String>());
        for (ICsvProvider iCsvProvider2 : list) {
            iCsvProvider = CsvUtils.concatenateRows(iCsvProvider, iCsvProvider2);
        }
        return iCsvProvider;
    }

    private static <T> List<T> insertNullElements(List<T> list, List<Integer> list2) {
        LinkedList<T> linkedList = new LinkedList<T>(list);
        int n = list2.size() - 1;
        while (n >= 0) {
            linkedList.add(list2.get(n), null);
            --n;
        }
        return linkedList;
    }

    public static <T> ICsvProvider<T> constructCvsProviderFromMap(Map<String, T> map) {
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        SimpleCsvProvider simpleCsvProvider = new SimpleCsvProvider(arrayList);
        ArrayList<T> arrayList2 = new ArrayList<T>();
        for (String string : arrayList) {
            arrayList2.add(map.get(string));
        }
        simpleCsvProvider.addRow(arrayList2);
        return simpleCsvProvider;
    }

    public static <T> StringBuilder toHTML(ICsvProvider<T> iCsvProvider, StringBuilder stringBuilder, boolean bl, IExplicitConverter<T, String> iExplicitConverter) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        if (iExplicitConverter == null) {
            iExplicitConverter = object -> {
                if (object == null) {
                    return "-";
                }
                return object.toString();
            };
        }
        String string = System.getProperty("line.separator");
        if (bl) {
            stringBuilder.append("<html><body>").append(string);
        }
        stringBuilder.append("<table style=\"width:100%\">").append(string);
        if (CsvUtils.hasRowHeaders(iCsvProvider)) {
            List<String> list = iCsvProvider.getColumnTitles();
            stringBuilder.append("<tr><th></th>");
            for (String object22 : list) {
                stringBuilder.append("<th>").append(object22).append("</th>");
            }
            stringBuilder.append("</tr>").append(string);
            List<String> object32 = iCsvProvider.getRowHeaders();
            List<List<T>> list2 = iCsvProvider.getTable();
            int n = 0;
            while (n < list2.size()) {
                stringBuilder.append("<tr><td>");
                stringBuilder.append(object32.get(n));
                stringBuilder.append("</td>");
                for (Object e : (List)list2.get(n)) {
                    stringBuilder.append("<td>").append(iExplicitConverter.convert(e)).append("</td>");
                }
                stringBuilder.append("</tr>").append(string);
                ++n;
            }
        } else {
            List<String> list = iCsvProvider.getColumnTitles();
            stringBuilder.append("<tr>");
            for (String string2 : list) {
                stringBuilder.append("<th>").append(string2).append("</th>");
            }
            stringBuilder.append("</tr>").append(string);
            List<List<T>> list2 = iCsvProvider.getTable();
            for (Object list3 : list2) {
                stringBuilder.append("<tr>");
                Iterator iterator = list3.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    stringBuilder.append("<td>").append(iExplicitConverter.convert(e)).append("</td>");
                }
                stringBuilder.append("</tr>").append(string);
            }
        }
        stringBuilder.append("</table>").append(string);
        if (bl) {
            stringBuilder.append("</body></html>").append(string);
        }
        return stringBuilder;
    }

    private static <T> boolean hasRowHeaders(ICsvProvider<T> iCsvProvider) {
        List<String> list = iCsvProvider.getRowHeaders();
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (String string : list) {
            if (string == null || string.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static interface IExplicitConverter<T, K> {
        public K convert(T var1);
    }
}

