/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ResolutionNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RecyclePivots {
    private Map<Clause, Integer> mCounts;
    private final Deque<Worker> mTodo = new ArrayDeque<Worker>();
    private HashMap<Clause, Integer> mSeen;
    private HashMap<Object, Set<Literal>> mSafeLits;
    private Map<Clause, Set<Literal>> mDeleted;

    public Map<Clause, Set<Literal>> regularize(Clause clause, Map<Clause, Integer> map) {
        this.mCounts = map;
        this.mSafeLits = new HashMap();
        this.mDeleted = new HashMap<Clause, Set<Literal>>();
        this.mSeen = new HashMap();
        HashSet<Literal> hashSet = new HashSet<Literal>();
        int n = 0;
        while (n < clause.getSize()) {
            hashSet.add(clause.getLiteral(n));
            ++n;
        }
        this.mTodo.push(new SetAndExpand(clause, hashSet));
        this.run();
        return this.mDeleted;
    }

    private void run() {
        while (!this.mTodo.isEmpty()) {
            Worker worker = this.mTodo.pop();
            worker.work();
        }
    }

    private boolean seen(Clause clause) {
        Integer n = this.mSeen.get(clause);
        int n2 = n == null ? 1 : n + 1;
        this.mSeen.put(clause, n2);
        int n3 = this.mCounts.get(clause);
        assert (n2 <= n3);
        return n3 == n2;
    }

    private class SetAndExpand
    implements Worker {
        final Clause mCls;
        Set<Literal> mSafes;

        public SetAndExpand(Clause clause, Set<Literal> set) {
            this.mCls = clause;
            this.mSafes = set;
        }

        @Override
        public void work() {
            if (RecyclePivots.this.seen(this.mCls)) {
                Set<Literal> set = RecyclePivots.this.mSafeLits.get(this.mCls);
                if (this.mSafes == null) {
                    this.mSafes = set;
                } else if (set != null) {
                    this.mSafes.retainAll(set);
                }
                ProofNode proofNode = this.mCls.getProof();
                if (!proofNode.isLeaf()) {
                    HashSet<Literal> hashSet = null;
                    ResolutionNode resolutionNode = (ResolutionNode)proofNode;
                    ResolutionNode.Antecedent[] antecedentArray = resolutionNode.getAntecedents();
                    int n = antecedentArray.length - 1;
                    while (n >= 0) {
                        HashSet<Literal> hashSet2 = null;
                        if (this.mSafes != null) {
                            if (this.mSafes.contains(antecedentArray[n].mPivot.negate())) {
                                if (hashSet == null) {
                                    hashSet = new HashSet<Literal>();
                                }
                                hashSet.add(antecedentArray[n].mPivot);
                            } else if (!antecedentArray[n].mAntecedent.getProof().isLeaf()) {
                                hashSet2 = new HashSet<Literal>(this.mSafes);
                                hashSet2.add(antecedentArray[n].mPivot);
                            }
                        }
                        if (!antecedentArray[n].mAntecedent.getProof().isLeaf()) {
                            RecyclePivots.this.mTodo.push(new SetAndExpand(antecedentArray[n].mAntecedent, hashSet2));
                        }
                        if (this.mSafes != null && this.mSafes.contains(antecedentArray[n].mPivot)) {
                            if (hashSet == null) {
                                hashSet = new HashSet();
                            }
                            hashSet.add(antecedentArray[n].mPivot.negate());
                            this.mSafes = null;
                        }
                        if (this.mSafes != null) {
                            this.mSafes.add(antecedentArray[n].mPivot.negate());
                        }
                        --n;
                    }
                    if (hashSet != null) {
                        RecyclePivots.this.mDeleted.put(this.mCls, hashSet);
                    }
                    if (!resolutionNode.getPrimary().getProof().isLeaf()) {
                        HashSet<Literal> hashSet3 = null;
                        if (this.mSafes != null) {
                            hashSet3 = new HashSet<Literal>(this.mSafes);
                        }
                        RecyclePivots.this.mTodo.push(new SetAndExpand(resolutionNode.getPrimary(), hashSet3));
                    }
                }
            } else if (this.mSafes != null) {
                Set<Literal> set = RecyclePivots.this.mSafeLits.get(this.mCls);
                if (set == null) {
                    RecyclePivots.this.mSafeLits.put(this.mCls, this.mSafes);
                } else {
                    set.retainAll(this.mSafes);
                }
            }
        }
    }

    private static interface Worker {
        public void work();
    }
}

