/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoRun;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolationTechnique;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BinaryStatePredicateManager;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BuchiAutomizerUtils;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BuchiHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BuchiInterpolantAutomatonBouncer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BuchiInterpolantAutomatonConstructionStyle;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.LoopCannibalizer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender.NondeterministicInterpolantAutomaton;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class BuchiInterpolantAutomatonBuilder<LETTER extends IIcfgTransition<?>> {
    private final IUltimateServiceProvider mServices;
    private final CfgSmtToolkit mCsToolkit;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final PredicateFactory mPredicateFactory;
    private final InterpolationTechnique mInterpolation;

    public BuchiInterpolantAutomatonBuilder(IUltimateServiceProvider iUltimateServiceProvider, CfgSmtToolkit cfgSmtToolkit, SmtUtils.SimplificationTechnique simplificationTechnique, PredicateFactory predicateFactory, InterpolationTechnique interpolationTechnique) {
        this.mServices = iUltimateServiceProvider;
        this.mCsToolkit = cfgSmtToolkit;
        this.mSimplificationTechnique = simplificationTechnique;
        this.mPredicateFactory = predicateFactory;
        this.mInterpolation = interpolationTechnique;
    }

    public NestedWordAutomaton<LETTER, IPredicate> constructInterpolantAutomaton(IPredicate iPredicate, NestedLassoRun<LETTER, ?> nestedLassoRun, IPredicate[] iPredicateArray, IPredicate iPredicate2, IPredicate[] iPredicateArray2, VpAlphabet<LETTER> vpAlphabet, IEmptyStackStateFactory<IPredicate> iEmptyStackStateFactory) {
        int n;
        NestedWord nestedWord = nestedLassoRun.getStem().getWord();
        NestedWord nestedWord2 = nestedLassoRun.getLoop().getWord();
        NestedWordAutomaton nestedWordAutomaton = new NestedWordAutomaton(new AutomataLibraryServices(this.mServices), vpAlphabet, iEmptyStackStateFactory);
        if (nestedWord.length() == 0) {
            nestedWordAutomaton.addState(true, true, (Object)iPredicate2);
        } else {
            nestedWordAutomaton.addState(true, false, (Object)iPredicate);
            n = 0;
            while (n < iPredicateArray.length) {
                BuchiInterpolantAutomatonBuilder.addState(iPredicateArray[n], nestedWordAutomaton);
                BuchiInterpolantAutomatonBuilder.addTransition(n, iPredicate, iPredicateArray, iPredicate2, nestedWord, nestedWordAutomaton);
                ++n;
            }
            nestedWordAutomaton.addState(false, true, (Object)iPredicate2);
            BuchiInterpolantAutomatonBuilder.addTransition(iPredicateArray.length, iPredicate, iPredicateArray, iPredicate2, nestedWord, nestedWordAutomaton);
        }
        n = 0;
        while (n < iPredicateArray2.length) {
            BuchiInterpolantAutomatonBuilder.addState(iPredicateArray2[n], nestedWordAutomaton);
            BuchiInterpolantAutomatonBuilder.addTransition(n, iPredicate2, iPredicateArray2, iPredicate2, nestedWord2, nestedWordAutomaton);
            ++n;
        }
        BuchiInterpolantAutomatonBuilder.addTransition(iPredicateArray2.length, iPredicate2, iPredicateArray2, iPredicate2, nestedWord2, nestedWordAutomaton);
        return nestedWordAutomaton;
    }

    private static void addState(IPredicate iPredicate, NestedWordAutomaton<?, IPredicate> nestedWordAutomaton) {
        if (!nestedWordAutomaton.getStates().contains(iPredicate)) {
            nestedWordAutomaton.addState(false, false, (Object)iPredicate);
        }
    }

    private static <LETTER extends IIcfgTransition<?>> void addTransition(int n, IPredicate iPredicate, IPredicate[] iPredicateArray, IPredicate iPredicate2, NestedWord<LETTER> nestedWord, NestedWordAutomaton<LETTER, IPredicate> nestedWordAutomaton) {
        IPredicate iPredicate3 = BuchiInterpolantAutomatonBuilder.getPredicateAtPosition(n - 1, iPredicate, iPredicateArray, iPredicate2);
        IPredicate iPredicate4 = BuchiInterpolantAutomatonBuilder.getPredicateAtPosition(n, iPredicate, iPredicateArray, iPredicate2);
        IIcfgTransition iIcfgTransition = (IIcfgTransition)nestedWord.getSymbol(n);
        if (nestedWord.isInternalPosition(n)) {
            nestedWordAutomaton.addInternalTransition((Object)iPredicate3, (Object)iIcfgTransition, (Object)iPredicate4);
        } else if (nestedWord.isCallPosition(n)) {
            nestedWordAutomaton.addCallTransition((Object)iPredicate3, (Object)iIcfgTransition, (Object)iPredicate4);
        } else if (nestedWord.isReturnPosition(n)) {
            assert (!nestedWord.isPendingReturn(n));
            int n2 = nestedWord.getCallPosition(n);
            IPredicate iPredicate5 = BuchiInterpolantAutomatonBuilder.getPredicateAtPosition(n2 - 1, iPredicate, iPredicateArray, iPredicate2);
            nestedWordAutomaton.addReturnTransition((Object)iPredicate3, (Object)iPredicate5, (Object)iIcfgTransition, (Object)iPredicate4);
        }
    }

    private static IPredicate getPredicateAtPosition(int n, IPredicate iPredicate, IPredicate[] iPredicateArray, IPredicate iPredicate2) {
        assert (n >= -1);
        assert (n <= iPredicateArray.length);
        if (n < 0) {
            return iPredicate;
        }
        if (n >= iPredicateArray.length) {
            return iPredicate2;
        }
        return iPredicateArray[n];
    }

    public INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> constructGeneralizedAutomaton(NestedLassoRun<LETTER, IPredicate> nestedLassoRun, BuchiInterpolantAutomatonConstructionStyle buchiInterpolantAutomatonConstructionStyle, BinaryStatePredicateManager.BspmResult bspmResult, PredicateUnifier predicateUnifier, IPredicate[] iPredicateArray, IPredicate[] iPredicateArray2, NestedWordAutomaton<LETTER, IPredicate> nestedWordAutomaton, BuchiHoareTripleChecker buchiHoareTripleChecker) {
        switch (buchiInterpolantAutomatonConstructionStyle.getInterpolantAutomaton()) {
            case LASSO_AUTOMATON: {
                return nestedWordAutomaton;
            }
            case EAGER_NONDETERMINISM: {
                if (!nestedWordAutomaton.getStates().contains(predicateUnifier.getTruePredicate())) {
                    nestedWordAutomaton.addState(false, false, (Object)predicateUnifier.getTruePredicate());
                }
                if (!nestedWordAutomaton.getStates().contains(predicateUnifier.getFalsePredicate())) {
                    nestedWordAutomaton.addState(false, true, (Object)predicateUnifier.getFalsePredicate());
                }
                return new NondeterministicInterpolantAutomaton(this.mServices, this.mCsToolkit, (IHoareTripleChecker)buchiHoareTripleChecker, nestedWordAutomaton, (IPredicateUnifier)predicateUnifier, false, true);
            }
            case SCROOGE_NONDETERMINISM: 
            case DETERMINISTIC: {
                Set<Object> set;
                HashSet<IPredicate> hashSet = BuchiAutomizerUtils.isEmptyStem(nestedLassoRun.getStem()) ? Collections.emptySet() : (buchiInterpolantAutomatonConstructionStyle.cannibalizeLoop() ? predicateUnifier.cannibalizeAll(false, Arrays.asList(iPredicateArray)) : new HashSet<IPredicate>(Arrays.asList(iPredicateArray)));
                if (buchiInterpolantAutomatonConstructionStyle.cannibalizeLoop()) {
                    try {
                        set = predicateUnifier.cannibalizeAll(false, Arrays.asList(iPredicateArray2));
                        set.addAll(predicateUnifier.cannibalize(false, bspmResult.getRankEqAndSi().getFormula()));
                        LoopCannibalizer<LETTER> loopCannibalizer = new LoopCannibalizer<LETTER>(nestedLassoRun, set, bspmResult.getRankEqAndSi(), bspmResult.getHondaPredicate(), predicateUnifier, this.mCsToolkit, this.mInterpolation, this.mServices, this.mSimplificationTechnique);
                        set = loopCannibalizer.getResult();
                    }
                    catch (ToolchainCanceledException toolchainCanceledException) {
                        toolchainCanceledException.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), "loop cannibalization"));
                        throw toolchainCanceledException;
                    }
                } else {
                    set = new HashSet<IPredicate>(Arrays.asList(iPredicateArray2));
                    set.add(bspmResult.getRankEqAndSi());
                }
                return new BuchiInterpolantAutomatonBouncer<LETTER>(this.mCsToolkit, this.mPredicateFactory, bspmResult, buchiHoareTripleChecker, nestedLassoRun, hashSet, set, buchiInterpolantAutomatonConstructionStyle, predicateUnifier, this.mServices, nestedWordAutomaton);
            }
        }
        throw new UnsupportedOperationException("unknown automaton");
    }
}

