/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.QuadraticMatrix;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import java.math.BigInteger;

public class RationalMatrix {
    private final QuadraticMatrix mIntMatrix;
    private BigInteger mDenominator;

    public RationalMatrix(BigInteger bigInteger, QuadraticMatrix quadraticMatrix) {
        this.mDenominator = bigInteger;
        this.mIntMatrix = quadraticMatrix;
    }

    public static RationalMatrix computeInverse(RationalMatrix rationalMatrix) {
        int n = rationalMatrix.mIntMatrix.getDimension();
        RationalMatrix rationalMatrix2 = QuadraticMatrix.computeInverse(rationalMatrix.mIntMatrix);
        Rational rational = Rational.valueOf((BigInteger)rationalMatrix.mDenominator, (BigInteger)rationalMatrix2.mDenominator);
        rational = Rational.valueOf((BigInteger)rational.numerator(), (BigInteger)rational.denominator());
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                rationalMatrix.mIntMatrix.setEntry(n2, n3, rationalMatrix.mIntMatrix.getEntry(n2, n3).multiply(rational.numerator()));
                ++n3;
            }
            ++n2;
        }
        rationalMatrix2.mDenominator = rational.denominator();
        return rationalMatrix2;
    }

    public void addColumnToMatrix(int n, Rational[] rationalArray) {
        QuadraticMatrix quadraticMatrix = this.mIntMatrix;
        int n2 = quadraticMatrix.getDimension();
        int n3 = 0;
        while (n3 < rationalArray.length) {
            rationalArray[n3] = Rational.valueOf((BigInteger)rationalArray[n3].numerator(), (BigInteger)rationalArray[n3].denominator());
            BigInteger bigInteger = Rational.gcd((BigInteger)rationalArray[n3].denominator(), (BigInteger)this.mDenominator);
            quadraticMatrix.setEntry(n3, n, rationalArray[n3].numerator().multiply(this.mDenominator.divide(bigInteger)));
            this.mDenominator = this.mDenominator.multiply(rationalArray[n3].denominator().divide(bigInteger));
            int n4 = 0;
            while (n4 < n2) {
                int n5 = 0;
                while (n5 < n2) {
                    quadraticMatrix.setEntry(n4, n5, quadraticMatrix.getEntry(n4, n5).multiply(rationalArray[n3].denominator().divide(bigInteger)));
                    ++n5;
                }
                ++n4;
            }
            quadraticMatrix.setEntry(n3, n, quadraticMatrix.getEntry(n3, n).divide(rationalArray[n3].denominator().divide(bigInteger)));
            ++n3;
        }
    }

    public void addRowToMatrix(int n, Rational[] rationalArray) {
        QuadraticMatrix quadraticMatrix = this.mIntMatrix;
        int n2 = quadraticMatrix.getDimension();
        int n3 = 0;
        while (n3 < rationalArray.length) {
            rationalArray[n3] = Rational.valueOf((BigInteger)rationalArray[n3].numerator(), (BigInteger)rationalArray[n3].denominator());
            BigInteger bigInteger = Rational.gcd((BigInteger)rationalArray[n3].denominator(), (BigInteger)this.mDenominator);
            quadraticMatrix.setEntry(n, n3, rationalArray[n3].numerator().multiply(this.mDenominator.divide(bigInteger)));
            this.mDenominator = this.mDenominator.multiply(rationalArray[n3].denominator().divide(bigInteger));
            int n4 = 0;
            while (n4 < n2) {
                int n5 = 0;
                while (n5 < n2) {
                    quadraticMatrix.setEntry(n4, n5, quadraticMatrix.getEntry(n4, n5).multiply(rationalArray[n3].denominator().divide(bigInteger)));
                    ++n5;
                }
                ++n4;
            }
            quadraticMatrix.setEntry(n, n3, quadraticMatrix.getEntry(n, n3).divide(rationalArray[n3].denominator().divide(bigInteger)));
            ++n3;
        }
    }

    public static Rational[] solveLes(RationalMatrix rationalMatrix, Rational[][] rationalArray, int n) {
        int n2 = rationalArray.length;
        RationalMatrix rationalMatrix2 = new RationalMatrix(BigInteger.valueOf(1L), QuadraticMatrix.gaussElimination(rationalMatrix.mIntMatrix));
        int n3 = rationalMatrix2.mIntMatrix.computeRank();
        int n4 = 0;
        while (n4 < n2) {
            rationalMatrix2.addRowToMatrix(n3 + n4, rationalArray[n4]);
            ++n4;
        }
        rationalMatrix2.mIntMatrix.setEntry(rationalMatrix2.mIntMatrix.computeRank() - 1, rationalMatrix2.mIntMatrix.getDimension() - 1, BigInteger.valueOf(1L));
        QuadraticMatrix quadraticMatrix = QuadraticMatrix.gaussElimination(rationalMatrix2.mIntMatrix);
        Rational[] rationalArray2 = QuadraticMatrix.backwardSubstitution(quadraticMatrix, n);
        return rationalArray2;
    }

    public QuadraticMatrix getIntMatrix() {
        return this.mIntMatrix;
    }

    public BigInteger getDenominator() {
        return this.mDenominator;
    }
}

