/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.pea2boogie.results;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IMessageProvider;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import de.uni_freiburg.informatik.ultimate.pea2boogie.results.ReqCheckMessageProvider;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class ReqCheck
extends Check {
    private static final long serialVersionUID = 6800618860906443122L;
    private final int mStartline;
    private final int mEndline;
    private final String[] mReqIds;
    private final String[] mPeaNames;

    public ReqCheck(Spec spec) {
        this(EnumSet.of(spec), 0, 0, new String[0], new String[0]);
    }

    public ReqCheck(Spec spec, String[] stringArray, String[] stringArray2) {
        this(EnumSet.of(spec), stringArray, stringArray2);
    }

    private ReqCheck(EnumSet<Spec> enumSet, String[] stringArray, String[] stringArray2) {
        this(enumSet, -1, -1, stringArray, stringArray2);
    }

    private ReqCheck(EnumSet<Spec> enumSet, int n, int n2, String[] stringArray, String[] stringArray2) {
        super(enumSet, (IMessageProvider)new ReqCheckMessageProvider());
        this.mStartline = n;
        this.mEndline = n2;
        this.mReqIds = stringArray;
        this.mPeaNames = stringArray2;
        this.registerMessageOverrides(enumSet, stringArray, stringArray2);
    }

    public int getStartLine() {
        return this.mStartline;
    }

    public int getEndLine() {
        return this.mEndline;
    }

    private void registerMessageOverrides(EnumSet<Spec> enumSet, String[] stringArray, String[] stringArray2) {
        IMessageProvider iMessageProvider = this.getMessageProvider();
        for (Spec spec : enumSet) {
            iMessageProvider.registerPositiveMessageOverride(spec, () -> String.format("%s %s", ReqCheck.getRequirementTexts(stringArray, stringArray2), iMessageProvider.getDefaultPositiveMessage(spec)));
            iMessageProvider.registerNegativeMessageOverride(spec, () -> String.format("%s %s", ReqCheck.getRequirementTexts(stringArray, stringArray2), iMessageProvider.getDefaultNegativeMessage(spec)));
        }
    }

    private static String getRequirementTexts(String[] stringArray, String[] stringArray2) {
        if (stringArray.length == 0) {
            return "All requirements are";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Requirement");
        if (stringArray.length != 1) {
            stringBuilder.append("s");
        }
        Iterator iterator = Arrays.stream(stringArray2).iterator();
        stringBuilder.append(" ").append((String)iterator.next());
        while (iterator.hasNext()) {
            stringBuilder.append(", ").append((String)iterator.next());
        }
        if (stringArray.length != 1) {
            stringBuilder.append(" are");
        } else {
            stringBuilder.append(" is");
        }
        return stringBuilder.toString();
    }

    public ReqCheck merge(ReqCheck reqCheck) {
        if (reqCheck == null) {
            return this;
        }
        if (reqCheck == this) {
            return this;
        }
        EnumSet<Spec> enumSet = EnumSet.copyOf(this.getSpec());
        enumSet.addAll(reqCheck.getSpec());
        int n = Math.min(this.mStartline, reqCheck.mStartline);
        int n2 = Math.max(this.mEndline, reqCheck.mEndline);
        String[] stringArray = (String[])DataStructureUtils.concat((Object[])this.mReqIds, (Object[])reqCheck.mReqIds);
        String[] stringArray2 = (String[])DataStructureUtils.concat((Object[])this.mPeaNames, (Object[])reqCheck.mPeaNames);
        return new ReqCheck(enumSet, n, n2, stringArray, stringArray2);
    }

    public Set<String> getReqIds() {
        return new LinkedHashSet<String>(Arrays.asList(this.mReqIds));
    }

    public Set<String> getPeaNames() {
        return new LinkedHashSet<String>(Arrays.asList(this.mPeaNames));
    }

    public String toString() {
        if (this.mReqIds.length == 0) {
            return super.toString() + " for all requirements";
        }
        return super.toString() + " for " + Arrays.stream(this.mReqIds).collect(Collectors.joining(", "));
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.mEndline;
        n = 31 * n + Arrays.hashCode(this.mReqIds);
        n = 31 * n + Arrays.hashCode(this.mPeaNames);
        n = 31 * n + this.mStartline;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        ReqCheck reqCheck = (ReqCheck)((Object)object);
        if (this.mStartline != reqCheck.mStartline) {
            return false;
        }
        if (this.mEndline != reqCheck.mEndline) {
            return false;
        }
        if (!Arrays.equals(this.mReqIds, reqCheck.mReqIds)) {
            return false;
        }
        return Arrays.equals(this.mPeaNames, reqCheck.mPeaNames);
    }
}

