/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.LiptonReductionStatisticsDefinitions;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.LiptonReductionStatisticsType;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsGeneratorWithStopwatches;
import java.util.Collection;

public class LiptonReductionStatisticsGenerator
extends StatisticsGeneratorWithStopwatches
implements IStatisticsDataProvider {
    private int mPlacesBefore = -1;
    private int mTransitionsBefore = -1;
    private int mCoEnabledTransitionPairs = -1;
    private int mPlacesAfterwards = -1;
    private int mTransitionsAfterwards = -1;
    private int mMoverChecksTotal;
    private int mNumberOfFixpointIterations = -1;
    private int mTrivialSequentialCompositions;
    private int mConcurrentSequentialCompositions;
    private int mTrivialYvCompositions;
    private int mConcurrentYvCompositions;
    private int mChoiceCompositions;
    private int mTotalNumberOfCompositions;

    public void reportFixpointIteration() {
        ++this.mNumberOfFixpointIterations;
    }

    public void reportMoverChecks(int n) {
        this.mMoverChecksTotal += n;
    }

    public void reportComposition(LiptonReductionStatisticsDefinitions liptonReductionStatisticsDefinitions) {
        switch (liptonReductionStatisticsDefinitions) {
            case TrivialSequentialCompositions: {
                ++this.mTrivialSequentialCompositions;
                break;
            }
            case ConcurrentSequentialCompositions: {
                ++this.mConcurrentSequentialCompositions;
                break;
            }
            case TrivialYvCompositions: {
                ++this.mTrivialYvCompositions;
                break;
            }
            case ConcurrentYvCompositions: {
                ++this.mConcurrentYvCompositions;
                break;
            }
            case ChoiceCompositions: {
                ++this.mChoiceCompositions;
                break;
            }
            default: {
                throw new UnsupportedOperationException("not an enum for a composition " + String.valueOf((Object)liptonReductionStatisticsDefinitions));
            }
        }
        ++this.mTotalNumberOfCompositions;
    }

    public void collectInitialStatistics(IPetriNet<?, ?> iPetriNet) {
        this.mPlacesBefore = iPetriNet.getPlaces().size();
        this.mTransitionsBefore = iPetriNet.getTransitions().size();
    }

    public void collectFinalStatistics(IPetriNet<?, ?> iPetriNet) {
        this.mPlacesAfterwards = iPetriNet.getPlaces().size();
        this.mTransitionsAfterwards = iPetriNet.getTransitions().size();
    }

    public void setCoEnabledTransitionPairs(int n) {
        this.mCoEnabledTransitionPairs = n;
    }

    public Collection<String> getKeys() {
        return LiptonReductionStatisticsType.getInstance().getKeys();
    }

    public Object getValue(String string) {
        LiptonReductionStatisticsDefinitions liptonReductionStatisticsDefinitions = LiptonReductionStatisticsDefinitions.valueOf(string);
        return this.getValue(liptonReductionStatisticsDefinitions);
    }

    public Object getValue(LiptonReductionStatisticsDefinitions liptonReductionStatisticsDefinitions) {
        Number number;
        switch (liptonReductionStatisticsDefinitions) {
            case ChoiceCompositions: {
                number = this.mChoiceCompositions;
                break;
            }
            case CoEnabledTransitionPairs: {
                number = this.mCoEnabledTransitionPairs;
                break;
            }
            case ConcurrentSequentialCompositions: {
                number = this.mConcurrentSequentialCompositions;
                break;
            }
            case ConcurrentYvCompositions: {
                number = this.mConcurrentYvCompositions;
                break;
            }
            case FixpointIterations: {
                number = this.mNumberOfFixpointIterations;
                break;
            }
            case MoverChecksTotal: {
                number = this.mMoverChecksTotal;
                break;
            }
            case PlacesAfterwards: {
                number = this.mPlacesAfterwards;
                break;
            }
            case PlacesBefore: {
                number = this.mPlacesBefore;
                break;
            }
            case ReductionTime: {
                try {
                    number = this.getElapsedTime(liptonReductionStatisticsDefinitions.toString());
                    break;
                }
                catch (StatisticsGeneratorWithStopwatches.StopwatchStillRunningException stopwatchStillRunningException) {
                    throw new AssertionError((Object)("clock still running: " + String.valueOf((Object)liptonReductionStatisticsDefinitions)));
                }
            }
            case TotalNumberOfCompositions: {
                number = this.mTotalNumberOfCompositions;
                break;
            }
            case TransitionsAfterwards: {
                number = this.mTransitionsAfterwards;
                break;
            }
            case TransitionsBefore: {
                number = this.mTransitionsBefore;
                break;
            }
            case TrivialSequentialCompositions: {
                number = this.mTrivialSequentialCompositions;
                break;
            }
            case TrivialYvCompositions: {
                number = this.mTrivialYvCompositions;
                break;
            }
            default: {
                throw new MatchException(null, null);
            }
        }
        return number;
    }

    public IStatisticsType getBenchmarkType() {
        return LiptonReductionStatisticsType.getInstance();
    }

    public String[] getStopwatches() {
        return new String[]{LiptonReductionStatisticsDefinitions.ReductionTime.toString()};
    }
}

