/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.LTLPrettyPrinter;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.UnaryExpression;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class LTLExpressionExtractor {
    private String mLTLFormatString;
    private LinkedHashMap<String, Expression> mMap;
    private static final String ALPHABET = "ABCDEHIJKLMNOPQRSTVWYZ";

    public boolean run(ACSLNode aCSLNode) {
        LTLPrettyPrinter lTLPrettyPrinter = new LTLPrettyPrinter();
        this.mMap = null;
        aCSLNode = this.removeWeakUntil(aCSLNode);
        LTLExtractSubexpressions lTLExtractSubexpressions = new LTLExtractSubexpressions();
        aCSLNode.accept((ACSLVisitor)lTLExtractSubexpressions);
        this.mLTLFormatString = lTLPrettyPrinter.print(aCSLNode);
        if (lTLExtractSubexpressions.getResult() != null) {
            this.mMap = new LinkedHashMap();
            this.mLTLFormatString = new LTLFormatStringPrinter(new HashSet<Expression>(lTLExtractSubexpressions.getResult()), this.mMap).print(aCSLNode);
            return true;
        }
        return false;
    }

    public ACSLNode removeWeakUntil(ACSLNode aCSLNode) {
        return aCSLNode.accept((ACSLTransformer)new LTLReplaceWeakUntil());
    }

    public Map<String, Expression> getAP2SubExpressionMap() {
        return this.mMap;
    }

    public String getLTLFormatString() {
        return this.mLTLFormatString;
    }

    public static String getAPSymbol(int n) {
        if (n < ALPHABET.length()) {
            return String.valueOf(ALPHABET.charAt(n));
        }
        StringBuilder stringBuilder = new StringBuilder("A");
        int n2 = n;
        while (n2 > ALPHABET.length()) {
            stringBuilder.append(ALPHABET.charAt((n2 -= ALPHABET.length()) % ALPHABET.length()));
        }
        return stringBuilder.toString();
    }

    private static final class LTLExtractSubexpressions
    extends ACSLVisitor {
        private Expression mCurrentSubExpression = null;
        private final HashSet<Expression> mExpressions = new HashSet();

        LTLExtractSubexpressions() {
        }

        public Collection<Expression> getResult() {
            return this.mExpressions;
        }

        public boolean visit(BinaryExpression binaryExpression) {
            switch (binaryExpression.getOperator()) {
                case LTLUNTIL: 
                case LTLRELEASE: 
                case LTLWEAKUNTIL: {
                    this.mCurrentSubExpression = null;
                    return super.visit(binaryExpression);
                }
            }
            if (this.mCurrentSubExpression == null) {
                LTLExtractSubexpressions lTLExtractSubexpressions = new LTLExtractSubexpressions();
                LTLExtractSubexpressions lTLExtractSubexpressions2 = new LTLExtractSubexpressions();
                binaryExpression.getLeft().accept((ACSLVisitor)lTLExtractSubexpressions);
                binaryExpression.getRight().accept((ACSLVisitor)lTLExtractSubexpressions2);
                if (lTLExtractSubexpressions.getResult().isEmpty() && lTLExtractSubexpressions2.getResult().isEmpty()) {
                    this.mCurrentSubExpression = binaryExpression;
                } else {
                    boolean bl = false;
                    boolean bl2 = false;
                    HashSet<Expression> hashSet = new HashSet<Expression>();
                    for (Expression expression : lTLExtractSubexpressions.getResult()) {
                        hashSet.add(expression);
                        if (expression != binaryExpression.getLeft()) continue;
                        bl = true;
                    }
                    for (Expression expression : lTLExtractSubexpressions2.getResult()) {
                        hashSet.add(expression);
                        if (expression != binaryExpression.getRight()) continue;
                        bl2 = true;
                    }
                    if ((bl2 || lTLExtractSubexpressions2.getResult().isEmpty()) && (bl || lTLExtractSubexpressions.getResult().isEmpty())) {
                        this.mCurrentSubExpression = binaryExpression;
                    } else {
                        this.mExpressions.addAll(hashSet);
                        return false;
                    }
                }
            }
            return super.visit(binaryExpression);
        }

        public boolean visit(UnaryExpression unaryExpression) {
            switch (unaryExpression.getOperator()) {
                case LTLGLOBALLY: 
                case LTLFINALLY: 
                case LTLNEXT: {
                    this.mCurrentSubExpression = null;
                    return super.visit(unaryExpression);
                }
            }
            if (this.mCurrentSubExpression == null) {
                LTLExtractSubexpressions lTLExtractSubexpressions = new LTLExtractSubexpressions();
                unaryExpression.getExpr().accept((ACSLVisitor)lTLExtractSubexpressions);
                if (lTLExtractSubexpressions.getResult().isEmpty()) {
                    this.mCurrentSubExpression = unaryExpression;
                } else {
                    for (Expression expression : lTLExtractSubexpressions.getResult()) {
                        if (expression != unaryExpression.getExpr()) continue;
                        this.mCurrentSubExpression = unaryExpression;
                    }
                    if (this.mCurrentSubExpression == null) {
                        this.mExpressions.addAll(lTLExtractSubexpressions.getResult());
                        return false;
                    }
                }
            }
            return super.visit(unaryExpression);
        }

        public boolean visit(BooleanLiteral booleanLiteral) {
            this.literalReached();
            return super.visit(booleanLiteral);
        }

        public boolean visit(IdentifierExpression identifierExpression) {
            this.literalReached();
            return super.visit(identifierExpression);
        }

        public boolean visit(IntegerLiteral integerLiteral) {
            this.literalReached();
            return super.visit(integerLiteral);
        }

        public boolean visit(RealLiteral realLiteral) {
            this.literalReached();
            return super.visit(realLiteral);
        }

        private void literalReached() {
            if (this.mCurrentSubExpression != null && this.mExpressions != null) {
                this.mExpressions.add(this.mCurrentSubExpression);
                this.mCurrentSubExpression = null;
            }
        }

        public String toString() {
            if (this.mExpressions == null || this.mExpressions.isEmpty()) {
                return "EMTPY";
            }
            return this.mExpressions.toString();
        }
    }

    private static final class LTLFormatStringPrinter
    extends LTLPrettyPrinter {
        private final Map<String, Expression> mApString2Expr;
        private final Set<Expression> mSubExpressions;
        private final Map<String, String> mExprString2APString;
        private int mAPCounter;

        public LTLFormatStringPrinter(Set<Expression> set, Map<String, Expression> map) {
            this.mApString2Expr = map;
            this.mSubExpressions = set;
            this.mAPCounter = 0;
            this.mExprString2APString = new HashMap<String, String>();
        }

        public boolean visit(Expression expression) {
            if (this.mSubExpressions.contains(expression)) {
                String string = new LTLPrettyPrinter().print((ACSLNode)expression);
                String string2 = this.mExprString2APString.get(string);
                if (string2 == null) {
                    string2 = LTLExpressionExtractor.getAPSymbol(this.mAPCounter);
                    this.mApString2Expr.put(string2, expression);
                    this.mExprString2APString.put(string, string2);
                    ++this.mAPCounter;
                }
                this.mBuilder.append(string2);
                return false;
            }
            return true;
        }
    }

    private static final class LTLReplaceWeakUntil
    extends ACSLTransformer {
        private LTLReplaceWeakUntil() {
        }

        public Expression transform(BinaryExpression binaryExpression) {
            if (binaryExpression.getOperator().equals((Object)BinaryExpression.Operator.LTLWEAKUNTIL)) {
                Expression expression = binaryExpression.getLeft().accept((ACSLTransformer)this);
                Expression expression2 = binaryExpression.getRight().accept((ACSLTransformer)this);
                BinaryExpression binaryExpression2 = new BinaryExpression(BinaryExpression.Operator.LTLUNTIL, expression, expression2);
                UnaryExpression unaryExpression = new UnaryExpression(UnaryExpression.Operator.LTLGLOBALLY, expression);
                BinaryExpression binaryExpression3 = new BinaryExpression(BinaryExpression.Operator.LOGICOR, (Expression)binaryExpression2, (Expression)unaryExpression);
                this.addAdditionalInfo(binaryExpression, (Expression)binaryExpression2);
                this.addAdditionalInfo(binaryExpression, (Expression)unaryExpression);
                this.addAdditionalInfo(binaryExpression, (Expression)binaryExpression3);
                return binaryExpression3;
            }
            return super.transform(binaryExpression);
        }

        private void addAdditionalInfo(BinaryExpression binaryExpression, Expression expression) {
            expression.setLocation(binaryExpression.getLocation());
            expression.setFileName(binaryExpression.getFileName());
            expression.setType(binaryExpression.getType());
        }
    }
}

