/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.rabin;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.rabin.IRabinAutomaton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.TransformIterator;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class RabinAutomaton<LETTER, STATE>
implements IRabinAutomaton<LETTER, STATE> {
    private final Set<LETTER> mAlphabet;
    private final Set<STATE> mStates;
    private final Set<STATE> mInitialStates;
    private final Set<STATE> mAcceptingStates;
    private final Set<STATE> mFiniteStates;
    private final NestedMap2<STATE, LETTER, Set<STATE>> mTransitions;

    public RabinAutomaton(Set<LETTER> set, Set<STATE> set2, Set<STATE> set3, Set<STATE> set4, Set<STATE> set5, NestedMap2<STATE, LETTER, Set<STATE>> nestedMap2) {
        this.mAlphabet = set;
        this.mStates = set2;
        this.mInitialStates = set3;
        this.mAcceptingStates = set4;
        this.mFiniteStates = set5;
        this.mTransitions = nestedMap2;
    }

    public Set<STATE> getStates() {
        return this.mStates;
    }

    public Set<STATE> getAcceptingStates() {
        return this.mAcceptingStates;
    }

    public Set<STATE> getFiniteStates() {
        return this.mFiniteStates;
    }

    @Override
    public Set<LETTER> getAlphabet() {
        return this.mAlphabet;
    }

    @Override
    public int size() {
        return this.mStates.size();
    }

    @Override
    public String sizeInformation() {
        return "Number of states: " + this.size() + ", number of transitions: " + this.mTransitions.values().mapToInt(Set::size).sum();
    }

    @Override
    public Set<STATE> getInitialStates() {
        return this.mInitialStates;
    }

    @Override
    public boolean isAccepting(STATE STATE) {
        return this.mAcceptingStates.contains(STATE);
    }

    @Override
    public boolean isFinite(STATE STATE) {
        return this.mFiniteStates.contains(STATE);
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> getSuccessors(STATE STATE) {
        Map map = this.mTransitions.get(STATE);
        if (map == null) {
            return () -> Collections.emptyIterator();
        }
        return () -> map.entrySet().stream().flatMap(entry -> ((Set)entry.getValue()).stream().map(object -> new OutgoingInternalTransition(entry.getKey(), object))).iterator();
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> getSuccessors(STATE STATE, LETTER LETTER) {
        Set set = (Set)this.mTransitions.get(STATE, LETTER);
        if (set == null) {
            return () -> Collections.emptyIterator();
        }
        return () -> new TransformIterator(set.iterator(), object2 -> new OutgoingInternalTransition<Object, Object>(LETTER, object2));
    }

    public NestedMap2<STATE, LETTER, Set<STATE>> getTransitions() {
        return this.mTransitions;
    }
}

