/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.toolchain;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.RcpProgressMonitorWrapper;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.ParserInitializationException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.toolchain.DefaultToolchainJob;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.model.IController;
import de.uni_freiburg.informatik.ultimate.core.model.ICore;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchain;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainData;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainProgressMonitor;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RerunFreshToolchainJob
extends DefaultToolchainJob {
    private final IToolchainData<RunDefinition> mData;

    public RerunFreshToolchainJob(String string, ICore<RunDefinition> iCore, IController<RunDefinition> iController, ILogger iLogger, IToolchainData<RunDefinition> iToolchainData, File[] fileArray) {
        super(string, iCore, iController, iLogger, fileArray);
        this.mData = iToolchainData;
    }

    @Override
    protected IStatus run(IProgressMonitor iProgressMonitor) {
        IToolchainProgressMonitor iToolchainProgressMonitor = RcpProgressMonitorWrapper.create(iProgressMonitor);
        iToolchainProgressMonitor.beginTask(this.getName(), -1);
        try {
            this.setToolchain((IToolchain<RunDefinition>)this.mCore.requestToolchain(this.mInputFiles));
            iToolchainProgressMonitor.worked(1);
            this.mToolchain.init(iToolchainProgressMonitor);
            iToolchainProgressMonitor.worked(1);
            if (!this.mToolchain.initializeParsers()) {
                throw new ParserInitializationException();
            }
            iToolchainProgressMonitor.worked(1);
            IToolchainData iToolchainData = this.mToolchain.setToolSelection(iToolchainProgressMonitor, this.mData);
            if (iToolchainData == null) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.setServices(iToolchainData.getServices());
            iToolchainProgressMonitor.worked(1);
            this.mToolchain.runParsers();
            iToolchainProgressMonitor.worked(1);
            IStatus iStatus = this.convert(this.mToolchain.processToolchain(iToolchainProgressMonitor));
            return iStatus;
        }
        catch (Throwable throwable) {
            IStatus iStatus = this.handleException(throwable);
            return iStatus;
        }
        finally {
            iToolchainProgressMonitor.done();
            this.releaseToolchain();
        }
    }
}

