/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.counting.datastructures;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import java.math.BigInteger;
import java.util.Objects;

public interface IAtomicCounterGuard {

    public static class SingleCounterGuard
    implements IAtomicCounterGuard {
        private final RelationSymbol mRelationSymbol;
        private final String mLhsCounter;
        private final BigInteger mRhsNaturalNumber;

        public SingleCounterGuard(RelationSymbol relationSymbol, String string, BigInteger bigInteger) {
            Objects.nonNull(relationSymbol);
            Objects.nonNull(string);
            Objects.nonNull(bigInteger);
            this.mRelationSymbol = relationSymbol;
            this.mLhsCounter = string;
            this.mRhsNaturalNumber = bigInteger;
        }

        public RelationSymbol getRelationSymbol() {
            return this.mRelationSymbol;
        }

        public String getLhsCounter() {
            return this.mLhsCounter;
        }

        public BigInteger getRhsNaturalNumber() {
            return this.mRhsNaturalNumber;
        }

        public String toString() {
            return String.format("(%s %s %s))", this.getRelationSymbol(), this.getLhsCounter(), this.getRhsNaturalNumber());
        }
    }

    public static class TermEqualityTest
    implements IAtomicCounterGuard {
        private final String mLhsCounter;
        private final String mRhsCounter;
        private final BigInteger mRhsNaturalNumber;

        public TermEqualityTest(String string, String string2, BigInteger bigInteger) {
            Objects.requireNonNull(string);
            Objects.requireNonNull(string2);
            Objects.requireNonNull(bigInteger);
            this.mLhsCounter = string;
            this.mRhsCounter = string2;
            this.mRhsNaturalNumber = bigInteger;
        }

        public String getLhsCounter() {
            return this.mLhsCounter;
        }

        public String getRhsCounter() {
            return this.mRhsCounter;
        }

        public BigInteger getRhsNaturalNumber() {
            return this.mRhsNaturalNumber;
        }

        public String toString() {
            if (this.getRhsNaturalNumber().compareTo(BigInteger.ZERO) >= 0) {
                return String.format("(= %s (+ %s %s))", this.getLhsCounter(), this.getRhsCounter(), this.getRhsNaturalNumber());
            }
            return String.format("(= (+ %s %s) %s )", this.getLhsCounter(), this.getRhsNaturalNumber().negate(), this.getRhsCounter());
        }
    }
}

