/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure;

import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CcManager;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraint;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintConjunction;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintManager;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CCLiteralSetConstraints<ELEM extends ICongruenceClosureElement<ELEM>> {
    private final CcManager<ELEM> mCcManager;
    SetConstraintManager<ELEM> mSetConstraintManager;
    private CongruenceClosure<ELEM> mCongruenceClosure;
    private Map<ELEM, SetConstraintConjunction<ELEM>> mContainsConstraints;
    private boolean mIsInconsistent;

    public CCLiteralSetConstraints(CcManager<ELEM> ccManager, CongruenceClosure<ELEM> congruenceClosure) {
        this.mCcManager = ccManager;
        this.mCongruenceClosure = congruenceClosure;
        this.mSetConstraintManager = ccManager.getSetConstraintManager();
        this.mContainsConstraints = new HashMap<ELEM, SetConstraintConjunction<ELEM>>();
        this.mIsInconsistent = false;
    }

    CCLiteralSetConstraints(CcManager<ELEM> ccManager, CongruenceClosure<ELEM> congruenceClosure, CCLiteralSetConstraints<ELEM> cCLiteralSetConstraints) {
        assert (!cCLiteralSetConstraints.isInconsistent());
        this.mCcManager = ccManager;
        this.mCongruenceClosure = congruenceClosure;
        this.mSetConstraintManager = ccManager.getSetConstraintManager();
        this.mContainsConstraints = new HashMap<ELEM, SetConstraintConjunction<ELEM>>();
        for (Map.Entry<ELEM, SetConstraintConjunction<ELEM>> entry : cCLiteralSetConstraints.getConstraints().entrySet()) {
            this.mContainsConstraints.put((ICongruenceClosureElement)entry.getKey(), new SetConstraintConjunction<ELEM>(this, entry.getValue()));
        }
        this.mIsInconsistent = false;
    }

    public HashRelation<ELEM, ELEM> reportContains(ELEM ELEM, Set<SetConstraint<ELEM>> set) {
        assert (this.sanityCheck());
        ELEM ELEM2 = this.mCongruenceClosure.getRepresentativeElement(ELEM);
        Set<SetConstraint<ELEM>> set2 = this.mSetConstraintManager.updateOnChangedRepresentative(set, this.mCongruenceClosure);
        Set<SetConstraint<ELEM>> set3 = this.getConstraint(ELEM);
        this.mContainsConstraints.remove(ELEM2);
        Set<SetConstraint<ELEM>> set4 = set3 != null ? DataStructureUtils.union(set3, set2) : set2;
        HashRelation<ELEM, ELEM> hashRelation = null;
        if (set4 != null) {
            hashRelation = this.updateContainsConstraintApplyPropagations(ELEM2, set4);
        }
        return hashRelation;
    }

    public HashRelation<ELEM, ELEM> reportContains(ELEM ELEM, Collection<ELEM> collection) {
        assert (this.sanityCheck());
        if (this.isInconsistent()) {
            return null;
        }
        this.mCcManager.addElement(this.mCongruenceClosure, ELEM, true, false);
        this.mCcManager.addAllElements(this.mCongruenceClosure, collection, null, true);
        ELEM ELEM2 = this.mCongruenceClosure.getRepresentativeElement(ELEM);
        return this.reportContains(ELEM2, Collections.singleton(this.mSetConstraintManager.buildSetConstraint(collection)));
    }

    private HashRelation<ELEM, ELEM> updateContainsConstraintApplyPropagations(ELEM ELEM, Set<SetConstraint<ELEM>> set) {
        SetConstraintConjunction<ELEM> setConstraintConjunction2;
        assert (!this.mContainsConstraints.containsKey(ELEM)) : "assuming this has been removed before";
        assert (this.mCongruenceClosure.isRepresentative(ELEM));
        assert (this.sanityCheck());
        HashRelation<ELEM, Object> hashRelation = new HashRelation<ELEM, Object>();
        Set<SetConstraint<ELEM>> set2 = this.mSetConstraintManager.filterWithDisequalities(this.mCongruenceClosure, ELEM, set);
        if (set2.stream().anyMatch(SetConstraint::isInconsistent)) {
            this.reportInconsistency();
            return hashRelation;
        }
        Set<SetConstraint<ELEM>> set3 = this.mCcManager.normalizeSetConstraintConjunction(this, set2);
        for (SetConstraintConjunction<ELEM> setConstraintConjunction2 : this.mSetConstraintManager.getSingletonValues(set3)) {
            if (ELEM.equals(setConstraintConjunction2)) continue;
            hashRelation.addPair(ELEM, setConstraintConjunction2);
        }
        setConstraintConjunction2 = this.mCcManager.buildSetConstraintConjunction(this, ELEM, set3);
        if (!setConstraintConjunction2.isTautological()) {
            this.putContainsConstraint(ELEM, setConstraintConjunction2);
        }
        assert (this.sanityCheck());
        return hashRelation;
    }

    private void reportInconsistency() {
        this.mIsInconsistent = true;
        this.mContainsConstraints = null;
    }

    /*
     * WARNING - void declaration
     */
    public HashRelation<ELEM, ELEM> reportEquality(ELEM ELEM, ELEM ELEM2, ELEM ELEM3) {
        void var7_11;
        assert (this.mCongruenceClosure.getRepresentativeElement(ELEM) == ELEM3);
        assert (this.mCongruenceClosure.getRepresentativeElement(ELEM2) == ELEM3);
        if (this.isInconsistent()) {
            return null;
        }
        Set<SetConstraint<ELEM>> set = this.getConstraint(ELEM);
        Set<SetConstraint<ELEM>> set2 = this.getConstraint(ELEM2);
        this.mContainsConstraints.remove(ELEM);
        this.mContainsConstraints.remove(ELEM2);
        if (set != null) {
            set = this.mSetConstraintManager.updateOnChangedRepresentative(set, ELEM, ELEM2, ELEM3);
        }
        if (set2 != null) {
            set2 = this.mSetConstraintManager.updateOnChangedRepresentative(set2, ELEM, ELEM2, ELEM3);
        }
        Set<SetConstraint<ELEM>> set3 = null;
        if (set != null && set2 != null) {
            set3 = this.mSetConstraintManager.meet(this, set, set2);
        } else if (set != null) {
            set3 = set;
        } else if (set2 != null) {
            set3 = set2;
        }
        for (Map.Entry<ELEM, SetConstraintConjunction<ELEM>> object2 : new HashSet<Map.Entry<ELEM, SetConstraintConjunction<ELEM>>>(this.mContainsConstraints.entrySet())) {
            Set<SetConstraint<ELEM>> set4 = object2.getValue().getSetConstraints();
            Set<SetConstraint<ELEM>> set5 = this.mSetConstraintManager.updateOnChangedRepresentative(set4, ELEM, ELEM2, ELEM3);
            assert (set5 == set4 || this.mSetConstraintManager.getSingletonValues(set5).isEmpty());
            SetConstraintConjunction<ELEM> setConstraintConjunction = set5 == set4 ? object2.getValue() : this.mCcManager.buildSetConstraintConjunction(this, (ICongruenceClosureElement)object2.getKey(), set5);
            this.mContainsConstraints.put((ICongruenceClosureElement)object2.getKey(), setConstraintConjunction);
        }
        Object var7_9 = null;
        if (set3 != null) {
            HashRelation<ELEM, ELEM> hashRelation = this.updateContainsConstraintApplyPropagations(ELEM3, set3);
        }
        assert (this.sanityCheck());
        return var7_11;
    }

    public CCLiteralSetConstraints<ELEM> merge(CongruenceClosure<ELEM> congruenceClosure, HashRelation<ELEM, ELEM> hashRelation, HashRelation<ELEM, ELEM> hashRelation2, CCLiteralSetConstraints<ELEM> cCLiteralSetConstraints, BinaryOperator<Set<SetConstraint<ELEM>>> binaryOperator) {
        if (this.isInconsistent()) {
            return cCLiteralSetConstraints;
        }
        if (cCLiteralSetConstraints.isInconsistent()) {
            return this;
        }
        CCLiteralSetConstraints cCLiteralSetConstraints2 = new CCLiteralSetConstraints(this.mCcManager, congruenceClosure);
        HashMap<ICongruenceClosureElement, SetConstraintConjunction<ICongruenceClosureElement>> hashMap = new HashMap<ICongruenceClosureElement, SetConstraintConjunction<ICongruenceClosureElement>>();
        for (ICongruenceClosureElement iCongruenceClosureElement : congruenceClosure.getAllRepresentatives()) {
            Set<SetConstraint<ICongruenceClosureElement>> set = this.getConstraintWrtSplit(iCongruenceClosureElement, congruenceClosure, hashRelation);
            Set<SetConstraint<ICongruenceClosureElement>> set2 = cCLiteralSetConstraints.getConstraintWrtSplit(iCongruenceClosureElement, congruenceClosure, hashRelation2);
            Set set3 = (Set)binaryOperator.apply(set, set2);
            assert (this.mSetConstraintManager.getSingletonValues(set3).stream().filter(iCongruenceClosureElement2 -> !congruenceClosure.getRepresentativeElement(iCongruenceClosureElement2).equals(iCongruenceClosureElement)).collect(Collectors.toSet()).isEmpty()) : "created non-tautological singleton set constraints --> report them, befor buildSetConstraintConj.. throws them away!";
            SetConstraintConjunction<ICongruenceClosureElement> setConstraintConjunction = this.mCcManager.buildSetConstraintConjunction(cCLiteralSetConstraints2, iCongruenceClosureElement, set3);
            if (SetConstraintManager.isTautological(setConstraintConjunction)) continue;
            hashMap.put(iCongruenceClosureElement, setConstraintConjunction);
        }
        cCLiteralSetConstraints2.setContainsConstraints(hashMap);
        return cCLiteralSetConstraints2;
    }

    private void setContainsConstraints(Map<ELEM, SetConstraintConjunction<ELEM>> map) {
        this.mContainsConstraints = map;
    }

    public boolean isStrongerThan(CCLiteralSetConstraints<ELEM> cCLiteralSetConstraints) {
        assert (CcManager.isPartitionStronger(this.getCongruenceClosure().mElementTVER, cCLiteralSetConstraints.getCongruenceClosure().mElementTVER)) : "assuming this has been checked already";
        HashSet<ELEM> hashSet = new HashSet<ELEM>(this.mContainsConstraints.keySet());
        hashSet.addAll(cCLiteralSetConstraints.mContainsConstraints.keySet());
        HashRelation<ELEM, ELEM> hashRelation = CcManager.computeSplitInfo(this.getCongruenceClosure(), cCLiteralSetConstraints.getCongruenceClosure());
        for (ICongruenceClosureElement iCongruenceClosureElement : hashSet) {
            Set set;
            Set set2 = this.getConstraintWrtSplit(iCongruenceClosureElement, cCLiteralSetConstraints.getCongruenceClosure(), hashRelation);
            if (this.mSetConstraintManager.isStrongerThan(set2, set = cCLiteralSetConstraints.getConstraint(iCongruenceClosureElement))) continue;
            return false;
        }
        return true;
    }

    public boolean isInconsistent() {
        return this.mIsInconsistent;
    }

    boolean sanityCheck() {
        if (this.mIsInconsistent) {
            return true;
        }
        for (Map.Entry<ELEM, SetConstraintConjunction<ELEM>> object : this.mContainsConstraints.entrySet()) {
            if (!this.mCongruenceClosure.isRepresentative((ICongruenceClosureElement)object.getKey())) {
                assert (false);
                return false;
            }
            if (!object.getValue().isTautological()) continue;
            assert (false);
            return false;
        }
        for (SetConstraintConjunction setConstraintConjunction : this.mContainsConstraints.values()) {
            if (!setConstraintConjunction.sanityCheck()) {
                assert (false);
                return false;
            }
            if (setConstraintConjunction.mSurroundingCCSetConstraints == this) continue;
            assert (false);
            return false;
        }
        if (this.mCongruenceClosure.mLiteralSetConstraints != this) {
            assert (false);
            return false;
        }
        return true;
    }

    public Map<ELEM, SetConstraintConjunction<ELEM>> getConstraints() {
        return Collections.unmodifiableMap(this.mContainsConstraints);
    }

    Set<SetConstraint<ELEM>> getConstraint(ELEM ELEM) {
        SetConstraintConjunction<ELEM> setConstraintConjunction;
        if (!this.mCongruenceClosure.hasElement(ELEM)) {
            return null;
        }
        HashSet<SetConstraint<ELEM>> hashSet = new HashSet<SetConstraint<ELEM>>();
        ELEM ELEM2 = this.mCongruenceClosure.getRepresentativeElement(ELEM);
        hashSet.add(this.mSetConstraintManager.buildSetConstraint(Collections.singleton(ELEM2)));
        SetConstraintConjunction<ELEM> setConstraintConjunction2 = this.mContainsConstraints.get(ELEM2);
        if (setConstraintConjunction2 != null) {
            hashSet.addAll(setConstraintConjunction2.getSetConstraints());
        }
        if ((setConstraintConjunction = this.mContainsConstraints.get(ELEM)) != null) {
            hashSet.addAll(setConstraintConjunction.getSetConstraints());
        }
        if (hashSet.isEmpty()) {
            return null;
        }
        return hashSet;
    }

    private Set<SetConstraint<ELEM>> getConstraintWrtSplit(ELEM ELEM, CongruenceClosure<ELEM> congruenceClosure, HashRelation<ELEM, ELEM> hashRelation) {
        if (!this.mCongruenceClosure.hasElement(ELEM)) {
            return null;
        }
        Set<SetConstraint<ELEM>> set = this.getConstraint(ELEM);
        if (set == null) {
            return null;
        }
        HashSet<SetConstraint<Object>> hashSet = new HashSet<SetConstraint<ELEM>>(set);
        for (ICongruenceClosureElement iCongruenceClosureElement : hashRelation.getDomain()) {
            assert (!this.mCongruenceClosure.hasElement(iCongruenceClosureElement) || this.mCongruenceClosure.isRepresentative(iCongruenceClosureElement));
            HashSet<SetConstraint<ICongruenceClosureElement>> hashSet2 = new HashSet<SetConstraint<ICongruenceClosureElement>>();
            for (SetConstraint setConstraint : hashSet) {
                for (ICongruenceClosureElement iCongruenceClosureElement2 : hashRelation.getImage(iCongruenceClosureElement)) {
                    assert (congruenceClosure.isRepresentative(iCongruenceClosureElement2));
                    hashSet2.add(this.mSetConstraintManager.transformElements(setConstraint, iCongruenceClosureElement3 -> iCongruenceClosureElement3.equals(iCongruenceClosureElement) ? iCongruenceClosureElement2 : iCongruenceClosureElement3));
                }
            }
            hashSet = hashSet2;
        }
        return hashSet;
    }

    public void setCongruenceClosure(CongruenceClosure<ELEM> congruenceClosure) {
        assert (this.mCongruenceClosure == null) : "never re-set the congruence closure!";
        this.mCongruenceClosure = congruenceClosure;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CCLiteralSetConstraints:\n");
        for (Map.Entry<ELEM, SetConstraintConjunction<ELEM>> entry : this.getConstraints().entrySet()) {
            stringBuilder.append(entry.getValue());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public void projectAway(ELEM ELEM) {
        this.mContainsConstraints.remove(ELEM);
        for (Map.Entry<ELEM, SetConstraintConjunction<ELEM>> entry : new HashSet<Map.Entry<ELEM, SetConstraintConjunction<ELEM>>>(this.mContainsConstraints.entrySet())) {
            entry.getValue().projectAway(ELEM);
            if (!entry.getValue().isTautological()) continue;
            this.mContainsConstraints.remove(entry.getKey());
        }
    }

    public void replaceRepresentative(ELEM ELEM, ELEM ELEM2) {
        SetConstraintConjunction<ELEM> setConstraintConjunction = this.mContainsConstraints.remove(ELEM);
        if (setConstraintConjunction != null && ELEM2 != null) {
            this.putContainsConstraint(ELEM2, setConstraintConjunction);
        }
        for (Map.Entry<ELEM, SetConstraintConjunction<ELEM>> entry : new HashSet<Map.Entry<ELEM, SetConstraintConjunction<ELEM>>>(this.mContainsConstraints.entrySet())) {
            Set<SetConstraint<ELEM>> set = entry.getValue().getSetConstraints();
            Set<SetConstraint<ELEM>> set2 = this.mSetConstraintManager.updateOnChangedRepresentative(set, ELEM, ELEM2);
            assert (this.mSetConstraintManager.getSingletonValues(set2).isEmpty());
            SetConstraintConjunction<ELEM> setConstraintConjunction2 = set2 == set ? entry.getValue() : this.mCcManager.buildSetConstraintConjunction(this, (ICongruenceClosureElement)entry.getKey(), set2);
            this.putContainsConstraint((ICongruenceClosureElement)entry.getKey(), setConstraintConjunction2);
        }
    }

    public SetConstraintConjunction<ELEM> putContainsConstraint(ELEM ELEM, SetConstraintConjunction<ELEM> setConstraintConjunction) {
        assert (setConstraintConjunction.mSurroundingCCSetConstraints == this);
        return this.mContainsConstraints.put(ELEM, setConstraintConjunction);
    }

    public void reportDisequality(ELEM ELEM, ELEM ELEM2) {
        SetConstraintConjunction<ELEM> setConstraintConjunction;
        Set<SetConstraint<ELEM>> set;
        ELEM ELEM3 = this.mCongruenceClosure.getRepresentativeElement(ELEM);
        ELEM ELEM4 = this.mCongruenceClosure.getRepresentativeElement(ELEM2);
        assert (!ELEM3.isLiteral() || !ELEM4.isLiteral()) : "literal disequalities should be implicit and not reported";
        Set<SetConstraint<ELEM>> set2 = this.getConstraint(ELEM4);
        if (set2 != null && (set = this.mSetConstraintManager.filterWithDisequality(set2, ELEM3)) != set2) {
            assert (this.mSetConstraintManager.getSingletonValues(set).isEmpty());
            setConstraintConjunction = this.mCcManager.buildSetConstraintConjunction(this, ELEM4, set);
            if (setConstraintConjunction.isInconsistent()) {
                this.reportInconsistency();
            }
            this.putContainsConstraint(ELEM4, setConstraintConjunction);
        }
        if ((set2 = this.getConstraint(ELEM3)) != null && (set = this.mSetConstraintManager.filterWithDisequality(set2, ELEM4)) != set2) {
            setConstraintConjunction = this.mCcManager.buildSetConstraintConjunction(this, ELEM3, set);
            if (setConstraintConjunction.isInconsistent()) {
                this.reportInconsistency();
            }
            this.putContainsConstraint(ELEM3, setConstraintConjunction);
        }
    }

    public CCLiteralSetConstraints<ELEM> filterAndKeepOnlyConstraintsThatIntersectWith(Set<ELEM> set) {
        assert (!this.isInconsistent()) : "handle this case";
        CCLiteralSetConstraints<ICongruenceClosureElement> cCLiteralSetConstraints = new CCLiteralSetConstraints<ICongruenceClosureElement>(this.mCcManager, null);
        for (Map.Entry<ELEM, SetConstraintConjunction<ELEM>> entry : this.mContainsConstraints.entrySet()) {
            if (set.contains(entry.getKey())) {
                cCLiteralSetConstraints.putContainsConstraint((ICongruenceClosureElement)entry.getKey(), new SetConstraintConjunction<ELEM>(cCLiteralSetConstraints, entry.getValue()));
            }
            if (!DataStructureUtils.haveNonEmptyIntersection(set, entry.getValue().getAllRhsElements())) continue;
            cCLiteralSetConstraints.putContainsConstraint((ICongruenceClosureElement)entry.getKey(), new SetConstraintConjunction<ELEM>(cCLiteralSetConstraints, entry.getValue()));
        }
        assert (!cCLiteralSetConstraints.isInconsistent());
        return cCLiteralSetConstraints;
    }

    public void transformElements(Function<ELEM, ELEM> function) {
        HashMap<ELEM, SetConstraintConjunction<ELEM>> hashMap = new HashMap<ELEM, SetConstraintConjunction<ELEM>>(this.mContainsConstraints);
        for (Map.Entry entry : hashMap.entrySet()) {
            this.mContainsConstraints.remove(entry.getKey());
            ICongruenceClosureElement iCongruenceClosureElement = (ICongruenceClosureElement)function.apply((ICongruenceClosureElement)entry.getKey());
            Set<SetConstraint<ELEM>> set = this.mSetConstraintManager.transformElements(((SetConstraintConjunction)entry.getValue()).getSetConstraints(), function);
            assert (this.mSetConstraintManager.getSingletonValues(set).isEmpty());
            SetConstraintConjunction<ICongruenceClosureElement> setConstraintConjunction = this.mCcManager.buildSetConstraintConjunction(this, iCongruenceClosureElement, set);
            this.putContainsConstraint(iCongruenceClosureElement, setConstraintConjunction);
        }
    }

    public CongruenceClosure<ELEM> getCongruenceClosure() {
        return this.mCongruenceClosure;
    }

    public HashRelation<ELEM, ELEM> getElemToExpansion() {
        HashRelation<ICongruenceClosureElement, ELEM> hashRelation = new HashRelation<ICongruenceClosureElement, ELEM>();
        for (Map.Entry<ELEM, SetConstraintConjunction<ELEM>> entry : this.mContainsConstraints.entrySet()) {
            if (!entry.getValue().hasOnlyLiterals()) continue;
            hashRelation.addAllPairs((ICongruenceClosureElement)entry.getKey(), entry.getValue().getLiterals());
        }
        return hashRelation;
    }

    public boolean isEmpty() {
        if (this.isInconsistent()) {
            return false;
        }
        return this.mContainsConstraints.isEmpty();
    }

    public Set<ELEM> getRelatedElements(ELEM ELEM) {
        assert (this.mCongruenceClosure.isRepresentative(ELEM));
        HashSet<ICongruenceClosureElement> hashSet = new HashSet<ICongruenceClosureElement>();
        Set<SetConstraint<ELEM>> object2 = this.getConstraint(ELEM);
        if (object2 != null) {
            object2.forEach(setConstraint -> setConstraint.getElementSet().forEach(hashSet::add));
        }
        for (Map.Entry<ELEM, SetConstraintConjunction<ELEM>> entry : this.getConstraints().entrySet()) {
            if (((ICongruenceClosureElement)entry.getKey()).equals(ELEM)) {
                entry.getValue().getAllRhsElements().forEach(hashSet::add);
                continue;
            }
            if (!entry.getValue().getAllRhsElements().contains(ELEM)) continue;
            entry.getValue().getAllRhsElements().forEach(hashSet::add);
            hashSet.add((ICongruenceClosureElement)entry.getKey());
        }
        hashSet.remove(ELEM);
        return hashSet;
    }

    public Set<SetConstraint<ELEM>> getContainsConstraint(ELEM ELEM) {
        return this.getConstraint(ELEM);
    }

    public boolean isConstrained(ELEM ELEM) {
        if (ELEM != this.mCongruenceClosure.getRepresentativeElement(ELEM)) {
            throw new AssertionError((Object)"this is only called when elem is unconstrained on mCongruenceClosure.mElementTVER, right?");
        }
        return this.mContainsConstraints.get(ELEM) != null;
    }

    public Set<ELEM> getAllElementsMentionedInASetConstraint() {
        HashSet<ELEM> hashSet = new HashSet<ELEM>();
        for (Map.Entry<ELEM, SetConstraintConjunction<ELEM>> entry : this.mContainsConstraints.entrySet()) {
            hashSet.add(entry.getValue().getConstrainedElement());
            hashSet.addAll(entry.getValue().getAllRhsElements());
        }
        return hashSet;
    }
}

