/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure;

import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IElementRemovalTarget;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IRemovalInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IRestoreNodesBeforeRemove;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RemoveCcElement<ELEM extends ICongruenceClosureElement<ELEM>>
implements IRemovalInfo<ELEM>,
IRestoreNodesBeforeRemove<ELEM> {
    private final ELEM mElem;
    private final boolean mIntroduceNewNodes;
    private final boolean mMadeChanges;
    private Set<ELEM> mElementsToRemove;
    private final Set<ELEM> mElementsAlreadyRemoved = new HashSet<ELEM>();
    private final Set<ELEM> mAddedNodes;
    private boolean mDidRemoval = false;
    private CongruenceClosure<ELEM> mElementContainer;

    public RemoveCcElement(CongruenceClosure<ELEM> congruenceClosure, ELEM ELEM, boolean bl, boolean bl2) {
        assert (!ELEM.isFunctionApplication()) : "unexpected..";
        if (congruenceClosure.isInconsistent()) {
            throw new IllegalStateException();
        }
        if (congruenceClosure.isDebugMode()) {
            congruenceClosure.getLogger().debug((Object)("RemoveElement CC " + this.hashCode() + " : removing " + String.valueOf(ELEM) + " from " + congruenceClosure.hashCode()));
        }
        if (!congruenceClosure.hasElement(ELEM)) {
            this.mElem = null;
            this.mMadeChanges = false;
            this.mAddedNodes = Collections.emptySet();
            this.mIntroduceNewNodes = false;
            this.mDidRemoval = true;
            return;
        }
        this.mElementContainer = congruenceClosure;
        this.mElem = ELEM;
        this.mIntroduceNewNodes = bl;
        this.mMadeChanges = false;
        this.mAddedNodes = this.mIntroduceNewNodes ? new HashSet() : null;
    }

    public Set<ELEM> getAddedNodes() {
        assert (this.mDidRemoval);
        return this.mAddedNodes;
    }

    @Override
    public Collection<ELEM> getAlreadyRemovedElements() {
        return this.mElementsAlreadyRemoved;
    }

    public void doRemoval() {
        assert (!this.mDidRemoval);
        Object object = this.mElementContainer.collectElementsToRemove(this.mElem);
        this.mElementsToRemove = Collections.unmodifiableSet(object);
        assert (this.mElementsToRemove.stream().allMatch(iCongruenceClosureElement -> CongruenceClosure.dependsOnAny(iCongruenceClosureElement, Collections.singleton(this.mElem))));
        object = new HashMap();
        for (ICongruenceClosureElement iCongruenceClosureElement2 : this.mElementsToRemove) {
            ICongruenceClosureElement iCongruenceClosureElement3 = this.mElementContainer.getOtherEquivalenceClassMember(iCongruenceClosureElement2, this.mElementsToRemove);
            if (iCongruenceClosureElement3 == null) continue;
            object.put(iCongruenceClosureElement2, iCongruenceClosureElement3);
        }
        assert (DataStructureUtils.intersection(new HashSet(object.values()), this.mElementsToRemove).isEmpty());
        assert (this.nodeAndReplacementAreEquivalent((Map<ELEM, ELEM>)object, this.mElementContainer));
        assert (!this.mElementContainer.isInconsistent());
        boolean bl = false;
        bl = RemoveCcElement.addNodesToKeepInformation(this, this.mElementsToRemove, object);
        if (bl) {
            assert (this.mElementContainer.isInconsistent());
            this.mDidRemoval = true;
            return;
        }
        assert (this.nodeAndReplacementAreEquivalent((Map<ELEM, ELEM>)object, this.mElementContainer));
        assert (!this.mElementContainer.isInconsistent());
        assert (!this.mElementContainer.isInconsistent());
        if (this.mElementContainer.isInconsistent()) {
            return;
        }
        this.mElementContainer.removeElements(this.mElementsToRemove, (Map<ELEM, ELEM>)object);
        if (this.mElementContainer.isDebugMode() && this.mElementContainer.isInconsistent()) {
            this.mElementContainer.getLogger().debug((Object)("RemoveElement: " + this.mElementContainer.hashCode() + " became inconsistent during closure operation"));
        }
        this.mDidRemoval = true;
        if (this.mElementContainer.isDebugMode()) {
            this.mElementContainer.getLogger().debug((Object)("RemoveElement " + this.hashCode() + " finished normally"));
        }
    }

    private boolean nodeAndReplacementAreEquivalent(Map<ELEM, ELEM> map, CongruenceClosure<ELEM> congruenceClosure) {
        for (Map.Entry<ELEM, ELEM> entry : map.entrySet()) {
            if (congruenceClosure.getEqualityStatus((ICongruenceClosureElement)entry.getKey(), (ICongruenceClosureElement)entry.getValue()) == EqualityStatus.EQUAL) continue;
            assert (false);
            return false;
        }
        return true;
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> boolean addNodesToKeepInformation(IRestoreNodesBeforeRemove<ELEM> iRestoreNodesBeforeRemove, Set<ELEM> set, Map<ELEM, ELEM> map) {
        if (!iRestoreNodesBeforeRemove.isIntroduceNewNodes()) {
            return false;
        }
        while (true) {
            HashSet<ICongruenceClosureElement> hashSet = new HashSet<ICongruenceClosureElement>();
            for (ICongruenceClosureElement iCongruenceClosureElement2 : set) {
                if (!iCongruenceClosureElement2.isFunctionApplication() || !iRestoreNodesBeforeRemove.getElementContainer().isConstrained(iCongruenceClosureElement2)) continue;
                Set<ICongruenceClosureElement> set2 = iRestoreNodesBeforeRemove.getElementContainer().getNodesToIntroduceBeforeRemoval(iCongruenceClosureElement2, set, map);
                hashSet.addAll(set2);
            }
            assert (hashSet.stream().allMatch(iCongruenceClosureElement -> !CongruenceClosure.dependsOnAny(iCongruenceClosureElement, Collections.singleton(iRestoreNodesBeforeRemove.getElem()))));
            assert (hashSet.stream().allMatch(iCongruenceClosureElement -> !iRestoreNodesBeforeRemove.getElementContainer().hasElement((ICongruenceClosureElement)iCongruenceClosureElement)));
            if (hashSet.isEmpty()) break;
            if (iRestoreNodesBeforeRemove.getElementContainer().isDebugMode()) {
                iRestoreNodesBeforeRemove.getElementContainer().getLogger().debug((Object)("RemoveElement: adding nodes " + String.valueOf(hashSet)));
            }
            for (ICongruenceClosureElement iCongruenceClosureElement2 : hashSet) {
                if (iRestoreNodesBeforeRemove.getElementContainer().isDebugMode()) {
                    iRestoreNodesBeforeRemove.getElementContainer().getLogger().debug((Object)("RemoveElement: adding element " + String.valueOf(iCongruenceClosureElement2) + " to " + iRestoreNodesBeforeRemove.getElementContainer().hashCode() + " because it was added in weq graph label"));
                }
                iRestoreNodesBeforeRemove.getElementContainer().addElement(iCongruenceClosureElement2, true);
                if (!iRestoreNodesBeforeRemove.getElementContainer().isInconsistent()) continue;
                if (iRestoreNodesBeforeRemove.getElementContainer().isDebugMode()) {
                    iRestoreNodesBeforeRemove.getElementContainer().getLogger().debug((Object)("RemoveElement: " + iRestoreNodesBeforeRemove.getElementContainer().hashCode() + " became inconsistent when adding" + String.valueOf(iCongruenceClosureElement2)));
                }
                return true;
            }
            if (!iRestoreNodesBeforeRemove.isIntroduceNewNodes()) continue;
            iRestoreNodesBeforeRemove.registerAddedNodes(hashSet);
        }
        return false;
    }

    public boolean madeChanges() {
        assert (this.mDidRemoval);
        return this.mMadeChanges;
    }

    @Override
    public Set<ELEM> getRemovedElements() {
        return this.mElementsToRemove;
    }

    public String toString() {
        return this.mElementsToRemove.toString();
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> void removeSimpleElement(CongruenceClosure<ELEM> congruenceClosure, ELEM ELEM) {
        RemoveCcElement.removeSimpleElement(congruenceClosure, ELEM, true, true);
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> void removeSimpleElementDontIntroduceNewNodes(CongruenceClosure<ELEM> congruenceClosure, ELEM ELEM) {
        RemoveCcElement.removeSimpleElement(congruenceClosure, ELEM, false, false);
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> Set<ELEM> removeSimpleElementDontUseWeqGpaTrackAddedNodes(CongruenceClosure<ELEM> congruenceClosure, ELEM ELEM) {
        return RemoveCcElement.removeSimpleElement(congruenceClosure, ELEM, true, false).getAddedNodes();
    }

    private static <ELEM extends ICongruenceClosureElement<ELEM>> RemoveCcElement<ELEM> removeSimpleElement(CongruenceClosure<ELEM> congruenceClosure, ELEM ELEM, boolean bl, boolean bl2) {
        if (ELEM.isFunctionApplication()) {
            throw new IllegalArgumentException();
        }
        if (congruenceClosure.isInconsistent()) {
            throw new IllegalStateException();
        }
        assert (congruenceClosure.getElementCurrentlyBeingRemoved() == null);
        RemoveCcElement<ELEM> removeCcElement = new RemoveCcElement<ELEM>(congruenceClosure, ELEM, bl, bl2);
        if (!congruenceClosure.hasElement(ELEM)) {
            assert (!removeCcElement.madeChanges());
            assert (removeCcElement.getAddedNodes().isEmpty());
            return removeCcElement;
        }
        congruenceClosure.setElementCurrentlyBeingRemoved(removeCcElement);
        removeCcElement.doRemoval();
        assert (congruenceClosure.assertSimpleElementIsFullyRemoved(ELEM));
        congruenceClosure.setElementCurrentlyBeingRemoved(null);
        assert (congruenceClosure.assertSimpleElementIsFullyRemoved(ELEM));
        return removeCcElement;
    }

    @Override
    public boolean isIntroduceNewNodes() {
        return this.mIntroduceNewNodes;
    }

    @Override
    public ELEM getElem() {
        return this.mElem;
    }

    @Override
    public IElementRemovalTarget<ELEM> getElementContainer() {
        return this.mElementContainer;
    }

    @Override
    public void registerAddedNodes(Set<ELEM> set) {
        this.mAddedNodes.addAll(set);
    }
}

