/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.horn;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.NoopScript;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.simplification.SimplifyDDA;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.DAGSize;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;

public class HornSolver
extends NoopScript {
    HashMap<FunctionSymbol, ArrayList<HornClause>> mAllClauses = new HashMap();
    Script mBackend = new SMTInterpol();
    private int mClauseCtr = 0;
    private int mCtr = 0;

    public HornSolver() {
        this.mBackend.setOption(":produce-interpolants", (Object)Boolean.TRUE);
        this.mBackend.setOption(":verbosity", (Object)2);
    }

    public void setLogic(String string) throws UnsupportedOperationException, SMTLIBException {
        if (!string.equals("HORN")) {
            throw new SMTLIBException("No Horn logic");
        }
        super.setLogic(Logics.AUFLIRA);
        this.mBackend.setLogic(Logics.QF_LIA);
    }

    public void setOption(String string, Object object) {
        super.setOption(string, object);
        this.mBackend.setOption(string, object);
    }

    public void setInfo(String string, Object object) {
        super.setInfo(string, object);
        if (string.equals(":status")) {
            if (object.equals("sat")) {
                this.mBackend.setInfo(string, (Object)"unsat");
            } else if (object.equals("unsat")) {
                this.mBackend.setInfo(string, (Object)"sat");
            }
        }
    }

    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        ApplicationTerm applicationTerm;
        Object object;
        term = this.toPrenex(term);
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        while (term instanceof QuantifiedFormula) {
            object = (QuantifiedFormula)term;
            if (object.getQuantifier() != 1) {
                throw new SMTLIBException("Illegal Horn Clause");
            }
            arrayList.addAll(Arrays.asList(object.getVariables()));
            term = object.getSubformula();
        }
        term = this.isNegatedTerm(term) ? ((ApplicationTerm)term).getParameters()[0] : this.term("not", new Term[]{term});
        object = new ArrayDeque();
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        ((ArrayDeque)object).addLast(term);
        while (!((ArrayDeque)object).isEmpty()) {
            term = (Term)((ArrayDeque)object).removeFirst();
            if (term instanceof ApplicationTerm) {
                applicationTerm = (ApplicationTerm)term;
                if (applicationTerm.getFunction().isIntern() && applicationTerm.getFunction().getName().equals("and")) {
                    ((ArrayDeque)object).addAll(Arrays.asList(applicationTerm.getParameters()));
                    continue;
                }
                arrayList2.add(term);
                continue;
            }
            arrayList2.add(term);
        }
        applicationTerm = new ArrayList();
        ApplicationTerm applicationTerm2 = null;
        ArrayList<ApplicationTerm> arrayList3 = new ArrayList<ApplicationTerm>();
        for (Term term2 : arrayList2) {
            Term term3;
            if (this.isNegatedTerm(term2) && (term3 = ((ApplicationTerm)term2).getParameters()[0]) instanceof ApplicationTerm && !((ApplicationTerm)term3).getFunction().isIntern()) {
                if (applicationTerm2 != null) {
                    throw new SMTLIBException("Illegal Horn Clause");
                }
                applicationTerm2 = (ApplicationTerm)term3;
                continue;
            }
            if (term2 instanceof ApplicationTerm && !((ApplicationTerm)term2).getFunction().isIntern()) {
                arrayList3.add((ApplicationTerm)term2);
                continue;
            }
            applicationTerm.add(term2);
        }
        if (applicationTerm2 == null) {
            applicationTerm2 = (ApplicationTerm)this.term("false", new Term[0]);
        }
        this.addHornClause(arrayList, applicationTerm2, arrayList3, (ArrayList<Term>)applicationTerm);
        return Script.LBool.UNKNOWN;
    }

    private Term toPrenex(Term term) {
        class PrenexTransformer
        extends TermTransformer {
            LinkedHashSet<TermVariable> mTvs = new LinkedHashSet();

            PrenexTransformer() {
            }

            public void convert(Term term) {
                while (term instanceof QuantifiedFormula) {
                    QuantifiedFormula quantifiedFormula = (QuantifiedFormula)term;
                    TermVariable[] termVariableArray = quantifiedFormula.getVariables();
                    int n = termVariableArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TermVariable termVariable = termVariableArray[n2];
                        if (this.mTvs.contains(termVariable)) {
                            throw new SMTLIBException("Variable " + String.valueOf(termVariable) + " occurs more than once");
                        }
                        this.mTvs.add(termVariable);
                        ++n2;
                    }
                    term = quantifiedFormula.getSubformula();
                }
                super.convert(term);
            }
        }
        PrenexTransformer prenexTransformer = new PrenexTransformer();
        term = prenexTransformer.transform(term);
        if (!prenexTransformer.mTvs.isEmpty()) {
            TermVariable[] termVariableArray = prenexTransformer.mTvs.toArray(new TermVariable[prenexTransformer.mTvs.size()]);
            term = this.quantifier(1, termVariableArray, term, new Term[0][]);
        }
        return term;
    }

    private void addHornClause(ArrayList<TermVariable> arrayList, ApplicationTerm applicationTerm, ArrayList<ApplicationTerm> arrayList2, ArrayList<Term> arrayList3) {
        Term term = arrayList3.size() <= 1 ? (arrayList3.isEmpty() ? this.term("true", new Term[0]) : arrayList3.get(0)) : this.term("and", arrayList3.toArray(new Term[arrayList3.size()]));
        arrayList.trimToSize();
        arrayList2.trimToSize();
        ArrayList<HornClause> arrayList4 = this.mAllClauses.get(applicationTerm.getFunction());
        if (arrayList4 == null) {
            arrayList4 = new ArrayList(1);
            this.mAllClauses.put(applicationTerm.getFunction(), arrayList4);
        }
        arrayList4.add(new HornClause(arrayList, applicationTerm, arrayList2, term));
    }

    private Term translateToBackend(Term term) {
        return new TermTransformer(){

            public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
                this.setResult(HornSolver.this.mBackend.term(applicationTerm.getFunction().getName(), termArray));
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void convert(Term term) {
                if (term instanceof TermVariable) {
                    TermVariable termVariable = (TermVariable)term;
                    Sort sort = HornSolver.this.mBackend.sort(termVariable.getSort().getName(), new Sort[0]);
                    this.setResult((Term)HornSolver.this.mBackend.variable(termVariable.getName(), sort));
                    return;
                } else if (term instanceof ConstantTerm) {
                    Object object = ((ConstantTerm)term).getValue();
                    if (object instanceof BigInteger) {
                        this.setResult(HornSolver.this.mBackend.numeral((BigInteger)object));
                        return;
                    } else {
                        if (!(object instanceof BigDecimal)) throw new AssertionError((Object)("Unknown constant: " + String.valueOf(object)));
                        this.setResult(HornSolver.this.mBackend.decimal((BigDecimal)object));
                    }
                    return;
                } else {
                    super.convert(term);
                }
            }
        }.transform(term);
    }

    private boolean isNegatedTerm(Term term) {
        if (!(term instanceof ApplicationTerm)) {
            return false;
        }
        ApplicationTerm applicationTerm = (ApplicationTerm)term;
        return applicationTerm.getFunction().isIntern() && applicationTerm.getFunction().getName().equals("not");
    }

    public Script.LBool checkSat() {
        Object[] objectArray;
        TermVariable[] termVariableArray;
        Object object2;
        Object object3;
        FormulaUnLet formulaUnLet = new FormulaUnLet();
        ArrayDeque<DerivationTreeNode> arrayDeque = new ArrayDeque<DerivationTreeNode>();
        DerivationTreeNode derivationTreeNode = new DerivationTreeNode((ApplicationTerm)this.term("false", new Term[0]));
        arrayDeque.add(derivationTreeNode);
        while (!arrayDeque.isEmpty()) {
            DerivationTreeNode derivationTreeNode2 = (DerivationTreeNode)arrayDeque.removeFirst();
            ApplicationTerm applicationTerm = derivationTreeNode2.mTerm;
            object3 = this.mAllClauses.get(applicationTerm.getFunction());
            if (((ArrayList)object3).size() > 1) {
                System.err.println("Cannot solve disjunctive Horn Clauses, yet");
                return Script.LBool.UNKNOWN;
            }
            object2 = (HornClause)((ArrayList)object3).get(0);
            termVariableArray = ((HornClause)object2).mTvs.toArray(new TermVariable[((HornClause)object2).mTvs.size()]);
            objectArray = this.createConstants(termVariableArray);
            Term[] termArray = applicationTerm.getParameters();
            Term[] object4 = ((HornClause)object2).mHead.getParameters();
            Term[] termArray2 = new Term[termArray.length + 1];
            termArray2[0] = ((HornClause)object2).mPhi;
            int n = 0;
            while (n < applicationTerm.getParameters().length) {
                termArray2[n + 1] = this.term("=", new Term[]{termArray[n], object4[n]});
                ++n;
            }
            Term term = termArray2.length > 1 ? this.term("and", termArray2) : termArray2[0];
            term = this.let(termVariableArray, (Term[])objectArray, term);
            term = formulaUnLet.transform(term);
            term = this.translateToBackend(term);
            String string = "X" + this.mClauseCtr++;
            term = this.mBackend.annotate(term, new Annotation[]{new Annotation(":named", (Object)string)});
            this.mBackend.assertTerm(term);
            derivationTreeNode2.setName(this.mBackend.term(string, new Term[0]));
            derivationTreeNode2.initChildren(((HornClause)object2).mBody.size());
            int n2 = 0;
            for (ApplicationTerm applicationTerm2 : ((HornClause)object2).mBody) {
                term = formulaUnLet.transform(this.let(termVariableArray, (Term[])objectArray, (Term)applicationTerm2));
                arrayDeque.add(derivationTreeNode2.addChild(n2++, (ApplicationTerm)term));
            }
        }
        long l = System.nanoTime();
        object3 = this.mBackend.checkSat();
        System.err.println("SAT Check Time: " + (System.nanoTime() - l));
        if (object3 == Script.LBool.UNSAT) {
            object2 = new ArrayList();
            termVariableArray = new ArrayList();
            derivationTreeNode.postOrderTraverse((ArrayList<Term>)object2, (ArrayList<Integer>)termVariableArray);
            objectArray = new int[termVariableArray.size()];
            int n = 0;
            for (Integer n3 : termVariableArray) {
                objectArray[n++] = n3;
            }
            try {
                l = System.nanoTime();
                Term[] termArray = this.mBackend.getInterpolants(((ArrayList)object2).toArray(new Term[((ArrayList)object2).size()]), objectArray);
                System.err.println("Interpolation Time: " + (System.nanoTime() - l));
                derivationTreeNode.printSolution(termArray);
            }
            catch (SMTLIBException sMTLIBException) {
                System.err.println((Object)sMTLIBException);
                System.exit(1);
            }
        }
        return object3 == Script.LBool.SAT ? Script.LBool.UNSAT : Script.LBool.SAT;
    }

    private Term[] createConstants(TermVariable[] termVariableArray) {
        Term[] termArray = new Term[termVariableArray.length];
        int n = 0;
        while (n < termVariableArray.length) {
            String string = "x" + this.mCtr++;
            Sort sort = termVariableArray[n].getSort();
            this.declareFun(string, new Sort[0], sort);
            Sort sort2 = this.mBackend.sort(sort.getName(), new Sort[0]);
            this.mBackend.declareFun(string, new Sort[0], sort2);
            termArray[n] = this.term(string, new Term[0]);
            ++n;
        }
        return termArray;
    }

    public void reset() {
        super.reset();
        this.mBackend.reset();
        this.mAllClauses.clear();
        this.mCtr = 0;
        this.mClauseCtr = 0;
    }

    class DerivationTreeNode {
        ApplicationTerm mTerm;
        Term mName;
        DerivationTreeNode[] mChildren;

        public DerivationTreeNode(ApplicationTerm applicationTerm) {
            this.mTerm = applicationTerm;
        }

        public void setName(Term term) {
            this.mName = term;
        }

        public void initChildren(int n) {
            this.mChildren = new DerivationTreeNode[n];
        }

        public DerivationTreeNode addChild(int n, ApplicationTerm applicationTerm) {
            assert (this.mChildren[n] == null);
            this.mChildren[n] = new DerivationTreeNode(applicationTerm);
            return this.mChildren[n];
        }

        public int postOrderTraverse(ArrayList<Term> arrayList, ArrayList<Integer> arrayList2) {
            int n = arrayList.size();
            if (this.mChildren.length > 0) {
                n = this.mChildren[0].postOrderTraverse(arrayList, arrayList2);
                int n2 = 1;
                while (n2 < this.mChildren.length) {
                    this.mChildren[n2].postOrderTraverse(arrayList, arrayList2);
                    ++n2;
                }
            }
            arrayList.add(this.mName);
            arrayList2.add(n);
            return n;
        }

        public void printSolution(Term[] termArray) {
            this.printSolutionRec(termArray, 0);
        }

        private int printSolutionRec(Term[] termArray, int n) {
            Object object;
            DerivationTreeNode[] derivationTreeNodeArray = this.mChildren;
            int n2 = this.mChildren.length;
            int n3 = 0;
            while (n3 < n2) {
                object = derivationTreeNodeArray[n3];
                n += object.printSolutionRec(termArray, n);
                ++n3;
            }
            System.err.print(this.mTerm);
            System.err.print(" = ");
            System.err.println((Object)(n >= termArray.length ? "false" : termArray[n]));
            object = (SMTInterpol)HornSolver.this.mBackend;
            SimplifyDDA simplifyDDA = new SimplifyDDA((Script)new SMTInterpol((SMTInterpol)((Object)object), Collections.singletonMap(":check-type", "quick"), OptionMap.CopyMode.CURRENT_VALUE));
            if (n < termArray.length) {
                System.err.println("size: " + new DAGSize().size(termArray[n]));
                Term term = simplifyDDA.getSimplifiedTerm(termArray[n]);
                System.err.println("simplified: " + String.valueOf(term));
                System.err.println("simpsize: " + new DAGSize().size(term));
            }
            return n + 1;
        }
    }

    class HornClause {
        List<TermVariable> mTvs;
        ApplicationTerm mHead;
        List<ApplicationTerm> mBody;
        Term mPhi;

        public HornClause(List<TermVariable> list, ApplicationTerm applicationTerm, List<ApplicationTerm> list2, Term term) {
            this.mTvs = list;
            this.mHead = applicationTerm;
            this.mBody = list2;
            this.mPhi = term;
        }
    }
}

