/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CTranslationUtil;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import java.math.BigInteger;
import java.util.Objects;

public final class CArray
implements ICType {
    public static final int INCOMPLETE_ARRY_MAGIC_NUMBER = -1234567;
    private final RValue mBound;
    private final ICType mValueType;

    public CArray(RValue rValue, ICType iCType) {
        this.mBound = rValue;
        this.mValueType = iCType;
    }

    public RValue getBound() {
        return this.mBound;
    }

    public ICType getValueType() {
        return this.mValueType;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ARRAY#");
        StringBuilder stringBuilder2 = new StringBuilder("_");
        Expression expression = this.mBound.getValue();
        if (expression instanceof BinaryExpression || expression instanceof UnaryExpression) {
            stringBuilder2.append(expression.toString());
        }
        if (expression instanceof IntegerLiteral) {
            stringBuilder2.append(((IntegerLiteral)expression).getValue());
            stringBuilder2.append("_");
        } else if (expression instanceof IdentifierExpression) {
            stringBuilder2.append(((IdentifierExpression)expression).getIdentifier());
            stringBuilder2.append("_");
        } else {
            stringBuilder2.append("unrecognizedDimensions");
            stringBuilder2.append("_");
        }
        stringBuilder.append(stringBuilder2.toString());
        stringBuilder.append("~");
        stringBuilder.append(this.mValueType.toString());
        stringBuilder.append("#");
        return stringBuilder.toString();
    }

    @Override
    public boolean isIncomplete() {
        BigInteger bigInteger = CTranslationUtil.extractIntegerValue(this.mBound.getValue());
        if (bigInteger == null) {
            return true;
        }
        return BigInteger.valueOf(-1234567L).equals(bigInteger);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mBound, this.mValueType);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CArray cArray = (CArray)object;
        return Objects.equals(this.mBound, cArray.mBound) && Objects.equals(this.mValueType, cArray.mValueType);
    }

    @Override
    public boolean isAtomic() {
        return false;
    }
}

